/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.constant;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.constant.ConstantValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceConstantHandler
extends IntroduceHandler {
    public PyIntroduceConstantHandler() {
        super(new ConstantValidator(), PyBundle.message("refactoring.introduce.constant.dialog.title", new Object[0]));
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, ScopeOwner.class) instanceof PyFile) {
            return super.replaceExpression(expression, newExpression, operation);
        }
        return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
    }

    @Override
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        PsiFile containingFile = expression.getContainingFile();
        assert (containingFile instanceof PyFile);
        PsiElement initialPosition = AddImportHelper.getFileInsertPosition((PyFile)containingFile);
        List<PsiElement> sameFileRefs = PyIntroduceConstantHandler.collectReferencedDefinitionsInSameFile(operation);
        PsiElement maxPosition = PyIntroduceConstantHandler.getLowermostTopLevelStatement(sameFileRefs);
        if (maxPosition == null) {
            return containingFile.addBefore(declaration, initialPosition);
        }
        assert (PyUtil.isTopLevel(maxPosition));
        return containingFile.addAfter(declaration, maxPosition);
    }

    @Override
    protected Collection<String> generateSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        HashSet<String> names2 = new HashSet<String>();
        for (String name : super.generateSuggestedNames(expression)) {
            names2.add(StringUtil.toUpperCase((String)name));
        }
        return names2;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) || PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class) != null;
    }

    @Override
    protected boolean checkEnabled(@NotNull IntroduceOperation operation) {
        PsiElement selectionElement;
        PsiFile containingFile;
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(4);
        }
        if (!((containingFile = (selectionElement = PyIntroduceConstantHandler.getOriginalSelectionCoveringElement(operation.getElement())).getContainingFile()) instanceof PyFile)) {
            return false;
        }
        Editor editor2 = operation.getEditor();
        if (editor2 == null) {
            return false;
        }
        List<PsiElement> sameFileRefs = PyIntroduceConstantHandler.collectReferencedDefinitionsInSameFile(operation);
        if (!ContainerUtil.all(sameFileRefs, it -> PyUtil.isTopLevel(it))) {
            return false;
        }
        PsiElement maxPosition = PyIntroduceConstantHandler.getLowermostTopLevelStatement(sameFileRefs);
        if (maxPosition == null) {
            return true;
        }
        return PsiUtilCore.compareElementsByPosition((PsiElement)maxPosition, (PsiElement)selectionElement) <= 0 && !PsiTreeUtil.isAncestor((PsiElement)maxPosition, (PsiElement)selectionElement, (boolean)false);
    }

    @NotNull
    private static List<PsiElement> collectReferencedDefinitionsInSameFile(@NotNull IntroduceOperation operation) {
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        PsiElement selectionElement = PyIntroduceConstantHandler.getOriginalSelectionCoveringElement(operation.getElement());
        TextRange textRange = PyIntroduceConstantHandler.getTextRangeForOperationElement(operation.getElement());
        List list = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)selectionElement, (Class[])new Class[]{PyReferenceExpression.class})).filter(it -> textRange.contains(it.getTextRange()))).filter(ref -> !ref.isQualified())).flatMap(expr -> PyResolveUtil.resolveLocally(expr).stream()).filter(it -> it != null && it.getContainingFile() == operation.getFile())).toList();
        if (list == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static TextRange getTextRangeForOperationElement(@NotNull PsiElement operationElement) {
        Pair userData;
        if (operationElement == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        if ((userData = (Pair)operationElement.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) == null || userData.first == null || userData.second == null) {
            TextRange textRange = operationElement.getTextRange();
            if (textRange == null) {
                PyIntroduceConstantHandler.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = ((TextRange)userData.second).shiftRight(((PsiElement)userData.first).getTextOffset());
        if (textRange == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @NotNull
    private static PsiElement getOriginalSelectionCoveringElement(@NotNull PsiElement operationElement) {
        Pair userData;
        if (operationElement == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(10);
        }
        PsiElement psiElement = (userData = (Pair)operationElement.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) == null ? operationElement : (PsiElement)userData.first;
        if (psiElement == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement getLowermostTopLevelStatement(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(12);
        }
        return StreamEx.of(elements).map(it -> PyPsiUtils.getParentRightBefore(it, (PsiElement)it.getContainingFile())).select(PyStatement.class).max(PsiUtilCore::compareElementsByPosition).orElse(null);
    }

    @Override
    protected void showCanNotIntroduceErrorHint(@NotNull Project project, @NotNull Editor editor2) {
        if (project == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(14);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)PyBundle.message("refactoring.introduce.constant.cannot.extract.selected.expression", new Object[0]));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)this.myDialogTitle, (String)this.getHelpId());
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceConstant";
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.constant";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedDefinitionsInSameFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRangeForOperationElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalSelectionCoveringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateSuggestedNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencedDefinitionsInSameFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeForOperationElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalSelectionCoveringElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLowermostTopLevelStatement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showCanNotIntroduceErrorHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

