/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.moduleMembers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyDunderAllReference;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.move.PyMoveRefactoringUtil;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersHelper;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveSymbolResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyMoveSymbolProcessor {
    private final PsiNamedElement myMovedElement;
    private final PyFile myDestinationFile;
    private final List<UsageInfo> myUsages;
    private final List<? extends SmartPsiElementPointer<PsiNamedElement>> myAllMovedElements;
    private final List<PsiFile> myFilesWithStarUsages;
    private final Set<ScopeOwner> myScopeOwnersWithGlobal;

    public PyMoveSymbolProcessor(@NotNull PsiNamedElement element, @NotNull PyFile destination, @NotNull Collection<UsageInfo> usages, @NotNull List<? extends SmartPsiElementPointer<PsiNamedElement>> otherElements) {
        if (element == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(2);
        }
        if (otherElements == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(3);
        }
        this.myFilesWithStarUsages = new ArrayList<PsiFile>();
        this.myScopeOwnersWithGlobal = new HashSet<ScopeOwner>();
        this.myMovedElement = element;
        this.myDestinationFile = destination;
        this.myAllMovedElements = otherElements;
        this.myUsages = ContainerUtil.sorted(usages, (u1, u2) -> PsiUtilCore.compareElementsByPosition((PsiElement)u1.getElement(), (PsiElement)u2.getElement()));
    }

    @NotNull
    public final PyMoveSymbolResult moveElement() {
        PsiElement oldElementBody = PyMoveModuleMembersHelper.expandNamedElementBody(this.myMovedElement);
        if (oldElementBody != null) {
            PyClassRefactoringUtil.rememberNamedReferences(oldElementBody, new String[0]);
            PsiElement newElementBody = this.addElementToFile(oldElementBody);
            PsiNamedElement newElement = PyMoveModuleMembersHelper.extractNamedElement(newElementBody);
            assert (newElement != null);
            for (UsageInfo usage : this.myUsages) {
                PsiElement usageElement = usage.getElement();
                if (usageElement == null) continue;
                this.updateSingleUsage(usageElement, newElement);
            }
            PsiElement[] unwrappedElements = ContainerUtil.mapNotNull(this.myAllMovedElements, SmartPsiElementPointer::getElement).toArray(PsiElement.EMPTY_ARRAY);
            PyClassRefactoringUtil.restoreNamedReferences(newElementBody, (PsiElement)this.myMovedElement, unwrappedElements);
            this.deleteElement();
        }
        return new PyMoveSymbolResult(this.myFilesWithStarUsages);
    }

    private void deleteElement() {
        PsiElement elementBody = PyMoveModuleMembersHelper.expandNamedElementBody(this.myMovedElement);
        assert (elementBody != null);
        elementBody.delete();
    }

    @NotNull
    private PsiElement addElementToFile(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(4);
        }
        PsiElement anchor = PyMoveRefactoringUtil.findLowestPossibleTopLevelInsertionPosition(this.myUsages, this.myDestinationFile);
        PsiElement psiElement = this.myDestinationFile.addBefore(element, anchor);
        if (psiElement == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    private void updateSingleUsage(@NotNull PsiElement usage, @NotNull PsiNamedElement newElement) {
        block15: {
            block13: {
                PsiFile usageFile;
                block17: {
                    block16: {
                        PyQualifiedExpression qualifiedExpr;
                        block14: {
                            if (usage == null) {
                                PyMoveSymbolProcessor.$$$reportNull$$$0(6);
                            }
                            if (newElement == null) {
                                PyMoveSymbolProcessor.$$$reportNull$$$0(7);
                            }
                            usageFile = usage.getContainingFile();
                            if (this.belongsToSomeMovedElement(usage)) {
                                return;
                            }
                            if (!(usage instanceof PyQualifiedExpression)) break block13;
                            qualifiedExpr = (PyQualifiedExpression)usage;
                            if (this.myMovedElement instanceof PyClass && "__init__".equals(qualifiedExpr.getName())) {
                                return;
                            }
                            if (!qualifiedExpr.isQualified()) break block14;
                            PyMoveSymbolProcessor.insertQualifiedImportAndReplaceReference(newElement, qualifiedExpr);
                            break block15;
                        }
                        if (usageFile != this.myMovedElement.getContainingFile()) break block16;
                        if (usage.getParent() instanceof PyGlobalStatement) {
                            this.myScopeOwnersWithGlobal.add(ScopeUtil.getScopeOwner(usage));
                            if (((PyGlobalStatement)usage.getParent()).getGlobals().length == 1) {
                                usage.getParent().delete();
                            } else {
                                usage.delete();
                            }
                        } else if (this.myScopeOwnersWithGlobal.contains(ScopeUtil.getScopeOwner(usage))) {
                            PyMoveSymbolProcessor.insertQualifiedImportAndReplaceReference(newElement, qualifiedExpr);
                        } else {
                            PyMoveSymbolProcessor.insertImportFromAndReplaceReference(newElement, qualifiedExpr);
                        }
                        break block15;
                    }
                    PyImportStatementBase importStmt = PyImportStatementNavigator.getImportStatementByElement(usage);
                    if (importStmt == null) break block17;
                    PyClassRefactoringUtil.updateUnqualifiedImportOfElement(importStmt, newElement);
                    break block15;
                }
                if (!PyMoveSymbolProcessor.resolvesToLocalStarImport(usage)) break block15;
                PyPsiRefactoringUtil.insertImport(usage, newElement);
                this.myFilesWithStarUsages.add(usageFile);
                break block15;
            }
            if (usage instanceof PyStringLiteralExpression) {
                for (PsiReference ref : usage.getReferences()) {
                    if (ref instanceof PyDunderAllReference) {
                        usage.delete();
                        continue;
                    }
                    if (!ref.isReferenceTo((PsiElement)this.myMovedElement)) continue;
                    ref.bindToElement((PsiElement)newElement);
                }
            }
        }
    }

    private boolean belongsToSomeMovedElement(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(8);
        }
        return StreamEx.of(this.myAllMovedElements).map(SmartPsiElementPointer::getElement).nonNull().map(PyMoveModuleMembersHelper::expandNamedElementBody).anyMatch(moved -> PsiTreeUtil.isAncestor((PsiElement)moved, (PsiElement)element, (boolean)false));
    }

    private static void insertImportFromAndReplaceReference(@NotNull PsiNamedElement targetElement, @NotNull PyQualifiedExpression expression) {
        if (targetElement == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(10);
        }
        PyPsiRefactoringUtil.insertImport((PsiElement)expression, targetElement, null, true);
        PyElementGenerator generator = PyElementGenerator.getInstance(expression.getProject());
        PyExpression generated = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), expression.getReferencedName());
        expression.replace((PsiElement)generated);
    }

    private static void insertQualifiedImportAndReplaceReference(@NotNull PsiNamedElement targetElement, @NotNull PyQualifiedExpression expression) {
        if (targetElement == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(12);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(expression.getProject());
        PsiFile srcFile = targetElement.getContainingFile();
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)expression);
        if (srcFile != expression.getContainingFile()) {
            QualifiedName qualifier = QualifiedNameFinder.findCanonicalImportPath((PsiElement)srcFile, (PsiElement)expression);
            PyPsiRefactoringUtil.insertImport((PsiElement)expression, (PsiNamedElement)srcFile, null, false);
            String newQualifiedReference = qualifier + "." + expression.getReferencedName();
            expression.replace((PsiElement)generator.createExpressionFromText(languageLevel, newQualifiedReference));
        } else {
            expression.replace((PsiElement)generator.createExpressionFromText(languageLevel, expression.getReferencedName()));
        }
    }

    private static boolean resolvesToLocalStarImport(@NotNull PsiElement usage) {
        PsiFile containingFile;
        if (usage == null) {
            PyMoveSymbolProcessor.$$$reportNull$$$0(13);
        }
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (usage instanceof PyReferenceOwner) {
            TypeEvalContext context2 = TypeEvalContext.codeInsightFallback(usage.getProject());
            PsiPolyVariantReference reference = ((PyReferenceOwner)usage).getReference(PyResolveContext.implicitContext(context2));
            for (ResolveResult result : reference.multiResolve(false)) {
                resolvedElements.add(result.getElement());
            }
        } else {
            PsiReference ref = usage.getReference();
            if (ref != null) {
                resolvedElements.add(ref.resolve());
            }
        }
        if ((containingFile = usage.getContainingFile()) != null) {
            for (PsiElement resolved : resolvedElements) {
                if (!(resolved instanceof PyStarImportElement) || resolved.getContainingFile() != containingFile) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveSymbolProcessor";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveSymbolProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementToFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addElementToFile";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleUsage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "belongsToSomeMovedElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertImportFromAndReplaceReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertQualifiedImportAndReplaceReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToLocalStarImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

