/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.PathMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterpreterDirectoryMacro
extends Macro
implements PathMacro {
    @NotNull
    public String getName() {
        return "PyInterpreterDirectory";
    }

    @NotNull
    public String getDescription() {
        String string = PyBundle.message("python.sdk.directory.macro.description", new Object[0]);
        if (string == null) {
            InterpreterDirectoryMacro.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String expand(@NotNull DataContext dataContext) {
        Sdk sdk;
        Module module;
        if (dataContext == null) {
            InterpreterDirectoryMacro.$$$reportNull$$$0(1);
        }
        if ((module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext)) == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return null;
            }
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length == 0) {
                return null;
            }
            module = modules[0];
        }
        if ((sdk = PythonSdkUtil.findPythonSdk(module)) != null) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null) {
                return null;
            }
            String path = PathUtil.getLocalPath((VirtualFile)homeDir.getParent());
            if (path != null) {
                return FileUtil.toSystemDependentName((String)path);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/InterpreterDirectoryMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/InterpreterDirectoryMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

