/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a4\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u001a4\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u00a8\u0006\u0016"}, d2={"getPathsToTransfer", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "removeTransferredRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "removeTransferredRootsFromModulesWithInheritedSdk", "project", "Lcom/intellij/openapi/project/Project;", "removeTransferredRootsFromModulesWithSdk", "setPathsToTransfer", "roots", "transferRoots", "transferRootsToModulesWithInheritedSdk", "transferRootsToModulesWithSdk", "updateRootsForModulesWithInheritedSdk", "action", "Lkotlin/Function2;", "updateRootsForModulesWithSdk", "intellij.python.community.impl"})
public final class PyTransferredSdkRootsKt {
    public static final void transferRootsToModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithSdk.1.INSTANCE));
    }

    public static final void transferRootsToModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithInheritedSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithInheritedSdk.1.INSTANCE));
    }

    @NotNull
    public static final Set<VirtualFile> getPathsToTransfer(@NotNull Sdk sdk) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        if ((object = (PythonSdkAdditionalData)sdkAdditionalData) == null || (object = ((PythonSdkAdditionalData)object).getPathsToTransfer()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    public static final void setPathsToTransfer(@NotNull Sdk sdk, @NotNull Set<? extends VirtualFile> roots) {
        block4: {
            block2: {
                block3: {
                    Application app$iv;
                    Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                    Intrinsics.checkNotNullParameter(roots, (String)"roots");
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                    if (!application.isDispatchThread()) break block2;
                    boolean bl = false;
                    Collection collection = roots;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) break block3;
                    collection = PyTransferredSdkRootsKt.getPathsToTransfer(sdk);
                    bl2 = false;
                    if (!(!collection.isEmpty())) break block4;
                }
                PySdkExtKt.getOrCreateAdditionalData(sdk).setPathsToTransferFromVirtualFiles(roots);
                break block4;
            }
            boolean $i$f$invokeLater = false;
            Application application = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(roots, sdk){
                final /* synthetic */ Set $roots$inlined;
                final /* synthetic */ Sdk $sdk$inlined;
                {
                    this.$roots$inlined = set;
                    this.$sdk$inlined = sdk;
                }

                public final void run() {
                    block3: {
                        block2: {
                            boolean bl = false;
                            Collection collection = this.$roots$inlined;
                            boolean bl2 = false;
                            if (!collection.isEmpty()) break block2;
                            collection = PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk$inlined);
                            bl2 = false;
                            if (!(!collection.isEmpty())) break block3;
                        }
                        PySdkExtKt.getOrCreateAdditionalData(this.$sdk$inlined).setPathsToTransferFromVirtualFiles(this.$roots$inlined);
                    }
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application.invokeLater(runnable, modalityState);
        }
    }

    public static final void transferRoots(@NotNull Module module, @Nullable Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk)) {
            Application app$iv;
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                PyUtil.addSourceRoots(module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(sdk));
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(module, sdk){
                    final /* synthetic */ Module $module$inlined;
                    final /* synthetic */ Sdk $sdk$inlined;
                    {
                        this.$module$inlined = module;
                        this.$sdk$inlined = sdk;
                    }

                    public final void run() {
                        boolean bl = false;
                        PyUtil.addSourceRoots(this.$module$inlined, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk$inlined));
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    public static final void removeTransferredRoots(@NotNull Module module, @Nullable Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk)) {
            Application app$iv;
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                PyUtil.removeSourceRoots(module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(sdk));
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(module, sdk){
                    final /* synthetic */ Module $module$inlined;
                    final /* synthetic */ Sdk $sdk$inlined;
                    {
                        this.$module$inlined = module;
                        this.$sdk$inlined = sdk;
                    }

                    public final void run() {
                        boolean bl = false;
                        PyUtil.removeSourceRoots(this.$module$inlined, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk$inlined));
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    private static final void updateRootsForModulesWithSdk(Project project, Sdk sdk, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk == null) {
            return;
        }
        boolean $i$f$runReadAction = false;
        Module[] moduleArray = (Module[])ApplicationManager.getApplication().runReadAction(new Computable(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project$inlined);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                return (T)moduleManager.getModules();
            }
        });
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            action.invoke((Object)module2, (Object)sdk);
        }
    }

    private static final void updateRootsForModulesWithInheritedSdk(Project project, Sdk sdk, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk == null) {
            return;
        }
        boolean $i$f$runReadAction = false;
        for (Module module : (Module[])ApplicationManager.getApplication().runReadAction(new Computable(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project$inlined);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                return (T)moduleManager.getModules();
            }
        })) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            if (!moduleRootManager.isSdkInherited()) continue;
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            action.invoke((Object)module2, (Object)sdk);
        }
    }
}

