/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IronPythonSdkFlavor
extends PythonSdkFlavor {
    public static final Pattern VERSION_RE = Pattern.compile("\\w+ ([0-9\\.]+).*");

    private IronPythonSdkFlavor() {
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public String envPathParam() {
        return "IRONPYTHONPATH";
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context2) {
        File[] dirs;
        TreeSet<String> result = new TreeSet<String>();
        String root = System.getenv("ProgramFiles(x86)");
        if (root == null) {
            root = System.getenv("ProgramFiles");
        }
        if (root != null && (dirs = new File(root).listFiles()) != null) {
            for (File dir : dirs) {
                File ipy;
                if (!dir.getName().startsWith("IronPython") || !(ipy = new File(dir, "ipy.exe")).exists()) continue;
                result.add(ipy.getPath());
            }
        }
        WinPythonSdkFlavor.findInPath(result, "ipy.exe");
        WinPythonSdkFlavor.findInPath(result, "ipy64.exe");
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        String name;
        if (file == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return (name = file.getName()).equals("ipy.exe") || name.equals("ipy64.exe");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        String match;
        if (output == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        return (match = PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE)) != null ? this.getName() + " " + match : null;
    }

    @Override
    @NotNull
    public String getVersionOption() {
        return "-V";
    }

    @Override
    @NotNull
    public Collection<String> getExtraDebugOptions() {
        List<String> list = Collections.singletonList("-X:Frames");
        if (list == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void initPythonPath(@NotNull GeneralCommandLine cmd, boolean passParentEnvs, @NotNull Collection<String> path) {
        if (cmd == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if (path == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    @Override
    public void initPythonPath(@NotNull Collection<String> path, boolean passParentEnvs, @NotNull Map<String, String> env) {
        if (path == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        if (env == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(7);
        }
        PythonEnvUtil.addToEnv("IRONPYTHONPATH", StringUtil.join(path, (String)File.pathSeparator), env);
    }

    @Override
    @NotNull
    public String getName() {
        return "IronPython";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Dotnet;
        if (icon == null) {
            IronPythonSdkFlavor.$$$reportNull$$$0(8);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/IronPythonSdkFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraDebugOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

