/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyAddExistingPoetryEnvPanel;
import com.jetbrains.python.sdk.poetry.PyAddNewPoetryPanel;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import icons.PythonIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.tuweni.toml.Toml;
import org.apache.tuweni.toml.TomlTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00c2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0*2\b\u00104\u001a\u0004\u0018\u000105\u001a\u0012\u00106\u001a\u00020\u00182\b\u00104\u001a\u0004\u0018\u000105H\u0002\u001a:\u00107\u001a\u0002082\b\u00104\u001a\u0004\u0018\u0001052\b\u00109\u001a\u0004\u0018\u00010\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0*2\b\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020=\u001a.\u0010>\u001a\b\u0012\u0004\u0012\u00020?0*2\b\u00109\u001a\u0004\u0018\u00010\u001f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00030A2\b\u0010B\u001a\u0004\u0018\u00010\u0003\u001a\b\u0010C\u001a\u0004\u0018\u00010D\u001a\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010B\u001a\u00020\u0003\u001a\b\u0010F\u001a\u0004\u0018\u00010D\u001a\u001c\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00122\u0006\u0010/\u001a\u00020\u0014\u001a\u000e\u0010H\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u0003\u001a\u0015\u0010J\u001a\u0004\u0018\u00010\u00182\u0006\u0010B\u001a\u00020\u0003\u00a2\u0006\u0002\u0010K\u001a\u001a\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u00020\u0003\u001a4\u0010P\u001a\u00020\u00032\u000b\u0010B\u001a\u00070\u0003\u00a2\u0006\u0002\b\"2\u0006\u0010Q\u001a\u00020\u00032\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u0003\u00a2\u0006\u0002\u0010T\u001a.\u0010U\u001a\u00020\u00032\r\u0010B\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\"2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u0003\u00a2\u0006\u0002\u0010V\u001a'\u0010U\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u001a2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u0003\u00a2\u0006\u0002\u0010X\u001a$\u0010Y\u001a\u00020Z2\u0006\u00109\u001a\u00020\u001f2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010[\u001a\u00020\u0003\u001a\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00030A2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u001a0*\u001a2\u0010^\u001a\u00070\u0003\u00a2\u0006\u0002\b\"2\u000b\u0010B\u001a\u00070\u0003\u00a2\u0006\u0002\b\"2\b\u0010_\u001a\u0004\u0018\u00010\u00032\u0006\u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020\u0018\u001aR\u0010b\u001a\u0004\u0018\u00010\u001a2\b\u00104\u001a\u0004\u0018\u0001052\b\u00109\u001a\u0004\u0018\u00010\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0*2\b\u0010;\u001a\u0004\u0018\u00010\u00032\b\u0010_\u001a\u0004\u0018\u00010\u00032\u0006\u0010`\u001a\u00020\u00182\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010c\u001a\u00070\u0003\u00a2\u0006\u0002\bd2\u000b\u0010e\u001a\u00070\u0003\u00a2\u0006\u0002\bd\u001aZ\u0010f\u001a\u0002Hg\"\u0006\b\u0000\u0010g\u0018\u00012\r\u0010B\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\"2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u00032\u0006\u0010h\u001a\u0002Hg2\u0014\b\u0004\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002Hg0jH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010k\u001a\u0017\u0010l\u001a\u0004\u0018\u00010m2\r\u0010n\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\"\u001a\u0016\u0010o\u001a\u0004\u0018\u00010\u001f*\u00020\u00142\u0006\u00104\u001a\u000205H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\r\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"+\u0010\u0010\u001a\u001c\u0012\u0004\u0012\u00020\u0003\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"(\u0010\u0019\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001d\"\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u0014*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"6\u0010#\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\"*\u00020$2\r\u0010\u0017\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\"\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030**\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\"\u0017\u0010-\u001a\u0004\u0018\u00010\u0014*\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010!\"\u001a\u0010/\u001a\u0004\u0018\u00010\u0014*\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006p"}, d2={"LOCK_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "POETRY_DEFAULT_SOURCE_URL", "", "POETRY_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getPOETRY_ICON", "()Ljavax/swing/Icon;", "POETRY_LOCK", "POETRY_PATH_SETTING", "PY_PROJECT_TOML", "REPLACE_PYTHON_VERSION", "poetryVersion", "getPoetryVersion", "()Ljava/lang/String;", "pyProjectTomlCache", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPyProjectTomlCache", "()Ljava/util/Map;", "value", "", "isPoetry", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "setPoetry", "(Lcom/intellij/openapi/projectRoots/Sdk;Z)V", "poetryLock", "Lcom/intellij/openapi/module/Module;", "getPoetryLock", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/SystemDependent;", "poetryPath", "Lcom/intellij/ide/util/PropertiesComponent;", "getPoetryPath", "(Lcom/intellij/ide/util/PropertiesComponent;)Ljava/lang/String;", "setPoetryPath", "(Lcom/intellij/ide/util/PropertiesComponent;Ljava/lang/String;)V", "poetrySources", "", "getPoetrySources", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/util/List;", "pyProjectToml", "getPyProjectToml", "virtualFile", "Lcom/intellij/openapi/editor/Document;", "getVirtualFile", "(Lcom/intellij/openapi/editor/Document;)Lcom/intellij/openapi/vfs/VirtualFile;", "allModules", "project", "Lcom/intellij/openapi/project/Project;", "allowCreatingNewEnvironments", "createPoetryPanel", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "module", "existingSdks", "newProjectPath", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "detectPoetryEnvs", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "existingSdkPaths", "", "projectPath", "detectPoetryExecutable", "Ljava/io/File;", "getPoetryEnvs", "getPoetryExecutable", "getPyProjectTomlForPoetry", "getPythonExecutable", "homePath", "isVirtualEnvsInProject", "(Ljava/lang/String;)Ljava/lang/Boolean;", "parsePoetryShowOutdated", "", "Lcom/jetbrains/python/sdk/poetry/PoetryOutdatedVersion;", "input", "runCommand", "command", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "runPoetry", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "sdk", "(Lcom/intellij/openapi/projectRoots/Sdk;[Ljava/lang/String;)Ljava/lang/String;", "runPoetryInBackground", "", "description", "sdkHomes", "sdks", "setupPoetry", "python", "installPackages", "init", "setupPoetrySdkUnderProgress", "suggestedSdkName", "Lcom/intellij/openapi/util/NlsSafe;", "basePath", "syncRunPoetry", "T", "defaultResult", "callback", "Lkotlin/Function1;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "validatePoetryExecutable", "Lcom/intellij/openapi/ui/ValidationInfo;", "poetryExecutable", "getModule", "intellij.python.community.impl"})
public final class PoetryKt {
    @NotNull
    public static final String PY_PROJECT_TOML = "pyproject.toml";
    @NotNull
    public static final String POETRY_LOCK = "poetry.lock";
    @NotNull
    public static final String POETRY_DEFAULT_SOURCE_URL = "https://pypi.org/simple";
    @NotNull
    public static final String POETRY_PATH_SETTING = "PyCharm.Poetry.Path";
    @NotNull
    public static final String REPLACE_PYTHON_VERSION = "import re,sys;f=open(\"pyproject.toml\", \"r+\");orig=f.read();f.seek(0);f.write(re.sub(r\"(python = \\\"\\^)[^\\\"]+(\\\")\", \"\\g<1>\"+'.'.join(str(v) for v in sys.version_info[:2])+\"\\g<2>\", orig))";
    @NotNull
    private static final Icon POETRY_ICON;
    @NotNull
    private static final Map<String, Pair<Long, VirtualFile>> pyProjectTomlCache;
    private static final NotificationGroup LOCK_NOTIFICATION_GROUP;

    @NotNull
    public static final Icon getPOETRY_ICON() {
        return POETRY_ICON;
    }

    @NotNull
    public static final Pair<Long, VirtualFile> getPyProjectTomlForPoetry(@NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        Long l;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Long l2 = virtualFile.getModificationStamp();
        try {
            l = l2;
            virtualFile2 = (VirtualFile)ReadAction.compute((ThrowableComputable)new ThrowableComputable(virtualFile){
                final /* synthetic */ VirtualFile $virtualFile;

                public final VirtualFile compute() {
                    VirtualFile virtualFile;
                    TomlTable tomlTable = Toml.parse(this.$virtualFile.getInputStream()).getTable("tool.poetry");
                    if (tomlTable != null) {
                        TomlTable tomlTable2 = tomlTable;
                        boolean bl = false;
                        boolean bl2 = false;
                        TomlTable it = tomlTable2;
                        boolean bl3 = false;
                        virtualFile = this.$virtualFile;
                    } else {
                        virtualFile = null;
                    }
                    return virtualFile;
                }
                {
                    this.$virtualFile = virtualFile;
                }
            });
        }
        catch (Throwable throwable) {
            l = l2;
            virtualFile2 = null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Long l3 = l;
        return new Pair((Object)l3, (Object)virtualFile3);
    }

    @NotNull
    public static final Map<String, Pair<Long, VirtualFile>> getPyProjectTomlCache() {
        return pyProjectTomlCache;
    }

    @Nullable
    public static final VirtualFile getPyProjectToml(@NotNull Module $this$pyProjectToml) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$pyProjectToml, (String)"$this$pyProjectToml");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir($this$pyProjectToml);
        if (virtualFile != null && (virtualFile = virtualFile.findChild(PY_PROJECT_TOML)) != null) {
            Pair<Long, VirtualFile> pair;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append($this$pyProjectToml.getName());
            VirtualFile virtualFile4 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"virtualFile");
            String string = stringBuilder.append(virtualFile4.getPath()).toString();
            boolean bl4 = false;
            boolean bl5 = false;
            String key = string;
            boolean bl6 = false;
            Map<String, Pair<Long, VirtualFile>> $this$getOrPut$iv = pyProjectTomlCache;
            boolean $i$f$getOrPut = false;
            Pair<Long, VirtualFile> value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl7 = false;
                Pair<Long, VirtualFile> answer$iv = PoetryKt.getPyProjectTomlForPoetry(virtualFile3);
                $this$getOrPut$iv.put(key, answer$iv);
                pair = answer$iv;
            } else {
                pair = value$iv;
            }
            Pair<Long, VirtualFile> pair2 = pair;
            boolean bl8 = false;
            boolean bl9 = false;
            Pair<Long, VirtualFile> pair3 = pair2;
            boolean bl10 = false;
            long l = virtualFile3.getModificationStamp();
            if (l == ((Number)pair3.getFirst()).longValue()) {
                object = (VirtualFile)pair3.getSecond();
            } else {
                Pair<Long, VirtualFile> pair4 = pyProjectTomlCache.put(key, PoetryKt.getPyProjectTomlForPoetry(virtualFile3));
                object = pair4 != null ? (VirtualFile)pair4.getSecond() : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final String getPoetryPath(@NotNull PropertiesComponent $this$poetryPath) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryPath, (String)"$this$poetryPath");
        return $this$poetryPath.getValue(POETRY_PATH_SETTING);
    }

    public static final void setPoetryPath(@NotNull PropertiesComponent $this$poetryPath, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryPath, (String)"$this$poetryPath");
        $this$poetryPath.setValue(POETRY_PATH_SETTING, value);
    }

    @Nullable
    public static final File detectPoetryExecutable() {
        String name = SystemInfo.isWindows ? "poetry.bat" : "poetry";
        File file = PathEnvironmentVariableUtil.findInPath((String)name);
        if (file == null) {
            String string = System.getProperty("user.home");
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String homePath2 = string2;
                boolean bl3 = false;
                File file2 = new File(homePath2 + File.separator + ".poetry" + File.separator + "bin" + File.separator + name);
                boolean bl4 = false;
                boolean bl5 = false;
                File it = file2;
                boolean bl6 = false;
                file = it.exists() ? file2 : null;
            } else {
                file = null;
            }
        }
        return file;
    }

    @Nullable
    public static final File getPoetryExecutable() {
        Object object;
        block3: {
            block2: {
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
                object = PoetryKt.getPoetryPath(propertiesComponent);
                if (object == null) break block2;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object2 = new File((String)it);
                bl = false;
                bl2 = false;
                it = object2;
                boolean bl4 = false;
                object = ((File)it).exists() ? object2 : null;
                if (object != null) break block3;
            }
            object = PoetryKt.detectPoetryExecutable();
        }
        return object;
    }

    @Nullable
    public static final ValidationInfo validatePoetryExecutable(@Nullable String poetryExecutable) {
        ValidationInfo validationInfo;
        String message;
        String string;
        CharSequence charSequence = poetryExecutable;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = PyBundle.message("python.sdk.poetry.executable.not.found", new Object[0]);
        } else {
            File file = new File(poetryExecutable);
            string = !file.exists() ? "File " + file.getAbsolutePath() + " is not found" : (!file.canExecute() || !file.isFile() ? "Cannot execute " + file.getAbsolutePath() : null);
        }
        String string2 = message = string;
        if (string2 != null) {
            charSequence = string2;
            bl = false;
            bl2 = false;
            CharSequence it = charSequence;
            boolean bl3 = false;
            validationInfo = new ValidationInfo((String)it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    public static final String suggestedSdkName(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return "Poetry (" + PathUtil.getFileName((String)basePath) + ')';
    }

    @Nullable
    public static final Sdk setupPoetrySdkUnderProgress(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks2, @Nullable String newProjectPath, @Nullable String python, boolean installPackages, @Nullable String poetryPath) {
        Sdk sdk;
        String string;
        Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
        String string2 = newProjectPath;
        if (string2 == null) {
            Module module2 = module;
            string2 = string = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
        }
        if (string2 == null) {
            string = project != null ? project.getBasePath() : null;
        }
        if (string == null) {
            return null;
        }
        String projectPath = string;
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(poetryPath, projectPath, python, installPackages, (Project)project, (Project)project, "Setting Up Poetry Environment", true){
            final /* synthetic */ String $poetryPath;
            final /* synthetic */ String $projectPath;
            final /* synthetic */ String $python;
            final /* synthetic */ boolean $installPackages;
            final /* synthetic */ Project $project;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                String string;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string2 = this.$poetryPath;
                if (string2 instanceof String) {
                    string = this.$poetryPath;
                } else {
                    Pair<Long, VirtualFile> pair;
                    VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(this.$projectPath);
                    if (virtualFile != null && (virtualFile = virtualFile.findChild("pyproject.toml")) != null) {
                        VirtualFile virtualFile2 = virtualFile;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl3 = false;
                        VirtualFile virtualFile3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                        pair = PoetryKt.getPyProjectTomlForPoetry(virtualFile3);
                    } else {
                        pair = null;
                    }
                    boolean init = pair == null;
                    String string3 = FileUtil.toSystemDependentName((String)this.$projectPath);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.toSystemDependentName(projectPath)");
                    string = PoetryKt.setupPoetry(string3, this.$python, this.$installPackages, init);
                }
                String poetry = string;
                return PoetryKt.getPythonExecutable(poetry);
            }
            {
                this.$poetryPath = $captured_local_variable$0;
                this.$projectPath = $captured_local_variable$1;
                this.$python = $captured_local_variable$2;
                this.$installPackages = $captured_local_variable$3;
                this.$project = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        Sdk sdk2 = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), existingSdks2, null, projectPath, PoetryKt.suggestedSdkName(projectPath));
        if (sdk2 != null) {
            Sdk sdk3 = sdk2;
            boolean bl = false;
            boolean bl2 = false;
            Sdk $this$apply = sdk3;
            boolean bl3 = false;
            PoetryKt.setPoetry($this$apply, true);
            Object object = module;
            if (object == null) {
                Object[] objectArray = project;
                object = project != null && (objectArray = PyStatisticToolsKt.getModules((Project)objectArray)) != null ? (Module)ArraysKt.firstOrNull((Object[])objectArray) : null;
            }
            PySdkExtKt.associateWithModule($this$apply, object, newProjectPath);
            sdk = sdk3;
        } else {
            sdk = null;
        }
        return sdk;
    }

    public static /* synthetic */ Sdk setupPoetrySdkUnderProgress$default(Project project, Module module, List list, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        return PoetryKt.setupPoetrySdkUnderProgress(project, module, list, string, string2, bl, string3);
    }

    @NotNull
    public static final String setupPoetry(@NotNull String projectPath, @Nullable String python, boolean installPackages, boolean init) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (init) {
            Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])new String[]{"init", "-n"});
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PoetryKt.runPoetry(projectPath, Arrays.copyOf(stringArray, stringArray.length));
            if (python != null) {
                PoetryKt.runCommand(projectPath, python, "-c", REPLACE_PYTHON_VERSION);
            }
        }
        if (installPackages) {
            String string = python;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                PoetryKt.runPoetry(projectPath, "env", "use", it);
            }
            PoetryKt.runPoetry(projectPath, "install");
        } else if (python != null) {
            PoetryKt.runPoetry(projectPath, "env", "use", python);
        } else {
            PoetryKt.runPoetry(projectPath, "run", "python", "-V");
        }
        return PoetryKt.runPoetry(projectPath, "env", "info", "-p");
    }

    public static final boolean isPoetry(@NotNull Sdk $this$isPoetry) {
        Intrinsics.checkNotNullParameter((Object)$this$isPoetry, (String)"$this$isPoetry");
        return $this$isPoetry.getSdkAdditionalData() instanceof PyPoetrySdkAdditionalData;
    }

    public static final void setPoetry(@NotNull Sdk $this$isPoetry, boolean value) {
        SdkAdditionalData sdkAdditionalData;
        Intrinsics.checkNotNullParameter((Object)$this$isPoetry, (String)"$this$isPoetry");
        SdkAdditionalData oldData = $this$isPoetry.getSdkAdditionalData();
        SdkAdditionalData newData = value ? (SdkAdditionalData)((sdkAdditionalData = oldData) instanceof PythonSdkAdditionalData ? new PyPoetrySdkAdditionalData((PythonSdkAdditionalData)oldData) : new PyPoetrySdkAdditionalData()) : ((sdkAdditionalData = oldData) instanceof PyPoetrySdkAdditionalData ? (SdkAdditionalData)new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor($this$isPoetry)) : oldData);
        SdkModificator sdkModificator = $this$isPoetry.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"sdkModificator");
        SdkModificator modificator = sdkModificator;
        modificator.setSdkAdditionalData(newData);
        ApplicationManager.getApplication().runWriteAction(new Runnable(modificator){
            final /* synthetic */ SdkModificator $modificator;

            public final void run() {
                this.$modificator.commitChanges();
            }
            {
                this.$modificator = sdkModificator;
            }
        });
    }

    @NotNull
    public static final String runPoetry(@NotNull Sdk sdk, String ... args2) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        String string = PySdkExtKt.getAssociatedModulePath(sdk);
        if (string == null) {
            throw (Throwable)((Object)new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.no.project.message", new Object[0]), "Poetry", CollectionsKt.emptyList(), new ProcessOutput()));
        }
        String projectPath = string;
        String[] stringArray = new String[3];
        stringArray[0] = "env";
        stringArray[1] = "use";
        String string2 = sdk.getHomePath();
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.homePath!!");
        stringArray[2] = string2;
        PoetryKt.runPoetry(projectPath, stringArray);
        return PoetryKt.runPoetry(projectPath, Arrays.copyOf(args2, args2.length));
    }

    @NotNull
    public static final String runPoetry(@Nullable String projectPath, String ... args2) {
        ProcessOutput processOutput;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Object object = PoetryKt.getPoetryExecutable();
        if (object == null || (object = ((File)object).getPath()) == null) {
            throw (Throwable)((Object)new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.no.poetry.message", new Object[0]), "poetry", CollectionsKt.emptyList(), new ProcessOutput()));
        }
        Object executable = object;
        List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)executable), (Object[])args2);
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withWorkDirectory(projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(comma\u2026orkDirectory(projectPath)");
        GeneralCommandLine commandLine = generalCommandLine;
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        boolean bl = false;
        boolean bl2 = false;
        CapturingProcessHandler $this$with = handler;
        boolean bl3 = false;
        if (indicator != null) {
            $this$with.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
            processOutput = $this$with.runProcessWithProgressIndicator(indicator);
        } else {
            processOutput = $this$with.runProcess();
        }
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"with(handler) {\n    when\u2026   runProcess()\n    }\n  }");
        ProcessOutput result = processOutput;
        bl = false;
        bl2 = false;
        $this$with = result;
        boolean bl4 = false;
        if ($this$with.isCancelled()) {
            throw (Throwable)new RunCanceledByUserException();
        }
        if ($this$with.getExitCode() != 0) {
            throw (Throwable)((Object)new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]), (String)executable, ArraysKt.asList((Object[])args2), $this$with.getStdout(), $this$with.getStderr(), $this$with.getExitCode(), CollectionsKt.emptyList()));
        }
        String string = $this$with.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stdout");
        String string2 = string;
        boolean bl5 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public static final String runCommand(@NotNull String projectPath, @NotNull String command, String ... args2) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)command), (Object[])args2)).withWorkDirectory(projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(listO\u2026orkDirectory(projectPath)");
        GeneralCommandLine commandLine = generalCommandLine;
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        boolean bl2 = false;
        CapturingProcessHandler $this$with = handler;
        boolean bl3 = false;
        ProcessOutput processOutput = $this$with.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"with(handler) {\n    runProcess()\n  }");
        ProcessOutput result = processOutput;
        bl = false;
        bl2 = false;
        $this$with = result;
        boolean bl4 = false;
        if ($this$with.isCancelled()) {
            throw (Throwable)new RunCanceledByUserException();
        }
        if ($this$with.getExitCode() != 0) {
            throw (Throwable)((Object)new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]), command, ArraysKt.asList((Object[])args2), $this$with.getStdout(), $this$with.getStderr(), $this$with.getExitCode(), CollectionsKt.emptyList()));
        }
        String string = $this$with.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(result) {\n    @Supp\u2026 else -> stdout\n    }\n  }");
        return string;
    }

    @NotNull
    public static final List<String> getPoetrySources(@NotNull Sdk $this$poetrySources) {
        Intrinsics.checkNotNullParameter((Object)$this$poetrySources, (String)"$this$poetrySources");
        return CollectionsKt.listOf((Object)POETRY_DEFAULT_SOURCE_URL);
    }

    private static final VirtualFile getVirtualFile(Document $this$virtualFile) {
        return FileDocumentManager.getInstance().getFile($this$virtualFile);
    }

    private static final Module getModule(VirtualFile $this$getModule, Project project) {
        return ModuleUtil.findModuleForFile((VirtualFile)$this$getModule, (Project)project);
    }

    private static final VirtualFile getPoetryLock(Module $this$poetryLock) {
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir($this$poetryLock);
        return virtualFile != null ? virtualFile.findChild(POETRY_LOCK) : null;
    }

    public static final void runPoetryInBackground(@NotNull Module module, @NotNull List<String> args2, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Task.Backgroundable task2 = new Task.Backgroundable(module, description, args2, module.getProject(), StringUtil.toTitleCase((String)description), true){
            final /* synthetic */ Module $module;
            final /* synthetic */ String $description;
            final /* synthetic */ List $args;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Sdk sdk = PySdkExtKt.getPythonSdk(this.$module);
                if (sdk == null) {
                    return;
                }
                Sdk sdk2 = sdk;
                indicator.setText(this.$description + "...");
                try {
                    Collection $this$toTypedArray$iv = this.$args;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    PoetryKt.runPoetry(sdk2, Arrays.copyOf(stringArray, stringArray.length));
                }
                catch (RunCanceledByUserException $this$toTypedArray$iv) {
                }
                catch (ExecutionException e) {
                    String string = PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026.running.poetry.message\")");
                    PySdkExtKt.showSdkExecutionException(sdk2, e, string);
                }
                finally {
                    VirtualFile virtualFile = PythonSdkUtil.getSitePackagesDirectory(sdk2);
                    if (virtualFile != null) {
                        virtualFile.refresh(true, true);
                    }
                    VirtualFile virtualFile2 = PySdkExtKt.getAssociatedModuleDir(sdk2);
                    if (virtualFile2 != null) {
                        virtualFile2.refresh(true, false);
                    }
                    PyPackageManager.getInstance(sdk2).refreshAndGetPackages(true);
                }
            }
            {
                this.$module = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                this.$args = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static final boolean allowCreatingNewEnvironments(Project project) {
        return project != null || !PlatformUtils.isPyCharm() || PlatformUtils.isPyCharmEducational();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PyAddSdkPanel createPoetryPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks2, @Nullable String newProjectPath, @NotNull UserDataHolder context2) {
        boolean bl;
        List panels;
        PyAddExistingPoetryEnvPanel existingPoetryPanel;
        PyAddNewPoetryPanel newPoetryPanel;
        block4: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            newPoetryPanel = PoetryKt.allowCreatingNewEnvironments(project) ? new PyAddNewPoetryPanel(project, module, existingSdks2, null, context2) : null;
            existingPoetryPanel = new PyAddExistingPoetryEnvPanel(project, module, existingSdks2, null, context2);
            panels = CollectionsKt.listOfNotNull((Object[])new PyAddSdkPanel[]{newPoetryPanel, existingPoetryPanel});
            Set<String> existingSdkPaths = PoetryKt.sdkHomes(existingSdks2);
            Object object = project;
            if (object == null || (object = object.getBasePath()) == null) {
                object = newProjectPath;
            }
            Iterable iterable = PoetryKt.detectPoetryEnvs(module, existingSdkPaths, (String)object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv);
                    boolean bl2 = false;
                    if (!PySdkExtKt.isAssociatedWithModule((Sdk)it, module)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        PyAddSdkPanel defaultPanel = bl ? (PyAddSdkPanel)existingPoetryPanel : (newPoetryPanel != null ? (PyAddSdkPanel)newPoetryPanel : (PyAddSdkPanel)existingPoetryPanel);
        return new PyAddSdkGroupPanel(createPoetryPanel.1.INSTANCE, POETRY_ICON, panels, defaultPanel);
    }

    @NotNull
    public static final List<Module> allModules(@Nullable Project project) {
        Object object;
        block3: {
            block2: {
                object = project;
                if (object == null) break block2;
                Project project2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                object = ModuleUtil.getModulesOfType((Project)it, (ModuleType)PythonModuleTypeBase.getInstance());
                if (object == null) break block2;
                Iterable $this$sortedBy$iv = (Iterable)object;
                boolean $i$f$sortedBy = false;
                bl2 = false;
                object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Module it = (Module)a;
                        boolean bl2 = false;
                        Module module = it;
                        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"it");
                        it = (Module)b;
                        Comparable comparable = (Comparable)((Object)module.getName());
                        bl2 = false;
                        Module module2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"it");
                        String string = module2.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                });
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> sdkHomes(@NotNull List<? extends Sdk> sdks) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Iterable $this$mapNotNull$iv = sdks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getHomePath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PyDetectedSdk> detectPoetryEnvs(@Nullable Module module, @NotNull Set<String> existingSdkPaths, @Nullable String projectPath) {
        List list;
        Intrinsics.checkNotNullParameter(existingSdkPaths, (String)"existingSdkPaths");
        Object object = module;
        if (object == null || (object = BasePySdkExtKt.getBasePath(object)) == null) {
            object = projectPath;
        }
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object path = object;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = PoetryKt.getPoetryEnvs((String)path);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (existingSdkPaths.contains(PoetryKt.getPythonExecutable(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PyDetectedSdk pyDetectedSdk = new PyDetectedSdk(it);
                collection.add(pyDetectedSdk);
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getPoetryEnvs(@NotNull String projectPath) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String[] stringArray = new String[]{"env", "list", "--full-path"};
        List defaultResult$iv = CollectionsKt.emptyList();
        boolean $i$f$syncRunPoetry = false;
        try {
            void args$iv;
            list = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, (String[])args$iv, defaultResult$iv){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Object $defaultResult;
                {
                    this.$projectPath = string;
                    this.$args = stringArray;
                    this.$defaultResult = object;
                }

                public final List<? extends String> call() {
                    Object object;
                    try {
                        String result;
                        String result2 = result = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        boolean bl = false;
                        object = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)result2), (Function1)getPoetryEnvs.1.1.INSTANCE), (Function1)getPoetryEnvs.1.2.INSTANCE));
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e$iv) {
            list = defaultResult$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Boolean isVirtualEnvsInProject(@NotNull String projectPath) {
        Object var4_4;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String[] stringArray = new String[]{"config", "virtualenvs.in-project"};
        Object defaultResult$iv = null;
        boolean $i$f$syncRunPoetry = false;
        try {
            void args$iv;
            var4_4 = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, (String[])args$iv, defaultResult$iv){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Object $defaultResult;
                {
                    this.$projectPath = string;
                    this.$args = stringArray;
                    this.$defaultResult = object;
                }

                public final Boolean call() {
                    Object object;
                    try {
                        String result;
                        String it = result = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        boolean bl = false;
                        String string = it;
                        boolean bl2 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        object = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)"true");
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e$iv) {
            var4_4 = defaultResult$iv;
        }
        return var4_4;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getPoetryVersion() {
        String string;
        Object var0 = null;
        String[] stringArray = new String[]{"--version"};
        String defaultResult$iv = "";
        boolean $i$f$syncRunPoetry = false;
        try {
            void args$iv;
            void projectPath$iv;
            string = ApplicationManager.getApplication().executeOnPooledThread(new Callable((String)projectPath$iv, (String[])args$iv, defaultResult$iv){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Object $defaultResult;
                {
                    this.$projectPath = string;
                    this.$args = stringArray;
                    this.$defaultResult = object;
                }

                public final String call() {
                    Object object;
                    try {
                        String result;
                        String it = result = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        boolean bl = false;
                        object = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)it, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null));
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e$iv) {
            string = defaultResult$iv;
        }
        return string;
    }

    public static final /* synthetic */ <T> T syncRunPoetry(String projectPath, String[] args2, T defaultResult, Function1<? super String, ? extends T> callback) {
        Object object;
        int $i$f$syncRunPoetry = 0;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            object = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, args2, callback, defaultResult){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Function1 $callback;
                final /* synthetic */ Object $defaultResult;

                public final T call() {
                    Object object;
                    try {
                        String result = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        object = this.$callback.invoke((Object)result);
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return (T)object;
                }
                {
                    this.$projectPath = string;
                    this.$args = stringArray;
                    this.$callback = function1;
                    this.$defaultResult = object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            object = defaultResult;
        }
        return object;
    }

    @NotNull
    public static final String getPythonExecutable(@NotNull String homePath2) {
        Intrinsics.checkNotNullParameter((Object)homePath2, (String)"homePath");
        String string = PythonSdkUtil.getPythonExecutable(homePath2);
        if (string == null) {
            String string2 = FileUtil.join((String[])new String[]{homePath2, "bin", "python"});
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.join(homePath, \"bin\", \"python\")");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, PoetryOutdatedVersion> parsePoetryShowOutdated(@NotNull String input) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)input);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line2 = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = line2;
            Pattern pattern = Pattern.compile(" +");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\" +\")");
            List list = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
            boolean bl3 = false;
            boolean bl4 = false;
            List it = list;
            boolean bl5 = false;
            List list2 = it.size() > 3 ? list : null;
            if (list2 != null) {
                list = list2;
                bl3 = false;
                bl4 = false;
                it = list;
                boolean bl6 = false;
                pair = TuplesKt.to(it.get(0), (Object)new PoetryOutdatedVersion((String)it.get(1), (String)it.get(2)));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl7 = false;
            boolean bl8 = false;
            Pair it$iv$iv = pair2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    static {
        Icon icon = PythonIcons.Python.Virtualenv;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PythonIcons.Python.Virtualenv");
        POETRY_ICON = icon;
        boolean bl = false;
        pyProjectTomlCache = new LinkedHashMap();
        String string = PyBundle.message("python.sdk.poetry.pip.file.watcher", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026poetry.pip.file.watcher\")");
        LOCK_NOTIFICATION_GROUP = new NotificationGroup(string, NotificationDisplayType.STICKY_BALLOON, false, null, null, 24, null);
    }

    public static final /* synthetic */ VirtualFile access$getVirtualFile$p(Document $this$access_u24virtualFile_u24p) {
        return PoetryKt.getVirtualFile($this$access_u24virtualFile_u24p);
    }

    public static final /* synthetic */ Module access$getModule(VirtualFile $this$access_u24getModule, Project project) {
        return PoetryKt.getModule($this$access_u24getModule, project);
    }

    public static final /* synthetic */ VirtualFile access$getPoetryLock$p(Module $this$access_u24poetryLock_u24p) {
        return PoetryKt.getPoetryLock($this$access_u24poetryLock_u24p);
    }

    public static final /* synthetic */ NotificationGroup access$getLOCK_NOTIFICATION_GROUP$p() {
        return LOCK_NOTIFICATION_GROUP;
    }
}

