/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PyTargetsSkeletonGenerator;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\u0012\u001a\u00060\u0013R\u00020\u0001H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\n\u0010\u001b\u001a\u00060\u0013R\u00020\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator;", "skeletonPath", "", "pySdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "currentFolder", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "foundBinaries", "", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "commandBuilder", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder;", "exists", "", "name", "isLocalTarget", "runGeneration", "", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$GenerationResult;", "builder", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "TargetedBuilder", "intellij.python.community.impl"})
public final class PyTargetsSkeletonGenerator
extends PySkeletonGenerator {
    private final HelpersAwareTargetEnvironmentRequest pyRequest;
    private final Set<String> foundBinaries;

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    private final boolean isLocalTarget() {
        return this.getTargetEnvRequest() instanceof LocalTargetEnvironmentRequest;
    }

    @Override
    @NotNull
    public PySkeletonGenerator.Builder commandBuilder() {
        TargetedBuilder builder;
        block0: {
            Sdk sdk = this.mySdk;
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"mySdk");
            String string = this.mySkeletonsPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mySkeletonsPath");
            builder = new TargetedBuilder(sdk, string);
            String string2 = this.myCurrentFolder;
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            builder.workingDir(it);
        }
        return builder;
    }

    @Override
    @NotNull
    protected List<PySkeletonGenerator.GenerationResult> runGeneration(@NotNull PySkeletonGenerator.Builder builder, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.foundBinaries.clear();
        List<PySkeletonGenerator.GenerationResult> list = super.runGeneration(builder, indicator);
        Intrinsics.checkNotNullExpressionValue(list, (String)"super.runGeneration(builder, indicator)");
        List<PySkeletonGenerator.GenerationResult> results = list;
        SequencesKt.toCollection((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)results), (Function1)runGeneration.1.INSTANCE), (Function1)runGeneration.2.INSTANCE), (Collection)this.foundBinaries);
        return results;
    }

    @Override
    public boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isLocalTarget()) {
            return FileUtil.exists((String)name);
        }
        return this.foundBinaries.contains(name);
    }

    public PyTargetsSkeletonGenerator(@NotNull String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)skeletonPath, (String)"skeletonPath");
        Intrinsics.checkNotNullParameter((Object)pySdk, (String)"pySdk");
        super(skeletonPath, pySdk, currentFolder);
        Sdk sdk = this.mySdk;
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"mySdk");
        Project project2 = project;
        if (project2 == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project3 = projectManager.getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"ProjectManager.getInstance().defaultProject");
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(sdk, project2);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (helpersAwareTargetEnvironmentRequest == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        this.foundBinaries = new HashSet();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator$TargetedBuilder;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder;", "Lcom/jetbrains/python/sdk/skeletons/PySkeletonGenerator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "skeletonsPaths", "", "(Lcom/jetbrains/python/sdk/skeletons/PyTargetsSkeletonGenerator;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;)V", "doRunProcess", "Lcom/intellij/execution/process/ProcessOutput;", "listener", "Lcom/jetbrains/python/sdk/skeletons/LineWiseProcessOutputListener;", "runProcess", "runProcessWithLineOutputListener", "intellij.python.community.impl"})
    private final class TargetedBuilder
    extends PySkeletonGenerator.Builder {
        private final Sdk sdk;
        private final String skeletonsPaths;

        @Override
        @NotNull
        public ProcessOutput runProcessWithLineOutputListener(@NotNull LineWiseProcessOutputListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return this.doRunProcess(listener2);
        }

        @Override
        @NotNull
        public ProcessOutput runProcess() throws InvalidSdkException {
            return this.doRunProcess(null);
        }

        private final ProcessOutput doRunProcess(LineWiseProcessOutputListener listener2) {
            boolean bl;
            Object it;
            PythonScriptExecution generatorScriptExecution = PythonScripts.prepareHelperScriptExecution(PythonHelper.GENERATOR3, PyTargetsSkeletonGenerator.this.pyRequest);
            generatorScriptExecution.addParameter("-d");
            TargetEnvironment.DownloadRoot skeletonsDownloadRoot = new TargetEnvironment.DownloadRoot(Paths.get(this.skeletonsPaths, new String[0]), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
            Collection collection = PyTargetsSkeletonGenerator.this.getTargetEnvRequest().getDownloadVolumes();
            boolean bl2 = false;
            collection.add(skeletonsDownloadRoot);
            generatorScriptExecution.addParameter(TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)skeletonsDownloadRoot));
            List list = this.myAssemblyRefs;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"myAssemblyRefs");
            collection = list;
            bl2 = false;
            if (!collection.isEmpty()) {
                generatorScriptExecution.addParameter("-c");
                List list2 = this.myAssemblyRefs;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myAssemblyRefs");
                generatorScriptExecution.addParameter(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)";", null, null, (int)0, null, null, (int)62, null));
            }
            List list3 = this.myExtraSysPath;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"myExtraSysPath");
            collection = list3;
            bl2 = false;
            if (!collection.isEmpty()) {
                generatorScriptExecution.addParameter("-s");
                char pathSeparatorOnTarget = ((PyTargetsSkeletonGenerator)PyTargetsSkeletonGenerator.this).getTargetEnvRequest().getTargetPlatform().getPlatform().pathSeparator;
                List list4 = this.myExtraSysPath;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"myExtraSysPath");
                generatorScriptExecution.addParameter(CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)String.valueOf(pathSeparatorOnTarget), null, null, (int)0, null, null, (int)62, null));
            }
            Iterator iterator = this.myExtraArgs.iterator();
            while (iterator.hasNext()) {
                String extraArg;
                String string = extraArg = (String)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extraArg");
                generatorScriptExecution.addParameter(string);
            }
            CharSequence extraArg = this.myTargetModuleName;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!(extraArg == null || extraArg.length() == 0)) {
                String string = this.myTargetModuleName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myTargetModuleName");
                generatorScriptExecution.addParameter(string);
                extraArg = this.myTargetModulePath;
                bl3 = false;
                bl4 = false;
                if (!(extraArg == null || extraArg.length() == 0)) {
                    String string2 = this.myTargetModulePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myTargetModulePath");
                    generatorScriptExecution.addParameter(string2);
                }
            }
            if (!PyTargetsSkeletonGenerator.this.isLocalTarget()) {
                Path path = Paths.get(PyTargetsSkeletonGenerator.this.getSkeletonsPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(skeletonsPath)");
                Path path2 = path;
                Object object = ".state.json";
                boolean bl5 = false;
                Path path3 = path2.resolve((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
                Path existingStateFile = path3;
                if (PathKt.exists((Path)existingStateFile)) {
                    Path path4 = Files.createTempDirectory("generator3", new FileAttribute[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"Files.createTempDirectory(\"generator3\")");
                    TargetEnvironment.UploadRoot stateFileUploadRoot = new TargetEnvironment.UploadRoot(path4, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
                    object = PyTargetsSkeletonGenerator.this.getTargetEnvRequest().getUploadVolumes();
                    bl5 = false;
                    object.add(stateFileUploadRoot);
                    object = stateFileUploadRoot.getLocalRootPath();
                    String string = ".state.json";
                    boolean bl6 = false;
                    Path path5 = object.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
                    Files.copy(existingStateFile, path5, new CopyOption[0]);
                    generatorScriptExecution.addParameter("--state-file");
                    generatorScriptExecution.addParameter(TargetEnvironmentFunctions.getRelativeTargetPath((Function)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)stateFileUploadRoot), (String)".state.json"));
                } else {
                    generatorScriptExecution.addParameter("--init-state-file");
                }
            }
            TargetEnvironmentRequest targetEnvironmentRequest = PyTargetsSkeletonGenerator.this.getTargetEnvRequest();
            TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"TargetProgressIndicator.EMPTY");
            TargetEnvironment targetEnvironment = targetEnvironmentRequest.prepareEnvironment(targetProgressIndicator);
            Iterable $this$forEach$iv = targetEnvironment.getUploadVolumes().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TargetEnvironment.UploadableVolume)element$iv;
                bl = false;
                TargetProgressIndicator targetProgressIndicator2 = TargetProgressIndicator.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator2, (String)"TargetProgressIndicator.EMPTY");
                it.upload(".", targetProgressIndicator2);
            }
            TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(generatorScriptExecution, targetEnvironment, this.sdk, CollectionsKt.emptyList());
            Process process2 = targetEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
            String commandPresentation = targetedCommandLine.getCommandPresentation(targetEnvironment);
            CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, targetedCommandLine.getCharset(), commandPresentation);
            LineWiseProcessOutputListener lineWiseProcessOutputListener = listener2;
            if (lineWiseProcessOutputListener != null) {
                it = lineWiseProcessOutputListener;
                bl = false;
                boolean bl7 = false;
                Object it2 = it;
                boolean bl8 = false;
                capturingProcessHandler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter((LineWiseProcessOutputListener)it2));
            }
            ProcessOutput processOutput = capturingProcessHandler.runProcess();
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"capturingProcessHandler.runProcess()");
            ProcessOutput result = processOutput;
            Iterable $this$forEach$iv2 = targetEnvironment.getDownloadVolumes().values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TargetEnvironment.DownloadableVolume it3 = (TargetEnvironment.DownloadableVolume)element$iv;
                boolean bl9 = false;
                it3.download(".", (ProgressIndicator)new EmptyProgressIndicator());
            }
            return result;
        }

        public TargetedBuilder(@NotNull Sdk sdk, String skeletonsPaths) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            Intrinsics.checkNotNullParameter((Object)skeletonsPaths, (String)"skeletonsPaths");
            super(PyTargetsSkeletonGenerator.this);
            this.sdk = sdk;
            this.skeletonsPaths = skeletonsPaths;
        }
    }
}

