/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.target;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"getInterpreterVersion", "", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "project", "Lcom/intellij/openapi/project/Project;", "nullForUnparsableVersion", "", "interpreterPath", "intellij.python.community.impl"})
@JvmName(name="PyInterpreterVersionUtil")
public final class PyInterpreterVersionUtil {
    @Nullable
    public static final String getInterpreterVersion(@NotNull PyTargetAwareAdditionalData $this$getInterpreterVersion, @Nullable Project project, boolean nullForUnparsableVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getInterpreterVersion, (String)"$this$getInterpreterVersion");
        String string = $this$getInterpreterVersion.getInterpreterPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"interpreterPath");
        return PyInterpreterVersionUtil.getInterpreterVersion($this$getInterpreterVersion, project, string, nullForUnparsableVersion);
    }

    public static /* synthetic */ String getInterpreterVersion$default(PyTargetAwareAdditionalData pyTargetAwareAdditionalData, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PyInterpreterVersionUtil.getInterpreterVersion(pyTargetAwareAdditionalData, project, bl);
    }

    @Nullable
    public static final String getInterpreterVersion(@NotNull PyTargetAwareAdditionalData $this$getInterpreterVersion, @Nullable Project project, @NotNull String interpreterPath, boolean nullForUnparsableVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getInterpreterVersion, (String)"$this$getInterpreterVersion");
        Intrinsics.checkNotNullParameter((Object)interpreterPath, (String)"interpreterPath");
        TargetEnvironmentRequest targetEnvironmentRequest = $this$getInterpreterVersion.getTargetEnvironmentRequest(project);
        if (targetEnvironmentRequest == null) {
            throw (Throwable)new IllegalStateException("Unable to get target configuration from Python SDK data");
        }
        TargetEnvironmentRequest targetEnvironmentRequest2 = targetEnvironmentRequest;
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create<String>()");
        Ref result = ref;
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"Ref.create<RemoteSdkException>()");
        Ref exception = ref2;
        Task.Modal task2 = new Task.Modal($this$getInterpreterVersion, targetEnvironmentRequest2, interpreterPath, nullForUnparsableVersion, result, exception, project, project, PyBundle.message("python.sdk.getting.remote.interpreter.version", new Object[0]), true){
            final /* synthetic */ PyTargetAwareAdditionalData $this_getInterpreterVersion;
            final /* synthetic */ TargetEnvironmentRequest $targetEnvironmentRequest;
            final /* synthetic */ String $interpreterPath;
            final /* synthetic */ boolean $nullForUnparsableVersion;
            final /* synthetic */ Ref $result;
            final /* synthetic */ Ref $exception;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PythonSdkFlavor flavor = this.$this_getInterpreterVersion.getFlavor();
                if (flavor != null) {
                    try {
                        try {
                            TargetedCommandLineBuilder targetedCommandLineBuilder = new TargetedCommandLineBuilder(this.$targetEnvironmentRequest);
                            targetedCommandLineBuilder.setExePath(this.$interpreterPath);
                            targetedCommandLineBuilder.addParameter(flavor.getVersionOption());
                            TargetEnvironment targetEnvironment = this.$targetEnvironmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
                            TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
                            Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"targetedCommandLineBuilder.build()");
                            TargetedCommandLine targetedCommandLine2 = targetedCommandLine;
                            Process process2 = targetEnvironment.createProcess(targetedCommandLine2, indicator);
                            List list = targetedCommandLine2.collectCommandsSynchronously();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"targetedCommandLine.collectCommandsSynchronously()");
                            String commandLineString = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                            CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, Charsets.UTF_8, commandLineString);
                            ProcessOutput processOutput = capturingProcessHandler.runProcess();
                            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"capturingProcessHandler.runProcess()");
                            ProcessOutput processOutput2 = processOutput;
                            if (processOutput2.getExitCode() == 0) {
                                String version = flavor.getVersionStringFromOutput(processOutput2);
                                if (version != null || this.$nullForUnparsableVersion) {
                                    this.$result.set((Object)version);
                                    return;
                                }
                                throw (Throwable)new RemoteSdkException("Python interpreter returned the empty output as a version string");
                            }
                            RemoteSdkException remoteSdkException = new RemoteSdkException("Python interpreter process exited with non-zero exit code");
                            boolean bl = false;
                            boolean bl2 = false;
                            RemoteSdkException it = remoteSdkException;
                            boolean bl3 = false;
                            ExceptionsKt.addSuppressed((Throwable)it, (Throwable)((Throwable)new RuntimeExceptionWithAttachments("Exit code $" + processOutput2.getExitCode(), new Attachment[]{new Attachment("stdout.txt", processOutput2.getStdout()), new Attachment("stderr.txt", processOutput2.getStderr())})));
                            throw (Throwable)remoteSdkException;
                        }
                        catch (Exception e) {
                            RemoteSdkException remoteSdkException = RemoteSdkException.cantObtainRemoteCredentials((Throwable)e);
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)remoteSdkException), (String)"RemoteSdkException.cantObtainRemoteCredentials(e)");
                            throw (Throwable)remoteSdkException;
                        }
                    }
                    catch (RemoteSdkException e) {
                        this.$exception.set((Object)((Object)e));
                    }
                }
            }
            {
                this.$this_getInterpreterVersion = $receiver;
                this.$targetEnvironmentRequest = $captured_local_variable$1;
                this.$interpreterPath = $captured_local_variable$2;
                this.$nullForUnparsableVersion = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                this.$exception = $captured_local_variable$5;
                this.$project = $captured_local_variable$6;
                super($super_call_param$7, $super_call_param$8, $super_call_param$9);
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(task2){
                final /* synthetic */ Task.Modal $task;

                public final void run() {
                    ProgressManager.getInstance().run((Task)this.$task);
                }
                {
                    this.$task = modal;
                }
            });
        } else {
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            task2.run(progressManager.getProgressIndicator());
        }
        if (!exception.isNull()) {
            Object object = exception.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exception.get()");
            throw (Throwable)object;
        }
        return (String)result.get();
    }

    public static /* synthetic */ String getInterpreterVersion$default(PyTargetAwareAdditionalData pyTargetAwareAdditionalData, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return PyInterpreterVersionUtil.getInterpreterVersion(pyTargetAwareAdditionalData, project, string, bl);
    }
}

