/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeGreaterOrEqual;
import org.assertj.core.error.ShouldBeLessOrEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Doubles;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleAssert<SELF extends AbstractDoubleAssert<SELF>>
extends AbstractComparableAssert<SELF, Double>
implements FloatingPointNumberAssert<SELF, Double> {
    private static final Double NEGATIVE_ZERO = -0.0;
    @VisibleForTesting
    Doubles doubles = Doubles.instance();
    private final boolean isPrimitive;

    protected AbstractDoubleAssert(Double actual, Class<?> selfType) {
        super(actual, selfType);
        this.isPrimitive = false;
    }

    public AbstractDoubleAssert(double actual, Class<?> selfType) {
        super(actual, selfType);
        this.isPrimitive = true;
    }

    @Override
    public SELF isNaN() {
        this.doubles.assertIsNaN(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotNaN() {
        this.doubles.assertIsNotNaN(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveZero();
        } else {
            this.doubles.assertIsZero(this.info, (Double)this.actual);
        }
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveNonZero();
        } else {
            if (NEGATIVE_ZERO.equals(this.actual)) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            this.doubles.assertIsNotZero(this.info, (Double)this.actual);
        }
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.doubles.assertIsOne(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.doubles.assertIsPositive(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.doubles.assertIsNegative(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.doubles.assertIsNotNegative(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.doubles.assertIsNotPositive(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Double)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(double expected, Offset<Double> offset) {
        this.doubles.assertIsNotCloseTo(this.info, (Double)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Double)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Double expected, Offset<Double> offset) {
        this.doubles.assertIsNotCloseTo(this.info, (Double)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Double)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Double expected, Percentage percentage) {
        this.doubles.assertIsNotCloseToPercentage(this.info, (Double)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Double)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(double expected, Percentage percentage) {
        this.doubles.assertIsNotCloseToPercentage(this.info, (Double)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    public SELF isEqualTo(double expected) {
        if (this.noCustomComparatorSet()) {
            this.isNotNull();
            if (expected == (Double)this.actual) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            if (Double.valueOf(expected).equals(Double.NaN) && ((Double)this.actual).equals(Double.NaN)) {
                throw new AssertionError((Object)"Actual and expected values were compared with == because expected was a primitive double, the assertion failed as both were Double.NaN and Double.NaN != Double.NaN (as per Double#equals javadoc)");
            }
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(this.actual, expected, this.info.representation()));
        }
        this.doubles.assertEqual(this.info, (Double)this.actual, expected);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    public SELF isEqualTo(Double expected) {
        return (SELF)((AbstractDoubleAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isEqualTo(Double expected, Offset<Double> offset) {
        return this.isCloseTo(expected, offset);
    }

    @Override
    public SELF isEqualTo(double expected, Offset<Double> offset) {
        return this.isCloseTo(expected, offset);
    }

    public SELF isNotEqualTo(double other) {
        if (this.noCustomComparatorSet()) {
            this.isNotNull();
            if (other != (Double)this.actual) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotBeEqual.shouldNotBeEqual(this.actual, other));
        }
        this.doubles.assertNotEqual(this.info, (Double)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    public SELF isNotEqualTo(Double other) {
        return (SELF)((AbstractDoubleAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isLessThan(double other) {
        this.doubles.assertLessThan(this.info, (Double)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(double other) {
        if (this.noCustomComparatorSet()) {
            if ((Double)this.actual <= other) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeLessOrEqual.shouldBeLessOrEqual((Double)this.actual, other));
        }
        this.doubles.assertLessThanOrEqualTo(this.info, (Double)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(Double other) {
        return (SELF)((AbstractDoubleAssert)super.isLessThanOrEqualTo(other));
    }

    @Override
    public SELF isGreaterThan(double other) {
        this.doubles.assertGreaterThan(this.info, (Double)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(double other) {
        if (this.noCustomComparatorSet()) {
            if ((Double)this.actual >= other) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeGreaterOrEqual.shouldBeGreaterOrEqual((Double)this.actual, other));
        }
        this.doubles.assertGreaterThanOrEqualTo(this.info, (Double)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(Double other) {
        return (SELF)((AbstractDoubleAssert)super.isGreaterThanOrEqualTo(other));
    }

    @Override
    public SELF isBetween(Double start, Double end) {
        this.doubles.assertIsBetween(this.info, (Double)this.actual, start, end);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Double start, Double end) {
        this.doubles.assertIsStrictlyBetween(this.info, (Double)this.actual, start, end);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Double> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Double> customComparator, String customComparatorDescription) {
        this.doubles = new Doubles(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractDoubleAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.doubles = Doubles.instance();
        return (SELF)((AbstractDoubleAssert)super.usingDefaultComparator());
    }

    private void assertIsPrimitiveZero() {
        if ((Double)this.actual == 0.0) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(this.actual, 0.0, this.info.representation()));
    }

    private void assertIsPrimitiveNonZero() {
        if ((Double)this.actual != 0.0) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotBeEqual.shouldNotBeEqual(this.actual, 0.0));
    }

    private boolean noCustomComparatorSet() {
        return this.doubles.getComparator() == null;
    }

    @Override
    public SELF isFinite() {
        this.doubles.assertIsFinite(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotFinite() {
        this.doubles.assertIsNotFinite(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isInfinite() {
        this.doubles.assertIsInfinite(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotInfinite() {
        this.doubles.assertIsNotInfinite(this.info, (Double)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }
}

