/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class VirtualFilePointerTracker {
    private final Set<VirtualFilePointer> storedPointers = Collections.newSetFromMap(new IdentityHashMap());
    private Throwable trace;
    private boolean isTracking;

    public VirtualFilePointerTracker() {
        this.storePointers();
    }

    private synchronized void storePointers() {
        if (this.isTracking) {
            this.isTracking = false;
            throw new IllegalStateException("Previous test did not call assertPointersAreDisposed() - see 'Caused by:' for its stacktrace", this.trace);
        }
        this.trace = new Throwable();
        this.storedPointers.clear();
        this.storedPointers.addAll(VirtualFilePointerTracker.dumpAllPointers());
        this.isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersAreDisposed() {
        if (!this.isTracking) {
            throw new IllegalStateException("Double call of assertPointersAreDisposed() - see 'Caused by:' for the previous call", this.trace);
        }
        ArrayList<VirtualFilePointer> pointers = new ArrayList<VirtualFilePointer>(VirtualFilePointerTracker.dumpAllPointers());
        for (int i = pointers.size() - 1; i >= 0; --i) {
            VirtualFilePointer pointer = (VirtualFilePointer)pointers.get(i);
            if (!this.storedPointers.remove(pointer)) continue;
            pointers.remove(i);
        }
        try {
            Set leaked = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<VirtualFilePointer>(){

                public int hashCode(@Nullable VirtualFilePointer pointer) {
                    if (pointer == null) {
                        return 0;
                    }
                    String url = pointer.getUrl();
                    return SystemInfoRt.isFileSystemCaseSensitive ? url.hashCode() : Strings.stringHashCodeInsensitive((CharSequence)url);
                }

                public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                    return o1 == o2 || o1 != null && o2 != null && (SystemInfoRt.isFileSystemCaseSensitive ? o1.getUrl().equals(o2.getUrl()) : o1.getUrl().equalsIgnoreCase(o2.getUrl()));
                }
            });
            leaked.addAll(pointers);
            leaked.removeAll(this.storedPointers);
            for (VirtualFilePointer pointer : leaked) {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Virtual pointer '" + pointer + "' hasn't been disposed: " + ((VirtualFilePointerImpl)pointer).getStackTrace());
            }
        }
        finally {
            this.storedPointers.clear();
            this.trace = new Throwable();
            this.isTracking = false;
        }
    }

    @NotNull
    private static Collection<VirtualFilePointer> dumpAllPointers() {
        Collection collection = ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).dumpAllPointers();
        if (collection == null) {
            VirtualFilePointerTracker.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerTracker", "dumpAllPointers"));
    }
}

