/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.util.ErrorKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0005J\u0014\u0010\u001a\u001a\u00020\u00112\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0007J \u0010\u001c\u001a\u00020\u00112\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\bH\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u001e\u0010$\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "paths", "Lcom/intellij/util/SmartList;", "Ljava/nio/file/Path;", "root", "<set-?>", "", "sanitizedName", "getSanitizedName", "()Ljava/lang/String;", "setSanitizedName", "(Ljava/lang/String;)V", "sanitizedName$delegate", "Lkotlin/properties/ReadWriteProperty;", "virtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "createDir", "createVirtualDir", "dirName", "createVirtualFile", "fileName", "data", "generatePath", "suffix", "getVirtualRoot", "init", "commonPrefix", "newPath", "refreshVfs", "", "scheduleDelete", "path", "Companion", "intellij.platform.testFramework"})
public final class TemporaryDirectory
extends ExternalResource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SmartList<Path> paths = new SmartList();
    private final ReadWriteProperty sanitizedName$delegate = Delegates.INSTANCE.notNull();
    private VirtualFile virtualFileRoot;
    private Path root;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TemporaryDirectory.class, "sanitizedName", "getSanitizedName()Ljava/lang/String;", 0))};
        Companion = new Companion(null);
    }

    private final String getSanitizedName() {
        return (String)this.sanitizedName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSanitizedName(String string) {
        this.sanitizedName$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description.methodName");
        this.setSanitizedName(Companion.testNameToFileName(string));
        this.root = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    @ApiStatus.Internal
    public final void init(@NotNull String commonPrefix, @NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)commonPrefix, (String)"commonPrefix");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.root != null) {
            throw (Throwable)new IllegalStateException("Already initialized (root=" + this.root + ')');
        }
        this.setSanitizedName(commonPrefix);
        this.root = root;
    }

    private final VirtualFile getVirtualRoot() {
        VirtualFile result = this.virtualFileRoot;
        if (result == null) {
            Path path = this.root;
            Intrinsics.checkNotNull((Object)path);
            Path nioRoot = path;
            Files.createDirectories(nioRoot, new FileAttribute[0]);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(nioRoot);
            if (virtualFile == null) {
                throw (Throwable)new IllegalStateException("Cannot find virtual file by " + nioRoot);
            }
            this.virtualFileRoot = result = virtualFile;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected void after() {
        this.virtualFileRoot = null;
        this.root = null;
        if (this.paths.isEmpty()) {
            return;
        }
        int n = 0;
        List errors = new ArrayList();
        n = this.paths.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            List $this$catchAndStoreExceptions$iv = errors;
            boolean $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl2 = false;
                Object object = this.paths.get((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"paths[i]");
                PathKt.delete$default((Path)((Path)object), (boolean)false, (int)1, null);
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            --i;
        }
        this.paths.clear();
        ErrorKt.throwIfNotEmpty((List)errors);
    }

    @JvmOverloads
    @NotNull
    public final Path newPath(@Nullable String fileName, boolean refreshVfs) {
        Path path = this.generatePath(fileName);
        if (refreshVfs) {
            TemporaryDirectoryKt.refreshVfs(path);
        }
        return path;
    }

    public static /* synthetic */ Path newPath$default(TemporaryDirectory temporaryDirectory, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return temporaryDirectory.newPath(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final Path newPath(@Nullable String fileName) {
        return TemporaryDirectory.newPath$default(this, fileName, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Path newPath() {
        return TemporaryDirectory.newPath$default(this, null, false, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile(@Nullable String fileName, @Nullable String data) {
        VirtualFile virtualFile = this.getVirtualRoot();
        String string = fileName;
        if (string == null) {
            string = "";
        }
        VirtualFile result = Companion.createVirtualFile(virtualFile, TemporaryDirectoryKt.access$generateName(string), data);
        this.paths.add((Object)result.toNioPath());
        return result;
    }

    public static /* synthetic */ VirtualFile createVirtualFile$default(TemporaryDirectory temporaryDirectory, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return temporaryDirectory.createVirtualFile(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile(@Nullable String fileName) {
        return TemporaryDirectory.createVirtualFile$default(this, fileName, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualFile() {
        return TemporaryDirectory.createVirtualFile$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualDir(@Nullable String dirName) {
        VirtualFile virtualFileRoot = this.getVirtualRoot();
        Object object = WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this, dirName, virtualFileRoot){
            final /* synthetic */ TemporaryDirectory this$0;
            final /* synthetic */ String $dirName;
            final /* synthetic */ VirtualFile $virtualFileRoot;

            /*
             * WARNING - void declaration
             */
            public final VirtualFile compute() {
                void var2_2;
                String string = this.$dirName;
                if (string == null) {
                    string = "";
                }
                String name = TemporaryDirectoryKt.access$generateName(string);
                VirtualFile virtualFile = this.$virtualFileRoot.createChildDirectory(TemporaryDirectory.class, name);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFileRoot.createCh\u2026ectory::class.java, name)");
                VirtualFile result = virtualFile;
                TemporaryDirectory.access$getPaths$p(this.this$0).add((Object)result.toNioPath());
                return var2_2;
            }
            {
                this.this$0 = temporaryDirectory;
                this.$dirName = string;
                this.$virtualFileRoot = virtualFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.computeAndWa\u2026ath())\n      result\n    }");
        return (VirtualFile)object;
    }

    public static /* synthetic */ VirtualFile createVirtualDir$default(TemporaryDirectory temporaryDirectory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.createVirtualDir(string);
    }

    @JvmOverloads
    @NotNull
    public final VirtualFile createVirtualDir() {
        return TemporaryDirectory.createVirtualDir$default(this, null, 1, null);
    }

    @NotNull
    public final Path createDir() {
        Path file2 = TemporaryDirectory.newPath$default(this, null, false, 3, null);
        Files.createDirectories(file2, new FileAttribute[0]);
        return file2;
    }

    @Deprecated(message="Do not use, only for backward compatibility only.")
    public final void scheduleDelete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.paths.add((Object)path);
    }

    private final Path generatePath(String suffix) {
        String fileName = this.getSanitizedName();
        if (suffix != null) {
            CharSequence charSequence = fileName;
            boolean bl = false;
            fileName = charSequence.length() == 0 ? suffix : fileName + '_' + suffix;
        }
        Path path = this.root;
        if (path == null) {
            throw (Throwable)new IllegalStateException("not initialized yet");
        }
        Path path2 = Companion.generateTemporaryPath(fileName, path);
        this.paths.add((Object)path2);
        return path2;
    }

    public static final /* synthetic */ SmartList access$getPaths$p(TemporaryDirectory $this) {
        return $this.paths;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Path generateTemporaryPath(@NotNull String fileName, @NotNull Path root) {
        return Companion.generateTemporaryPath(fileName, root);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Path generateTemporaryPath(@NotNull String fileName) {
        return com.intellij.testFramework.TemporaryDirectory$Companion.generateTemporaryPath$default(Companion, fileName, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String testNameToFileName(@NotNull String name) {
        return Companion.testNameToFileName(name);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final VirtualFile createVirtualFile(@NotNull VirtualFile parent, @NotNull String exactFileName, @Nullable String data) {
        return Companion.createVirtualFile(parent, exactFileName, data);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory$Companion;", "", "()V", "createVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "exactFileName", "", "data", "generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "root", "testNameToFileName", "name", "intellij.platform.testFramework"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Path generateTemporaryPath(@NotNull String fileName, @NotNull Path root) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Path path2 = path = root.resolve(TemporaryDirectoryKt.access$generateName(fileName));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (PathKt.exists((Path)path2)) {
                throw (Throwable)new IllegalStateException("Path " + path + " must be unique but already exists");
            }
            return path;
        }

        public static /* synthetic */ Path generateTemporaryPath$default(Companion companion, String string, Path path, int n, Object object) {
            if ((n & 2) != 0) {
                Path path2 = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(FileUtilRt.getTempDirectory())");
                path = path2;
            }
            return companion.generateTemporaryPath(string, path);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Path generateTemporaryPath(@NotNull String fileName) {
            return com.intellij.testFramework.TemporaryDirectory$Companion.generateTemporaryPath$default(this, fileName, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final String testNameToFileName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = StringsKt.removePrefix((String)name, (CharSequence)"test");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return PathKt.sanitizeFileName$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), null, (boolean)false, (Predicate)testNameToFileName.1.INSTANCE, (int)6, null);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final VirtualFile createVirtualFile(@NotNull VirtualFile parent, @NotNull String exactFileName, @Nullable String data) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)exactFileName, (String)"exactFileName");
            Object object = WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(parent, exactFileName, data){
                final /* synthetic */ VirtualFile $parent;
                final /* synthetic */ String $exactFileName;
                final /* synthetic */ String $data;

                /*
                 * WARNING - void declaration
                 */
                public final VirtualFile compute() {
                    void var1_1;
                    VirtualFile virtualFile = this.$parent.createChildData(TemporaryDirectory.class, this.$exactFileName);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"parent.createChildData(T\u2026lass.java, exactFileName)");
                    VirtualFile result = virtualFile;
                    if (this.$data != null) {
                        CharSequence charSequence = this.$data;
                        boolean bl = false;
                        if (charSequence.length() > 0) {
                            charSequence = this.$data;
                            Charset charset = Charsets.UTF_8;
                            boolean bl2 = false;
                            CharSequence charSequence2 = charSequence;
                            if (charSequence2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            byte[] byArray = ((String)charSequence2).getBytes(charset);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                            result.setBinaryContent(byArray);
                        }
                    }
                    return var1_1;
                }
                {
                    this.$parent = virtualFile;
                    this.$exactFileName = string;
                    this.$data = string2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.computeAndWa\u2026 }\n        result\n      }");
            return (VirtualFile)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

