/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLogger;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.CoreIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    @ApiStatus.Internal
    public static final boolean IS_UNDER_SAFE_PUSH;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String ORIGINAL_TEMP_DIR;
    private static final ObjectIntMap<String> TOTAL_SETUP_COST_MILLIS;
    private static final ObjectIntMap<String> TOTAL_SETUP_COUNT;
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COST_MILLIS;
    private static final ObjectIntMap<String> TOTAL_TEARDOWN_COUNT;
    protected static final Logger LOG;
    @Nullable
    private Disposable myTestRootDisposable;
    @Nullable
    private List<Path> myPathsToKeep;
    @Nullable
    private Path myTempDir;
    private static final CodeInsightSettings defaultSettings;
    @Rule
    @NotNull
    public TestRule runBareTestRule;
    private List<Throwable> mySuppressedExceptions;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class<?> DELETE_ON_EXIT_HOOK_CLASS;

    @NotNull
    protected <R extends TestRule> R asOuterRule(@NotNull R rule) {
        if (rule == null) {
            UsefulTestCase.$$$reportNull$$$0(0);
        }
        this.runBareTestRule = RuleChain.outerRule(rule).around(this.runBareTestRule);
        R r = rule;
        if (r == null) {
            UsefulTestCase.$$$reportNull$$$0(1);
        }
        return r;
    }

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list;
        if (e == null) {
            UsefulTestCase.$$$reportNull$$$0(2);
        }
        if ((list = this.mySuppressedExceptions) == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    public UsefulTestCase() {
        this.runBareTestRule = (base, description) -> new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName();
                name = StringUtil.notNullize((String)StringUtil.substringBefore((String)name, (String)"["), (String)name);
                UsefulTestCase.this.setName(name);
                UsefulTestCase.this.checkShouldRunTest(description);
                UsefulTestCase.this.runBare((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> ((Statement)base).evaluate()));
            }
        };
    }

    public UsefulTestCase(@NotNull String name) {
        if (name == null) {
            UsefulTestCase.$$$reportNull$$$0(3);
        }
        super(name);
        this.runBareTestRule = (base, description) -> new /* invalid duplicate definition of identical inner class */;
    }

    protected void checkShouldRunTest(@NotNull Description description) throws AssumptionViolatedException {
        if (description == null) {
            UsefulTestCase.$$$reportNull$$$0(4);
        }
        Assume.assumeTrue((String)"skipped: shouldRunTest() returned false", (boolean)this.shouldRunTest());
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setupTempDir();
        boolean isStressTest = this.isStressTest();
        ApplicationManagerEx.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
        if (this.isIconRequired()) {
            try {
                IconManager.activate((IconManager)new CoreIconManager());
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void setupTempDir() throws IOException {
        if (this.myTempDir == null && this.shouldContainTempFiles()) {
            this.myTempDir = this.createGlobalTempDirectory();
        }
    }

    @ApiStatus.Internal
    @NotNull
    Path createGlobalTempDirectory() throws IOException {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        String testName = null;
        if (policy != null) {
            testName = policy.getPerTestTempDirName();
        }
        if (testName == null) {
            testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
        }
        Path result = TemporaryDirectory.generateTemporaryPath(TEMP_DIR_MARKER + testName);
        Files.createDirectories(result, new FileAttribute[0]);
        FileUtil.resetCanonicalTempPathCache((String)result.toString());
        Path path = result;
        if (path == null) {
            UsefulTestCase.$$$reportNull$$$0(5);
        }
        return path;
    }

    @ApiStatus.Internal
    void removeGlobalTempDirectory(@NotNull Path dir) throws Exception {
        if (dir == null) {
            UsefulTestCase.$$$reportNull$$$0(6);
        }
        if (this.myPathsToKeep == null || this.myPathsToKeep.isEmpty()) {
            PathKt.delete((Path)dir);
        } else {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                for (Path file2 : directoryStream) {
                    if (this.shouldKeepTmpFile(file2)) continue;
                    FileUtil.delete((Path)file2);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    protected boolean isIconRequired() {
        return false;
    }

    protected void tearDown() throws Exception {
        new RunAll(() -> {
            if (this.isIconRequired()) {
                IconManager.deactivate();
                IconLoader.clearCacheInTests();
            }
        }, () -> this.disposeRootDisposable(), () -> UsefulTestCase.cleanupSwingDataStructures(), () -> UsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
            if (this.myTempDir != null) {
                FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                try {
                    this.removeGlobalTempDirectory(this.myTempDir);
                }
                catch (Throwable e) {
                    UsefulTestCase.printThreadDump();
                    throw e;
                }
            }
        }, () -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> UsefulTestCase.clearFields((Object)this)).run(this.mySuppressedExceptions);
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull Path file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(7);
        }
        if (this.myPathsToKeep == null) {
            this.myPathsToKeep = new ArrayList<Path>();
        }
        this.myPathsToKeep.add(file2.toAbsolutePath());
    }

    private boolean shouldKeepTmpFile(@NotNull Path file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(8);
        }
        if (this.myPathsToKeep == null || this.myPathsToKeep.isEmpty()) {
            return false;
        }
        for (Path pathToKeep : this.myPathsToKeep) {
            if (!file2.equals(pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() {
        ArrayList<String> list;
        Class<?> clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String path = (String)list.get(i);
            File file2 = new File(path);
            if (!file2.delete() && file2.exists()) continue;
            Class<?> clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        if (oldCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(9);
        }
        if (currentCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(10);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(() -> {
            try {
                UsefulTestCase.checkCodeInsightSettingsNotOverwritten(settings);
            }
            catch (AssertionError error) {
                UsefulTestCase.restoreCodeInsightSettingsToAvoidInducedErrors(settings);
                throw error;
            }
        }, () -> {
            currentCodeStyleSettings.getIndentOptions(FileTypeManager.getInstance().getStdFileType("JAVA"));
            try {
                UsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).run();
    }

    private static void restoreCodeInsightSettingsToAvoidInducedErrors(@NotNull CodeInsightSettings settings) {
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(11);
        }
        CodeInsightSettings clean = new CodeInsightSettings();
        for (Field field : clean.getClass().getFields()) {
            try {
                ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            this.myTestRootDisposable = disposable = new TestDisposable();
        }
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            UsefulTestCase.$$$reportNull$$$0(12);
        }
        return disposable2;
    }

    @Deprecated
    protected final void runTest() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use runTestRunnable() to override the way tests are executed");
    }

    protected boolean shouldRunTest() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.canRun(((Object)((Object)this)).getClass())) {
            return false;
        }
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(13);
        }
        testRunnable.run();
    }

    protected void defaultRunBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(14);
        }
        try (AutoCloseable ignored = this::invokeTearDown;){
            this.invokeSetUp();
            this.runTestRunnable(testRunnable);
        }
    }

    protected final void invokeSetUp() throws Exception {
        long setupStart = System.nanoTime();
        this.setUp();
        long setupCost = (System.nanoTime() - setupStart) / 1000000L;
        this.logPerClassCost((int)setupCost, TOTAL_SETUP_COST_MILLIS, TOTAL_SETUP_COUNT);
    }

    protected void invokeTearDown() throws Exception {
        long teardownStart = System.nanoTime();
        this.tearDown();
        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
        this.logPerClassCost((int)teardownCost, TOTAL_TEARDOWN_COST_MILLIS, TOTAL_TEARDOWN_COUNT);
    }

    private void logPerClassCost(int cost, @NotNull ObjectIntMap<String> costMap, @NotNull ObjectIntMap<String> countMap) {
        int storedCost;
        String name;
        if (costMap == null) {
            UsefulTestCase.$$$reportNull$$$0(15);
        }
        if (countMap == null) {
            UsefulTestCase.$$$reportNull$$$0(16);
        }
        costMap.put((Object)name, ((storedCost = costMap.get((Object)(name = ((Object)((Object)this)).getClass().getSuperclass().getName()))) == -1 ? 0 : storedCost) + cost);
        int storedCount = countMap.get((Object)name);
        countMap.put((Object)name, storedCount == -1 ? 1 : storedCount + 1);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (ObjectIntMap.Entry entry : TOTAL_SETUP_COST_MILLIS.entries()) {
            String name = (String)entry.getKey();
            int cost = entry.getValue();
            long count = TOTAL_SETUP_COUNT.get((Object)name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count);
            totalSetup += (long)cost;
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (ObjectIntMap.Entry entry : TOTAL_TEARDOWN_COST_MILLIS.entries()) {
            String name = (String)entry.getKey();
            int cost = entry.getValue();
            long count = TOTAL_TEARDOWN_COUNT.get((Object)name);
            System.out.printf("  %s: %d ms for %d executions%n", name, cost, count);
            totalTeardown += (long)cost;
        }
        System.out.printf("Total overhead: setup %d ms, teardown %d ms%n", totalSetup, totalTeardown);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']%n", totalSetup);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']%n", totalTeardown);
    }

    public final void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        this.runBare((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> super.runTest()));
    }

    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(17);
        }
        ThrowableRunnable<Throwable> wrappedRunnable = this.wrapTestRunnable(testRunnable);
        if (this.runInDispatchThread()) {
            TestApplicationManagerKt.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait(() -> this.defaultRunBare(wrappedRunnable));
        } else {
            this.defaultRunBare(wrappedRunnable);
        }
    }

    @NotNull
    protected ThrowableRunnable<Throwable> wrapTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) {
        if (testRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(18);
        }
        Description testDescription = Description.createTestDescription(((Object)((Object)this)).getClass(), (String)this.getName());
        ThrowableRunnable throwableRunnable = () -> {
            boolean success = false;
            TestLoggerFactory.onTestStarted();
            try {
                testRunnable.run();
                success = true;
            }
            catch (AssumptionViolatedException e) {
                success = true;
                throw e;
            }
            catch (Throwable t) {
                TestLoggerFactory.logTestFailure(t);
                throw t;
            }
            finally {
                TestLoggerFactory.onTestFinished(success, testDescription);
            }
        };
        if (throwableRunnable == null) {
            UsefulTestCase.$$$reportNull$$$0(19);
        }
        return throwableRunnable;
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected static <T extends Throwable> void edt(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(20);
        }
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(21);
        }
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof Set) {
                builder.append(new TreeSet((Set)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        String string = builder.toString();
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(T @NotNull [] actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(23);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(24);
        }
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(25);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(26);
        }
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static void assertOrderedEquals(byte @NotNull [] actual, byte @NotNull [] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(27);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(28);
        }
        UsefulTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            byte a = actual[i];
            byte e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(int @NotNull [] actual, int @NotNull [] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(29);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(30);
        }
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i = 0; i < actual.length; ++i) {
            int a = actual[i];
            int e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(31);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(32);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(33);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(34);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(35);
        }
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(36);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(37);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(38);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Objects::equals);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(39);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(40);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(41);
        }
        if (predicate == null) {
            UsefulTestCase.$$$reportNull$$$0(42);
        }
        if (!UsefulTestCase.equals(actual, expected, predicate)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (a1 == null) {
            UsefulTestCase.$$$reportNull$$$0(43);
        }
        if (a2 == null) {
            UsefulTestCase.$$$reportNull$$$0(44);
        }
        if (predicate == null) {
            UsefulTestCase.$$$reportNull$$$0(45);
        }
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext() && predicate.test(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(46);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(47);
        }
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(T @NotNull [] actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(48);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(49);
        }
        UsefulTestCase.assertSameElements(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(50);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(51);
        }
        UsefulTestCase.assertSameElements(actual, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(52);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(53);
        }
        UsefulTestCase.assertSameElements("", actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (message == null) {
            UsefulTestCase.$$$reportNull$$$0(54);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(55);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(56);
        }
        if (actual.size() != expected.size() || !new LinkedHashSet<T>(expected).equals(new LinkedHashSet<T>(actual))) {
            Assert.assertEquals((String)message, new LinkedHashSet<T>(expected), new LinkedHashSet<T>(actual));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(57);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(58);
        }
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(59);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(60);
        }
        PeekableIteratorWrapper expectedIt = new PeekableIteratorWrapper(expected.iterator());
        PeekableIteratorWrapper actualIt = new PeekableIteratorWrapper(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", UsefulTestCase.toString(expected), UsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(61);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(62);
        }
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(63);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(64);
        }
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(Object @NotNull [] collection, @NotNull String separator) {
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(65);
        }
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(66);
        }
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(67);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(68);
        }
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(69);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(70);
        }
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(71);
        }
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(72);
        }
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        String string = builder.toString();
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(73);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(74);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(75);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(T @NotNull [] collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(76);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(77);
        }
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<? super T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(78);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(79);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        Set checkerSet = ContainerUtil.set((Object[])checkers);
        int i = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer condition : checkerSet) {
                Throwable error = UsefulTestCase.accepts(condition, actual);
                if (error == null) {
                    checkerSet.remove(condition);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual) {
        if (condition == null) {
            UsefulTestCase.$$$reportNull$$$0(80);
        }
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Object t;
        if (aClass == null) {
            UsefulTestCase.$$$reportNull$$$0(81);
        }
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: null"), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object object = t = o;
        if (object == null) {
            UsefulTestCase.$$$reportNull$$$0(82);
        }
        return (T)object;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(83);
        }
        Assert.assertEquals((String)collection.toString(), (long)1L, (long)collection.size());
        return collection.iterator().next();
    }

    public static <T> T assertOneElement(T @NotNull [] ts) {
        if (ts == null) {
            UsefulTestCase.$$$reportNull$$$0(84);
        }
        Assert.assertEquals((String)Arrays.toString(ts), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        if (values == null) {
            UsefulTestCase.$$$reportNull$$$0(85);
        }
        for (T v : values) {
            if (!Objects.equals(value, v)) continue;
            return;
        }
        Assert.fail((String)(value + " should be equal to one of " + Arrays.toString(values)));
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(Object @NotNull [] array) {
        if (array == null) {
            UsefulTestCase.$$$reportNull$$$0(86);
        }
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(87);
        }
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        if (errorMsg == null) {
            UsefulTestCase.$$$reportNull$$$0(88);
        }
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(89);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object @NotNull [] array) {
        if (array == null) {
            UsefulTestCase.$$$reportNull$$$0(90);
        }
        if (array.length != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
        }
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        if (c == null) {
            UsefulTestCase.$$$reportNull$$$0(91);
        }
        if (c.size() != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
        }
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            UsefulTestCase.$$$reportNull$$$0(92);
        }
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        T t = disposable;
        if (t == null) {
            UsefulTestCase.$$$reportNull$$$0(93);
        }
        return t;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(94);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(95);
        }
        UsefulTestCase.assertSameLines(null, expected, actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(96);
        }
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(97);
        }
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(98);
        }
        UsefulTestCase.assertTrue((String)("File should exist " + file2), (boolean)file2.exists());
    }

    public static void assertDoesntExist(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(99);
        }
        UsefulTestCase.assertFalse((String)("File should not exist " + file2), (boolean)file2.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        String string = name == null ? "" : PlatformTestUtil.getTestName(name, lowercaseFirstLetter);
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(100);
        }
        return string;
    }

    @NotNull
    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        String string = testName.replaceAll("_.*", "");
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(101);
        }
        return string;
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(102);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(103);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(104);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(105);
        }
        if (messageProducer == null) {
            UsefulTestCase.$$$reportNull$$$0(106);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(107);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(108);
        }
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, trimBeforeComparing, null);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        if (filePath == null) {
            UsefulTestCase.$$$reportNull$$$0(109);
        }
        if (actualText == null) {
            UsefulTestCase.$$$reportNull$$$0(110);
        }
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText, trimBeforeComparing);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Objects.equals(expected, actual)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(111);
        }
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class<?> aClass) throws IllegalAccessException {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(112);
        }
        if (aClass == null) {
            UsefulTestCase.$$$reportNull$$$0(113);
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(114);
        }
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(115);
        }
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement((Element)newS);
            String oldString = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsNotOverwritten(@NotNull CodeInsightSettings settings) {
        if (settings == null) {
            UsefulTestCase.$$$reportNull$$$0(116);
        }
        if (!settings.equals((Object)defaultSettings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            String DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
        }
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        return TestFrameworkUtil.isPerformanceTest(testName, className);
    }

    public boolean isStressTest() {
        return UsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return TestFrameworkUtil.isPerformanceTest(testName, className) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project2) {
        if (project2 == null) {
            UsefulTestCase.$$$reportNull$$$0(117);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    protected void assertException(@NotNull AbstractExceptionCase<?> exceptionCase) {
        if (exceptionCase == null) {
            UsefulTestCase.$$$reportNull$$$0(118);
        }
        UsefulTestCase.assertThrows(exceptionCase.getExpectedExceptionClass(), null, () -> exceptionCase.tryClosure());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    protected void assertException(@NotNull AbstractExceptionCase<?> exceptionCase, @Nullable String expectedErrorMsg) {
        if (exceptionCase == null) {
            UsefulTestCase.$$$reportNull$$$0(119);
        }
        UsefulTestCase.assertThrows(exceptionCase.getExpectedExceptionClass(), expectedErrorMsg, () -> exceptionCase.tryClosure());
    }

    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<?> runnable) {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(120);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(121);
        }
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsgPart, @NotNull ThrowableRunnable<?> runnable) {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(122);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(123);
        }
        boolean wasThrown = false;
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLogger.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            wasThrown = true;
            if (!exceptionClass.isInstance(cause)) {
                throw new AssertionError("Expected instance of: " + exceptionClass + " actual: " + cause.getClass(), cause);
            }
            if (expectedErrorMsgPart != null) {
                UsefulTestCase.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains(expectedErrorMsgPart));
            }
        }
        finally {
            if (!wasThrown) {
                UsefulTestCase.fail((String)(exceptionClass + " must be thrown."));
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    protected <T extends Throwable> void assertNoException(@NotNull AbstractExceptionCase<T> exceptionCase) throws T {
        if (exceptionCase == null) {
            UsefulTestCase.$$$reportNull$$$0(124);
        }
        try {
            UsefulTestCase.assertNoException(exceptionCase.getExpectedExceptionClass(), () -> exceptionCase.tryClosure());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected static <T extends Throwable> void assertNoException(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(125);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(126);
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause instanceof TestLogger.TestLoggerAssertionError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (exceptionClass.equals(cause.getClass())) {
                System.out.println();
                e.printStackTrace(System.out);
                UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + cause.getMessage()));
            }
            throw e;
        }
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        if (closure == null) {
            UsefulTestCase.$$$reportNull$$$0(127);
        }
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            UsefulTestCase.$$$reportNull$$$0(128);
        }
        String methodName = (String)ObjectUtils.notNull((Object)this.getName(), (Object)"");
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        String string = PathManager.getHomePath().replace(File.separatorChar, '/');
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(129);
        }
        return string;
    }

    public static void refreshRecursively(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(130);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                file2.getChildren();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$2", "visitFile"));
            }
        });
        file2.refresh(false, true);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file2) {
        if (file2 == null) {
            UsefulTestCase.$$$reportNull$$$0(131);
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    /*
     * WARNING - void declaration
     */
    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void timeUnit2;
        if (timeUnit == null) {
            UsefulTestCase.$$$reportNull$$$0(132);
        }
        EdtTestUtil.runInEdtAndWait(() -> UsefulTestCase.lambda$waitForAppLeakingThreads$19(timeout, (TimeUnit)timeUnit2));
    }

    protected void setRegistryPropertyForTest(@NotNull String property, @NotNull String value) {
        if (property == null) {
            UsefulTestCase.$$$reportNull$$$0(133);
        }
        if (value == null) {
            UsefulTestCase.$$$reportNull$$$0(134);
        }
        Registry.get((String)property).setValue(value);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> Registry.get((String)property).resetToDefault());
    }

    protected void allowAccessToDirsIfExists(String ... dirNames) {
        if (dirNames == null) {
            UsefulTestCase.$$$reportNull$$$0(135);
        }
        for (String dirName : dirNames) {
            Path usrShareDir = Paths.get(dirName, new String[0]);
            if (Files.exists(usrShareDir, new LinkOption[0])) {
                String absolutePath = usrShareDir.toAbsolutePath().toString();
                LOG.debug(usrShareDir.toString(), new Object[]{" exists, adding to the list of allowed root: ", absolutePath});
                VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{absolutePath});
                continue;
            }
            LOG.debug(usrShareDir.toString(), new Object[]{" does not exists"});
        }
    }

    private static /* synthetic */ void lambda$waitForAppLeakingThreads$19(long timeout, TimeUnit timeUnit) throws Exception {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            DocumentCommitThread commitThread;
            FileBasedIndex index = (FileBasedIndex)app.getServiceIfCreated(FileBasedIndex.class);
            if (index instanceof FileBasedIndexImpl) {
                ((FileBasedIndexImpl)index).getChangedFilesCollector().waitForVfsEventsExecuted(timeout, timeUnit);
            }
            if ((commitThread = (DocumentCommitThread)app.getServiceIfCreated(DocumentCommitProcessor.class)) != null) {
                commitThread.waitForAllCommits(timeout, timeUnit);
            }
        }
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        IS_UNDER_SAFE_PUSH = IS_UNDER_TEAMCITY && "true".equals(System.getenv("SAFE_PUSH"));
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtilRt.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new ObjectIntHashMap();
        TOTAL_SETUP_COUNT = new ObjectIntHashMap();
        TOTAL_TEARDOWN_COST_MILLIS = new ObjectIntHashMap();
        TOTAL_TEARDOWN_COUNT = new ObjectIntHashMap();
        LOG = Logger.getInstance(UsefulTestCase.class);
        defaultSettings = new CodeInsightSettings();
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        Logger.setFactory(TestLoggerFactory.class);
        System.setProperty("apple.awt.UIElement", "true");
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 19: 
            case 22: 
            case 73: 
            case 82: 
            case 93: 
            case 100: 
            case 101: 
            case 129: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 19: 
            case 22: 
            case 73: 
            case 82: 
            case 93: 
            case 100: 
            case 101: 
            case 129: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 19: 
            case 22: 
            case 73: 
            case 82: 
            case 93: 
            case 100: 
            case 101: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: 
            case 8: 
            case 98: 
            case 99: 
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCodeStyleSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCodeStyleSettings";
                break;
            }
            case 11: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "costMap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countMap";
                break;
            }
            case 20: 
            case 121: 
            case 123: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 21: 
            case 46: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 83: 
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 94: 
            case 96: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 31: 
            case 36: 
            case 39: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMsg";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 47: 
            case 75: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notExpected";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 81: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 102: 
            case 104: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 103: 
            case 105: 
            case 108: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProducer";
                break;
            }
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 118: 
            case 119: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionCase";
                break;
            }
            case 120: 
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asOuterRule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalTempDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapTestRunnable";
                break;
            }
            case 22: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "assertInstanceOf";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDirectoryName";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asOuterRule";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 19: 
            case 22: 
            case 73: 
            case 82: 
            case 93: 
            case 100: 
            case 101: 
            case 129: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressedException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkShouldRunTest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeGlobalTempDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTmpFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForSettingsDamage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreCodeInsightSettingsToAvoidInducedErrors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "defaultRunBare";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logPerClassCost";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runBare";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapTestRunnable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "edt";
                break;
            }
            case 21: 
            case 65: 
            case 66: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedEquals";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 46: 
            case 47: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedCollection";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "assertSameElements";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsOrdered";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsElements";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntContain";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "assertUnorderedCollection";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "assertInstanceOf";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "assertOneElement";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "assertOneOf";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "assertEmpty";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "assertSize";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLines";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntExist";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLinesWithFile";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "clearFields";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "clearDeclaredFields";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeStyleSettingsEqual";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeInsightSettingsNotOverwritten";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormatting";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "assertException";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "assertNoException";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "assertNoThrowable";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "annotatedWith";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "refreshRecursively";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFile";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "waitForAppLeakingThreads";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "setRegistryPropertyForTest";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "allowAccessToDirsIfExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 19: 
            case 22: 
            case 73: 
            case 82: 
            case 93: 
            case 100: 
            case 101: 
            case 129: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (String)(StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

