/*
 * Decompiled with CFR 0.152.
 */
package circlet.app;

import circlet.app.StatusTillOption;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.stringUtils.StringUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a \u0010\u0007\u001a\u00020\u00032\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\nH\u0002\u001a\u001a\u0010\f\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\u0006\u0010\r\u001a\u00020\u0004\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\r\u001a\u00020\u0004\u001a\u0014\u0010\u000f\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\u0004*\u00060\tj\u0002`\n2\n\u0010\u0012\u001a\u00060\tj\u0002`\nH\u0002\u001a\u0014\u0010\u0013\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\nH\u0002\u001a\u001c\u0010\u0014\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"minuteIntervals", "", "Lkotlin/Pair;", "", "", "defaultStatusTillOption", "Lcirclet/app/StatusTillOption;", "tillText", "now", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "clearAt", "userStatusTillOption", "firstDayOfWeek", "userStatusTillOptions", "durationText", "unit", "minutesDifferenceRoundUp", "other", "nextMidnight", "nextWeek", "app-state"})
public final class UserStatusTillOptionsKt {
    @NotNull
    private static final List<Pair<String, Integer>> minuteIntervals;

    @NotNull
    public static final StatusTillOption userStatusTillOption(@NotNull KotlinXDateTime clearAt, int firstDayOfWeek) {
        StatusTillOption statusTillOption;
        Intrinsics.checkNotNullParameter((Object)clearAt, (String)"clearAt");
        KotlinXDateTime now = ADateJvmKt.getANow();
        KotlinXDateTime kotlinXDateTime = clearAt;
        if (Intrinsics.areEqual((Object)kotlinXDateTime, (Object)UserStatusTillOptionsKt.nextMidnight(now))) {
            statusTillOption = new StatusTillOption.TillMidnight();
        } else if (Intrinsics.areEqual((Object)kotlinXDateTime, (Object)UserStatusTillOptionsKt.nextWeek(now, firstDayOfWeek))) {
            statusTillOption = new StatusTillOption.TillNextWeek(firstDayOfWeek);
        } else {
            String text2 = UserStatusTillOptionsKt.tillText(now, clearAt);
            int n = UserStatusTillOptionsKt.minutesDifferenceRoundUp(now, clearAt);
            int n2 = 0;
            boolean bl = false;
            int intervalMinutes = Math.max(n, n2);
            statusTillOption = new StatusTillOption.TillMinutesPass(now, intervalMinutes, text2);
        }
        return statusTillOption;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StatusTillOption> userStatusTillOptions(int firstDayOfWeek) {
        void $this$mapTo$iv$iv;
        KotlinXDateTime midnight;
        KotlinXDateTime now = ADateJvmKt.getANow();
        KotlinXDateTime maxClearTime = ADateJvmKt.plusMinutes(now, ((Number)((Pair)CollectionsKt.last(minuteIntervals)).getSecond()).intValue());
        StatusTillOption.TillMidnight atMidnightOption = maxClearTime.compareTo(midnight = UserStatusTillOptionsKt.nextMidnight(now)) >= 0 ? null : new StatusTillOption.TillMidnight();
        KotlinXDateTime nextWeek = UserStatusTillOptionsKt.nextWeek(now, firstDayOfWeek);
        StatusTillOption.TillNextWeek tillNextWeekOption = maxClearTime.compareTo(nextWeek) >= 0 ? null : new StatusTillOption.TillNextWeek(firstDayOfWeek);
        Iterable $this$map$iv = minuteIntervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$label$minutes;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String label = (String)$dstr$label$minutes.component1();
            int minutes = ((Number)$dstr$label$minutes.component2()).intValue();
            StatusTillOption.TillMinutesPass tillMinutesPass = new StatusTillOption.TillMinutesPass(now, minutes, label);
            collection.add(tillMinutesPass);
        }
        Object[] objectArray = new StatusTillOption[]{atMidnightOption, tillNextWeekOption};
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @NotNull
    public static final StatusTillOption defaultStatusTillOption() {
        return new StatusTillOption.TillMinutesPass(ADateJvmKt.getANow(), 60, "1 hour");
    }

    private static final String tillText(KotlinXDateTime now, KotlinXDateTime clearAt) {
        int n = UserStatusTillOptionsKt.minutesDifferenceRoundUp(now, clearAt);
        int n2 = 0;
        boolean bl = false;
        int minutesBetween = Math.max(n, n2);
        int hoursBetween = minutesBetween / 60;
        int minutesRem = minutesBetween % 60;
        return hoursBetween > 0 && minutesRem > 0 ? UserStatusTillOptionsKt.durationText(hoursBetween, "hour") + ' ' + UserStatusTillOptionsKt.durationText(minutesRem, "minute") : (hoursBetween > 0 ? UserStatusTillOptionsKt.durationText(hoursBetween, "hour") : (minutesRem > 0 ? UserStatusTillOptionsKt.durationText(minutesRem, "minute") : ""));
    }

    private static final String durationText(int $this$durationText, String unit) {
        return "" + $this$durationText + ' ' + StringUtilsKt.pluralize(unit, $this$durationText);
    }

    private static final KotlinXDateTime nextMidnight(KotlinXDateTime $this$nextMidnight) {
        return ADateJvmKt.plusDays(ADateJvmKt.withTime($this$nextMidnight, 0, 0, 0, 0), 1);
    }

    private static final KotlinXDateTime nextWeek(KotlinXDateTime $this$nextWeek, int firstDayOfWeek) {
        KotlinXDateTime nextMidnight = UserStatusTillOptionsKt.nextMidnight($this$nextWeek);
        int daysTillMonday = (7 - ADateJvmKt.getWeekday(nextMidnight).getOrderNumber() + firstDayOfWeek) % 7;
        return ADateJvmKt.plusDays(nextMidnight, daysTillMonday);
    }

    private static final int minutesDifferenceRoundUp(KotlinXDateTime $this$minutesDifferenceRoundUp, KotlinXDateTime other) {
        long diffMillis = ADateJvmKt.getMillis(other) - ADateJvmKt.getMillis($this$minutesDifferenceRoundUp);
        long diffSecondsFloor = diffMillis / (long)60000;
        long diffMinutes = diffMillis % (long)60000 == 0L ? diffSecondsFloor : diffSecondsFloor + 1L;
        return (int)diffMinutes;
    }

    public static final /* synthetic */ KotlinXDateTime access$nextMidnight(KotlinXDateTime $receiver) {
        return UserStatusTillOptionsKt.nextMidnight($receiver);
    }

    public static final /* synthetic */ KotlinXDateTime access$nextWeek(KotlinXDateTime $receiver, int firstDayOfWeek) {
        return UserStatusTillOptionsKt.nextWeek($receiver, firstDayOfWeek);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"15 minutes", (Object)15), TuplesKt.to((Object)"30 minutes", (Object)30), TuplesKt.to((Object)"1 hour", (Object)60), TuplesKt.to((Object)"2 hours", (Object)120), TuplesKt.to((Object)"4 hours", (Object)240)};
        minuteIntervals = CollectionsKt.listOf((Object[])objectArray);
    }
}

