/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.RecurrenceRuleEnds;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RuleParserKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u00060\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0004*\u00020\t\u00a8\u0006\u0014"}, d2={"parseByDay", "", "Lcirclet/platform/api/Weekday;", "text", "", "parseByDay2", "Lkotlin/Pair;", "", "parseRecurrenceRule", "Lcirclet/common/calendar/RecurrenceRule;", "value", "startTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "timezone", "Lcirclet/platform/api/ATimeZone;", "parseUntil", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "print", "common"})
public final class RuleParserKt {
    @NotNull
    public static final String print(@NotNull RecurrenceRule $this$print) {
        Intrinsics.checkNotNullParameter((Object)$this$print, (String)"<this>");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$print_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$print_u24lambda_u2d0.append("RRULE:");
        Object object = $this$print.getFreq();
        if (object instanceof RecurrenceRuleFreq.Daily) {
            $this$print_u24lambda_u2d0.append("FREQ=DAILY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.Daily)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.Weekly) {
            $this$print_u24lambda_u2d0.append("FREQ=WEEKLY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";BYDAY=", (Object)CollectionsKt.joinToString$default((Iterable)((RecurrenceRuleFreq.Weekly)$this$print.getFreq()).getWeekdays(), (CharSequence)",", null, null, (int)0, null, (Function1)print.1.1.INSTANCE, (int)30, null)));
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.Weekly)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            $this$print_u24lambda_u2d0.append("FREQ=MONTHLY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";BYMONTHDAY=", (Object)((RecurrenceRuleFreq.MonthlyOnDate)$this$print.getFreq()).getDay()));
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.MonthlyOnDate)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            $this$print_u24lambda_u2d0.append("FREQ=MONTHLY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.MonthlyOnStartDate)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            $this$print_u24lambda_u2d0.append("FREQ=MONTHLY");
            $this$print_u24lambda_u2d0.append(";BYDAY=" + (((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$print.getFreq()).getShift() + 1) + WorkingDaysKt.weekdayToICal(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$print.getFreq()).getWeekday()));
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.MonthlyOnFirstWeekday)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            $this$print_u24lambda_u2d0.append("FREQ=MONTHLY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";BYDAY=-1", (Object)WorkingDaysKt.weekdayToICal(((RecurrenceRuleFreq.MonthlyOnLastWeekday)$this$print.getFreq()).getWeekday())));
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.MonthlyOnLastWeekday)$this$print.getFreq()).getInterval()));
        } else if (object instanceof RecurrenceRuleFreq.Yearly) {
            $this$print_u24lambda_u2d0.append("FREQ=YEARLY");
            $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";INTERVAL=", (Object)((RecurrenceRuleFreq.Yearly)$this$print.getFreq()).getInterval()));
        }
        object = $this$print.getEnds();
        if (!(object instanceof RecurrenceRuleEnds.Never)) {
            if (object instanceof RecurrenceRuleEnds.TotalCount) {
                $this$print_u24lambda_u2d0.append(Intrinsics.stringPlus((String)";COUNT=", (Object)((RecurrenceRuleEnds.TotalCount)$this$print.getEnds()).getCount()));
            } else if (object instanceof RecurrenceRuleEnds.OnDate) {
                $this$print_u24lambda_u2d0.append(";UNTIL=" + StringsKt.replace$default((String)ADateJvmKt.getInternal(((RecurrenceRuleEnds.OnDate)$this$print.getEnds()).getDate()), (String)"-", (String)"", (boolean)false, (int)4, null) + "T235959Z");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RecurrenceRule parseRecurrenceRule(@Nullable String value2, @NotNull KotlinXDateTime startTime, @NotNull ATimeZone timezone) {
        KotlinXDate kotlinXDate;
        String byday;
        boolean bl;
        boolean bl22;
        List<Pair<Weekday, Integer>> list;
        Object item$iv$iv;
        String $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        if (value2 == null) {
            return null;
        }
        if (!StringsKt.startsWith$default((String)value2, (String)"RRULE:", (boolean)false, (int)2, null)) {
            return null;
        }
        char[] cArray = new char[]{';'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)value2, (CharSequence)"RRULE:"), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            item$iv$iv = iterator2.next();
            list = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl22 = false;
            Object object = new char[]{'='};
            object = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])object, (boolean)false, (int)0, (int)6, null);
            bl = false;
            boolean bl3 = false;
            char[] it2 = object;
            boolean bl4 = false;
            Pair pair = TuplesKt.to(it2.get(0), it2.get(1));
            collection.add(pair);
        }
        Map statements = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String $i$f$map22 = (String)statements.get("FREQ");
        String freqText = $i$f$map22 == null ? "DAILY" : $i$f$map22;
        $this$mapTo$iv$iv = (String)statements.get("INTERVAL");
        int interval2 = $this$mapTo$iv$iv == null ? 1 : ((destination$iv$iv = StringsKt.toIntOrNull((String)$this$mapTo$iv$iv)) == null ? 1 : (Integer)destination$iv$iv);
        switch (freqText) {
            case "DAILY": {
                Object object2 = new RecurrenceRuleFreq.Daily(interval2);
                break;
            }
            case "WEEKLY": {
                Object startDate;
                RecurrenceRuleFreq.Weekly weekly;
                Object object;
                item$iv$iv = (String)statements.get("BYDAY");
                if (item$iv$iv == null) {
                    object = null;
                } else {
                    list = item$iv$iv;
                    bl22 = false;
                    boolean bl5 = false;
                    String it = list;
                    boolean bl6 = false;
                    object = RuleParserKt.parseByDay(it);
                }
                byday = object;
                item$iv$iv = (Collection)((Object)byday);
                boolean bl7 = false;
                bl22 = false;
                if (!(item$iv$iv == null || item$iv$iv.isEmpty())) {
                    weekly = new RecurrenceRuleFreq.Weekly((List<? extends Weekday>)((Object)byday), interval2);
                } else {
                    startDate = ADateJvmKt.toDate(ADateJvmKt.withZone(startTime, timezone));
                    weekly = new RecurrenceRuleFreq.Weekly(CollectionsKt.listOf((Object)ADateJvmKt.getWeekday((KotlinXDate)startDate)), interval2);
                }
                Object object2 = weekly;
                break;
            }
            case "MONTHLY": {
                Integer mymonthday;
                Integer n;
                String string2;
                Object object2;
                Object startDate = (String)statements.get("BYDAY");
                if (startDate == null) {
                    string2 = null;
                } else {
                    String bl22 = startDate;
                    boolean bl8 = false;
                    bl = false;
                    String it = bl22;
                    boolean bl9 = false;
                    list = RuleParserKt.parseByDay2(it);
                    string2 = list == null ? null : (Pair)CollectionsKt.singleOrNull((List)list);
                }
                byday = string2;
                list = (String)statements.get("BYMONTHDAY");
                if (list == null) {
                    n = null;
                } else {
                    String bl22 = list;
                    boolean bl10 = false;
                    n = mymonthday = Integer.valueOf(Integer.parseInt(bl22));
                }
                if (byday != null) {
                    if (((Number)byday.getSecond()).intValue() == -1) {
                        object2 = new RecurrenceRuleFreq.MonthlyOnLastWeekday((Weekday)byday.getFirst(), interval2);
                        break;
                    }
                    object2 = new RecurrenceRuleFreq.MonthlyOnFirstWeekday((Weekday)byday.getFirst(), ((Number)byday.getSecond()).intValue() - 1, interval2);
                    break;
                }
                if (mymonthday != null) {
                    object2 = new RecurrenceRuleFreq.MonthlyOnDate(mymonthday, interval2);
                    break;
                }
                object2 = new RecurrenceRuleFreq.MonthlyOnStartDate(interval2);
                break;
            }
            case "YEARLY": {
                Object object2 = new RecurrenceRuleFreq.Yearly(interval2);
                break;
            }
            default: {
                Object object2 = destination$iv$iv = (RecurrenceRuleFreq)null;
            }
        }
        if (destination$iv$iv == null) {
            return null;
        }
        Object freq = destination$iv$iv;
        String $i$f$mapTo22 = (String)statements.get("UNTIL");
        if ($i$f$mapTo22 == null) {
            kotlinXDate = null;
        } else {
            byday = $i$f$mapTo22;
            boolean bl11 = false;
            boolean bl12 = false;
            String it = byday;
            boolean bl13 = false;
            kotlinXDate = RuleParserKt.parseUntil(it);
        }
        KotlinXDate until = kotlinXDate;
        byday = (String)statements.get("COUNT");
        Integer count2 = byday == null ? null : StringsKt.toIntOrNull((String)byday);
        RecurrenceRuleEnds ends = count2 != null ? (RecurrenceRuleEnds)new RecurrenceRuleEnds.TotalCount(count2) : (until != null ? (RecurrenceRuleEnds)new RecurrenceRuleEnds.OnDate(until) : (RecurrenceRuleEnds)new RecurrenceRuleEnds.Never());
        return new RecurrenceRule((RecurrenceRuleFreq)freq, ends);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Weekday, Integer>> parseByDay2(@NotNull String text2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{','};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Weekday weekday;
            int n;
            int n2;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (it.length() == 4) {
                string2 = it;
                n2 = 2;
                n = 0;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                weekday = WorkingDaysKt.iCalToWeekday(string4);
                object = weekday != null ? TuplesKt.to((Object)weekday, (Object)-1) : null;
            } else if (it.length() == 3) {
                string2 = it;
                n2 = 1;
                n = 0;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                weekday = WorkingDaysKt.iCalToWeekday(string6);
                String string7 = it;
                n = 0;
                int n3 = 1;
                boolean bl3 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer cnt = StringsKt.toIntOrNull((String)string9);
                object = weekday != null && cnt != null ? TuplesKt.to((Object)weekday, (Object)cnt) : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Pair pair = object;
            boolean bl4 = false;
            boolean bl5 = false;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Weekday> parseByDay(@NotNull String text2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{','};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Weekday weekday;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (WorkingDaysKt.iCalToWeekday(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Weekday it$iv$iv = weekday;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final KotlinXDate parseUntil(String value2) {
        String year = RuleParserKt.parseUntil$validateNumber(StringsKt.substring((String)value2, (IntRange)new IntRange(0, 3)), 1970, null);
        String month = RuleParserKt.parseUntil$validateNumber(StringsKt.substring((String)value2, (IntRange)new IntRange(4, 5)), 1, 12);
        String day = RuleParserKt.parseUntil$validateNumber(StringsKt.substring((String)value2, (IntRange)new IntRange(6, 7)), 1, 31);
        if (year != null && month != null && day != null) {
            return ADateJvmKt.aDate(year + '-' + month + '-' + day);
        }
        return null;
    }

    private static final String parseUntil$validateNumber(String value2, Integer min, Integer max) {
        Integer n = StringsKt.toIntOrNull((String)value2);
        if (n == null) {
            return null;
        }
        int intValue = n;
        if (min != null && intValue < min) {
            return null;
        }
        if (max != null && intValue > max) {
            return null;
        }
        return value2;
    }
}

