/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ADateKt;
import circlet.platform.api.ADateObsolete;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.ATimeZoneWithOffset;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateCompat;
import circlet.platform.api.JodaDateImpl;
import circlet.platform.api.JodaDateTime;
import circlet.platform.api.JodaDateTimeImpl;
import circlet.platform.api.KDateTime;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateCompat;
import circlet.platform.api.KotlinXDateImpl;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.KotlinXDateTimeImpl;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ClockKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import runtime.date.DateTimeMode;
import runtime.date.DatesKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00bc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\"\u0010\u0012\u001a\u00060\nj\u0002`\u000b2\u0006\u0010k\u001a\u00020-2\u0006\u0010b\u001a\u00020-2\u0006\u0010m\u001a\u00020-\u001a\u0012\u0010\u0012\u001a\u00060\nj\u0002`\u000b2\u0006\u00103\u001a\u00020)\u001a\u0012\u0010n\u001a\u00060;j\u0002`<2\u0006\u00103\u001a\u00020)\u001a:\u0010\u0018\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010k\u001a\u00020-2\u0006\u0010b\u001a\u00020-2\u0006\u0010m\u001a\u00020-2\u0006\u0010o\u001a\u00020-2\u0006\u0010p\u001a\u00020-2\u0006\u0010q\u001a\u00020\u0006\u001a\u0012\u0010\u0018\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010W\u001a\u00020X\u001a\u0012\u0010\u0018\u001a\u00060\u0001j\u0002`\u00022\u0006\u00103\u001a\u00020)\u001a\u0014\u0010r\u001a\u00060Rj\u0002`S2\u0006\u0010W\u001a\u00020XH\u0007\u001a\u0012\u0010r\u001a\u00060Rj\u0002`S2\u0006\u00103\u001a\u00020)\u001a\u001e\u0010s\u001a\u00020-2\n\u0010t\u001a\u00060\nj\u0002`\u000b2\n\u0010u\u001a\u00060\nj\u0002`\u000b\u001a\u001e\u0010s\u001a\u00020-2\n\u0010t\u001a\u00060\u0001j\u0002`\u00022\n\u0010u\u001a\u00060\u0001j\u0002`\u0002\u001a\u001e\u0010v\u001a\u00020-2\n\u0010t\u001a\u00060\nj\u0002`\u000b2\n\u0010u\u001a\u00060\nj\u0002`\u000b\u001a\u001e\u0010v\u001a\u00020-2\n\u0010t\u001a\u00060\u0001j\u0002`\u00022\n\u0010u\u001a\u00060\u0001j\u0002`\u0002\u001a\u001e\u0010w\u001a\u00020-2\n\u0010t\u001a\u00060\u0001j\u0002`\u00022\n\u0010u\u001a\u00060\u0001j\u0002`\u0002\u001a\u001e\u0010x\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b2\n\u0010y\u001a\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010z\u001a\u0004\u0018\u00010$*\u00020)H\u0002\u001a\u001c\u0010{\u001a\u00020)*\u00060\nj\u0002`\u000b2\f\b\u0002\u0010|\u001a\u00060\nj\u0002`\u000b\u001a&\u0010}\u001a\u00020)*\u00060\u0001j\u0002`\u00022\b\b\u0002\u0010~\u001a\u00020\u007f2\f\b\u0002\u0010|\u001a\u00060\u0001j\u0002`\u0002\u001a\u000f\u0010\u0080\u0001\u001a\u00020)*\u00060\u0001j\u0002`\u0002\u001a\u000f\u0010\u0081\u0001\u001a\u00020-*\u00060\nj\u0002`\u000b\u001a\u001c\u0010\u0082\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0007\u0010\u0083\u0001\u001a\u00020-\u001a\u001c\u0010\u0084\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0007\u0010\u0085\u0001\u001a\u00020-\u001a \u0010\u0086\u0001\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u00062\u000b\u0010\u0087\u0001\u001a\u00060\u0001j\u0002`\u0002\u001a\u0017\u0010\u0088\u0001\u001a\u00020-*\u00020\u00062\n\u0010y\u001a\u00060\u0001j\u0002`\u0002\u001a\u001c\u0010\u0089\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0007\u0010\u0083\u0001\u001a\u00020-\u001a\u001c\u0010\u0089\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0007\u0010\u0083\u0001\u001a\u00020-\u001a\u001b\u0010\u008a\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010o\u001a\u00020-\u001a\u001b\u0010\u008b\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010W\u001a\u00020-\u001a\u001b\u0010\u008c\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010p\u001a\u00020-\u001a\u001c\u0010\u008d\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0007\u0010\u0085\u0001\u001a\u00020-\u001a\u001c\u0010\u008d\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0007\u0010\u0085\u0001\u001a\u00020-\u001a\u001c\u0010\u008e\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0007\u0010\u008f\u0001\u001a\u00020-\u001a\u001c\u0010\u0090\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0007\u0010\u0091\u0001\u001a\u00020-\u001a\u001c\u0010\u0090\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0007\u0010\u0091\u0001\u001a\u00020-\u001a\u0013\u0010\u0092\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u0002\u001a\u0018\u0010\u0093\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00020@2\u0007\u0010\u0094\u0001\u001a\u00020\u0006\u001a\u0018\u0010\u0093\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00020\u001c2\u0007\u0010\u0094\u0001\u001a\u00020\u0006\u001a\u0019\u0010\u0093\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00030\u0095\u00012\u0007\u0010\u0094\u0001\u001a\u00020\u0006\u001a\u0013\u0010\u0096\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\u0001j\u0002`\u0002\u001a\u0013\u0010\u0097\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b\u001a\u001c\u0010\u0097\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b2\u0007\u0010\u0094\u0001\u001a\u00020\u0006\u001a\u0013\u0010\u0098\u0001\u001a\u00060;j\u0002`<*\u00060\u0001j\u0002`\u0002\u001a\u001b\u0010\u0099\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010m\u001a\u00020-\u001a\u001b\u0010\u009a\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010m\u001a\u00020-\u001a\u001e\u0010\u009b\u0001\u001a\u00020(*\u00020\u00062\u0011\b\u0002\u0010\u009c\u0001\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u001a5\u0010\u009d\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010o\u001a\u00020-2\u0006\u0010p\u001a\u00020-2\u0007\u0010\u008f\u0001\u001a\u00020-2\u0007\u0010\u009e\u0001\u001a\u00020-\u001a\u001c\u0010\u009f\u0001\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0007\u0010\u0094\u0001\u001a\u00020\u0006\u001a\u001d\u0010\u00a0\u0001\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001\u001a\u001d\u0010\u00a0\u0001\u001a\u00060;j\u0002`<*\u00060;j\u0002`<2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001\"\u0015\u0010\u0000\u001a\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0010\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0019\u0010\u0012\u001a\u00060\nj\u0002`\u000b*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0019\u0010\u0012\u001a\u00060\nj\u0002`\u000b*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\"\u0019\u0010\u0018\u001a\u00060\u0001j\u0002`\u0002*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0019\u0010\u0018\u001a\u00060\u0001j\u0002`\u0002*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001d\"\u0019\u0010\u0018\u001a\u00060\u0001j\u0002`\u0002*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001f\"\u001d\u0010 \u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0015\u0010#\u001a\u00020\u0006*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0015\u0010'\u001a\u00020(*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u0019\u0010,\u001a\u00020-*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0019\u0010,\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b.\u00100\"\u0019\u00101\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b2\u00100\"\u0019\u00103\u001a\u00020)*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0019\u00106\u001a\u000207*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\"\u0019\u0010:\u001a\u000207*\u00060;j\u0002`<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0019\u0010?\u001a\u00020@*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\"\"\u0010C\u001a\u00020\u0016*\u00060\nj\u0002`\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\"\u0010C\u001a\u00020\u001e*\u00060\u0001j\u0002`\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010H\u001a\u0004\bF\u0010I\" \u0010C\u001a\u0004\u0018\u00010$*\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010J\u001a\u0004\bF\u0010K\" \u0010C\u001a\u0004\u0018\u00010$*\u00020(8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010L\u001a\u0004\bF\u0010M\"\u0019\u0010N\u001a\u00020\u0019*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\"&\u0010Q\u001a\u00060Rj\u0002`S*\u00060\u0001j\u0002`\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bT\u0010H\u001a\u0004\bU\u0010V\"\u0019\u0010W\u001a\u00020X*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bY\u0010Z\"\u0019\u0010W\u001a\u00020X*\u00060Rj\u0002`S8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010[\"\u0019\u0010\\\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b]\u00100\"\u0019\u0010^\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b_\u00100\"\u0019\u0010`\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\ba\u00100\"\u0019\u0010b\u001a\u00020-*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010/\"\u0019\u0010b\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bc\u00100\"\u0019\u0010d\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\be\u00100\"\u0019\u0010f\u001a\u00020g*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bh\u0010i\"\u0019\u0010f\u001a\u00020g*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bh\u0010j\"\u0019\u0010k\u001a\u00020-*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010/\"\u0019\u0010k\u001a\u00020-*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bl\u00100*\u000b\u0010\u00a3\u0001\"\u00020\n2\u00020\n*\u000b\u0010\u00a4\u0001\"\u00020;2\u00020;*\u000b\u0010\u00a5\u0001\"\u00020\u00012\u00020\u0001*\u000b\u0010\u00a6\u0001\"\u00020R2\u00020R\u00a8\u0006\u00a7\u0001"}, d2={"aNow", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "getANow", "()Lcirclet/platform/api/KotlinXDateTime;", "clientTimeZone", "Lcirclet/platform/api/ATimeZone;", "getClientTimeZone", "()Lcirclet/platform/api/ATimeZone;", "epochStart", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "getEpochStart", "()Lcirclet/platform/api/KotlinXDate;", "timeWithoutSecond", "Lkotlin/text/Regex;", "today", "getToday", "aDate", "Lkotlinx/datetime/LocalDate;", "getADate", "(Lkotlinx/datetime/LocalDate;)Lcirclet/platform/api/KotlinXDate;", "Lorg/joda/time/LocalDate;", "(Lorg/joda/time/LocalDate;)Lcirclet/platform/api/KotlinXDate;", "aDateTime", "Lcirclet/platform/api/KDateTime;", "getADateTime", "(Lcirclet/platform/api/KDateTime;)Lcirclet/platform/api/KotlinXDateTime;", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Lcirclet/platform/api/KotlinXDateTime;", "Lorg/joda/time/DateTime;", "(Lorg/joda/time/DateTime;)Lcirclet/platform/api/KotlinXDateTime;", "aDateTimeUnsafe", "getADateTimeUnsafe", "(Lcirclet/platform/api/KotlinXDate;)Lcirclet/platform/api/KotlinXDateTime;", "aTimeZone", "Lorg/joda/time/DateTimeZone;", "getATimeZone", "(Lorg/joda/time/DateTimeZone;)Lcirclet/platform/api/ATimeZone;", "aTimeZoneWithOffsetNow", "Lcirclet/platform/api/ATimeZoneWithOffset;", "", "getATimeZoneWithOffsetNow", "(Ljava/lang/String;)Lcirclet/platform/api/ATimeZoneWithOffset;", "dayOfMonth", "", "getDayOfMonth", "(Lcirclet/platform/api/KotlinXDate;)I", "(Lcirclet/platform/api/KotlinXDateTime;)I", "hour", "getHour", "internal", "getInternal", "(Lcirclet/platform/api/KotlinXDate;)Ljava/lang/String;", "internalCompat", "", "getInternalCompat", "(Lcirclet/platform/api/KotlinXDate;)Ljava/lang/Object;", "internalString", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADateLegacy;", "getInternalString", "(Lcirclet/platform/api/JodaDate;)Ljava/lang/Object;", "javaLocalDateTime", "Ljava/time/LocalDateTime;", "getJavaLocalDateTime", "(Lcirclet/platform/api/KotlinXDateTime;)Ljava/time/LocalDateTime;", "joda", "getJoda$annotations", "(Lcirclet/platform/api/KotlinXDate;)V", "getJoda", "(Lcirclet/platform/api/KotlinXDate;)Lorg/joda/time/LocalDate;", "(Lcirclet/platform/api/KotlinXDateTime;)V", "(Lcirclet/platform/api/KotlinXDateTime;)Lorg/joda/time/DateTime;", "(Lcirclet/platform/api/ATimeZone;)V", "(Lcirclet/platform/api/ATimeZone;)Lorg/joda/time/DateTimeZone;", "(Lcirclet/platform/api/ATimeZoneWithOffset;)V", "(Lcirclet/platform/api/ATimeZoneWithOffset;)Lorg/joda/time/DateTimeZone;", "kDateTime", "getKDateTime", "(Lcirclet/platform/api/KotlinXDateTime;)Lcirclet/platform/api/KDateTime;", "legacy", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTimeLegacy;", "getLegacy$annotations", "getLegacy", "(Lcirclet/platform/api/KotlinXDateTime;)Lcirclet/platform/api/JodaDateTime;", "millis", "", "getMillis", "(Lcirclet/platform/api/KotlinXDateTime;)J", "(Lcirclet/platform/api/JodaDateTime;)J", "millisOfSecond", "getMillisOfSecond", "minute", "getMinute", "minuteOfDay", "getMinuteOfDay", "month", "getMonth", "second", "getSecond", "weekday", "Lcirclet/platform/api/Weekday;", "getWeekday", "(Lcirclet/platform/api/KotlinXDate;)Lcirclet/platform/api/Weekday;", "(Lcirclet/platform/api/KotlinXDateTime;)Lcirclet/platform/api/Weekday;", "year", "getYear", "day", "aDateLegacy", "hours", "minutes", "timezone", "aDateTimeLegacy", "daysBetween", "a", "b", "monthsBetween", "yearsBetween", "atTime", "time", "dateTimeZoneSafe", "formatDate", "now", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "formatFullDateTime", "getLastMonthDay", "minusDays", "days", "minusMonths", "months", "nextTransition", "from", "offsetOnTime", "plusDays", "plusHours", "plusMillis", "plusMinutes", "plusMonths", "plusSeconds", "seconds", "plusYears", "years", "roundToMillis", "toADateTime", "zone", "Lkotlinx/datetime/LocalDateTime;", "toDate", "toDateTimeAtStartOfDay", "toLegacyDate", "withDay", "withDayOrLastMonthDay", "withOffsetOnDate", "date", "withTime", "mills", "withZone", "wrapCompat", "supportsADate", "", "ADate", "ADateLegacy", "ADateTime", "ADateTimeLegacy", "platform-api"})
public final class ADateJvmKt {
    @NotNull
    private static final Regex timeWithoutSecond;
    @NotNull
    private static final KotlinXDate epochStart;

    @NotNull
    public static final KotlinXDate getADate(@NotNull kotlinx.datetime.LocalDate $this$aDate) {
        Intrinsics.checkNotNullParameter((Object)$this$aDate, (String)"<this>");
        return new KotlinXDateImpl($this$aDate);
    }

    @NotNull
    public static final KotlinXDate getADate(@NotNull org.joda.time.LocalDate $this$aDate) {
        Intrinsics.checkNotNullParameter((Object)$this$aDate, (String)"<this>");
        return new KotlinXDateImpl(new kotlinx.datetime.LocalDate($this$aDate.getYear(), $this$aDate.getMonthOfYear(), $this$aDate.getDayOfMonth()));
    }

    @NotNull
    public static final org.joda.time.LocalDate getJoda(@NotNull KotlinXDate $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return new org.joda.time.LocalDate(ADateJvmKt.getYear($this$joda), ADateJvmKt.getMonth($this$joda), ADateJvmKt.getDayOfMonth($this$joda));
    }

    @Deprecated(message="Use ADate itself")
    public static /* synthetic */ void getJoda$annotations(KotlinXDate $this$getJoda_u24annotations) {
    }

    @Nullable
    public static final DateTimeZone getJoda(@NotNull ATimeZoneWithOffset $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return ADateJvmKt.dateTimeZoneSafe($this$joda.getId());
    }

    @Deprecated(message="Use ATimeZoneWithOffset itself")
    public static /* synthetic */ void getJoda$annotations(ATimeZoneWithOffset $this$getJoda_u24annotations) {
    }

    @Nullable
    public static final DateTimeZone getJoda(@NotNull ATimeZone $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return ADateJvmKt.dateTimeZoneSafe($this$joda.getId());
    }

    @Deprecated(message="Use ATimeZone itself")
    public static /* synthetic */ void getJoda$annotations(ATimeZone $this$getJoda_u24annotations) {
    }

    @NotNull
    public static final ATimeZone getATimeZone(@NotNull DateTimeZone $this$aTimeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZone, (String)"<this>");
        String string2 = $this$aTimeZone.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.id");
        return new ATimeZone(string2);
    }

    @NotNull
    public static final KotlinXDateTime toADateTime(@NotNull kotlinx.datetime.LocalDateTime $this$toADateTime, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toADateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return new KotlinXDateTimeImpl($this$toADateTime, zone);
    }

    @NotNull
    public static final KotlinXDateTime getADateTime(@NotNull DateTime $this$aDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTime, (String)"<this>");
        kotlinx.datetime.LocalDateTime localDateTime = new kotlinx.datetime.LocalDateTime($this$aDateTime.getYear(), $this$aDateTime.getMonthOfYear(), $this$aDateTime.getDayOfMonth(), $this$aDateTime.getHourOfDay(), $this$aDateTime.getMinuteOfHour(), $this$aDateTime.getSecondOfMinute(), $this$aDateTime.getMillisOfSecond() * 1000000);
        DateTimeZone dateTimeZone = $this$aDateTime.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeZone, (String)"zone");
        return ADateJvmKt.toADateTime(localDateTime, ADateJvmKt.getATimeZone(dateTimeZone));
    }

    @NotNull
    public static final KotlinXDateTime toADateTime(@NotNull Instant $this$toADateTime, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toADateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return ADateJvmKt.toADateTime(TimeZoneKt.toLocalDateTime((Instant)$this$toADateTime, (kotlinx.datetime.TimeZone)ADateKt.getKotlin(zone)), zone);
    }

    @NotNull
    public static final KotlinXDateTime getADateTime(@NotNull Instant $this$aDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTime, (String)"<this>");
        return ADateJvmKt.toADateTime($this$aDateTime, ADateJvmKt.getClientTimeZone());
    }

    @NotNull
    public static final LocalDateTime getJavaLocalDateTime(@NotNull KotlinXDateTime $this$javaLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$javaLocalDateTime, (String)"<this>");
        return ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)$this$javaLocalDateTime.getDateTime());
    }

    @NotNull
    public static final KotlinXDateTime toADateTime(@NotNull LocalDateTime $this$toADateTime, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toADateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return ADateJvmKt.toADateTime(ConvertersKt.toKotlinLocalDateTime((LocalDateTime)$this$toADateTime), zone);
    }

    @NotNull
    public static final JodaDateTime getLegacy(@NotNull KotlinXDateTime $this$legacy) {
        Intrinsics.checkNotNullParameter((Object)$this$legacy, (String)"<this>");
        return JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl(ADateJvmKt.getJoda($this$legacy)));
    }

    @Deprecated(message="Do not use ADateTimeLegacy")
    public static /* synthetic */ void getLegacy$annotations(KotlinXDateTime $this$getLegacy_u24annotations) {
    }

    @NotNull
    public static final DateTime getJoda(@NotNull KotlinXDateTime $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return new DateTime($this$joda.getDateTime().getYear(), $this$joda.getDateTime().getMonthNumber(), $this$joda.getDateTime().getDayOfMonth(), $this$joda.getDateTime().getHour(), $this$joda.getDateTime().getMinute(), $this$joda.getDateTime().getSecond(), $this$joda.getDateTime().getNanosecond() / 1000000, ADateJvmKt.getJoda($this$joda.getZone()));
    }

    @Deprecated(message="Use ADateTime itself")
    public static /* synthetic */ void getJoda$annotations(KotlinXDateTime $this$getJoda_u24annotations) {
    }

    public static final int daysBetween(@NotNull KotlinXDateTime a, @NotNull KotlinXDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return InstantKt.daysUntil((Instant)a.getInstant(), (Instant)b.getInstant(), (kotlinx.datetime.TimeZone)ADateKt.getKotlin(a.getZone()));
    }

    public static final int daysBetween(@NotNull KotlinXDate a, @NotNull KotlinXDate b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LocalDateJvmKt.daysUntil((kotlinx.datetime.LocalDate)a.getDate(), (kotlinx.datetime.LocalDate)b.getDate());
    }

    public static final int monthsBetween(@NotNull KotlinXDateTime a, @NotNull KotlinXDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return InstantKt.monthsUntil((Instant)a.getInstant(), (Instant)b.getInstant(), (kotlinx.datetime.TimeZone)ADateKt.getKotlin(a.getZone()));
    }

    public static final int monthsBetween(@NotNull KotlinXDate a, @NotNull KotlinXDate b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LocalDateJvmKt.monthsUntil((kotlinx.datetime.LocalDate)a.getDate(), (kotlinx.datetime.LocalDate)b.getDate());
    }

    @NotNull
    public static final KotlinXDateTime withZone(@NotNull KotlinXDateTime $this$withZone, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$withZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return Intrinsics.areEqual((Object)$this$withZone.getZone(), (Object)zone) ? $this$withZone : ADateJvmKt.toADateTime($this$withZone.getInstant(), zone);
    }

    public static final int yearsBetween(@NotNull KotlinXDateTime a, @NotNull KotlinXDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return InstantKt.yearsUntil((Instant)a.getInstant(), (Instant)b.getInstant(), (kotlinx.datetime.TimeZone)ADateKt.getKotlin(a.getZone()));
    }

    @NotNull
    public static final KotlinXDateTime plusDays(@NotNull KotlinXDateTime $this$plusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusDays).plusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusDays(days.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusDays.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusMonths(@NotNull KotlinXDateTime $this$plusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusMonths).plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusMonths(months.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusMonths.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusYears(@NotNull KotlinXDateTime $this$plusYears, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$plusYears, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusYears).plusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusYears(years.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusYears.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusHours(@NotNull KotlinXDateTime $this$plusHours, int hours) {
        Intrinsics.checkNotNullParameter((Object)$this$plusHours, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusHours).plusHours(hours);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusHours(hours.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusHours.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusMinutes(@NotNull KotlinXDateTime $this$plusMinutes, int minutes) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMinutes, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusMinutes).plusMinutes(minutes);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusMinutes(minutes.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusMinutes.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusSeconds(@NotNull KotlinXDateTime $this$plusSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$plusSeconds, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusSeconds).plusSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plusSeconds(seconds.toLong())");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusSeconds.getZone());
    }

    @NotNull
    public static final KotlinXDateTime plusMillis(@NotNull KotlinXDateTime $this$plusMillis, int millis) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMillis, (String)"<this>");
        LocalDateTime localDateTime = ADateJvmKt.getJavaLocalDateTime($this$plusMillis).plus(millis, ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"javaLocalDateTime.plus(m\u2026ong(), ChronoUnit.MILLIS)");
        return ADateJvmKt.toADateTime(localDateTime, $this$plusMillis.getZone());
    }

    @NotNull
    public static final KotlinXDateTime toDateTimeAtStartOfDay(@NotNull KotlinXDate $this$toDateTimeAtStartOfDay, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtStartOfDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return ADateJvmKt.withZone(ADateJvmKt.getADateTime(TimeZoneKt.atStartOfDayIn((kotlinx.datetime.LocalDate)$this$toDateTimeAtStartOfDay.getDate(), (kotlinx.datetime.TimeZone)ADateKt.getKotlin(zone))), zone);
    }

    @NotNull
    public static final KotlinXDateTime toDateTimeAtStartOfDay(@NotNull KotlinXDate $this$toDateTimeAtStartOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtStartOfDay, (String)"<this>");
        return ADateJvmKt.toDateTimeAtStartOfDay($this$toDateTimeAtStartOfDay, ADateJvmKt.getClientTimeZone());
    }

    @NotNull
    public static final KotlinXDateTime withTime(@NotNull KotlinXDateTime $this$withTime, int hours, int minutes, int seconds, int mills) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        kotlinx.datetime.LocalDateTime localDateTime = $this$withTime.getDateTime();
        boolean bl = false;
        boolean bl2 = false;
        kotlinx.datetime.LocalDateTime old = localDateTime;
        boolean bl3 = false;
        return ADateJvmKt.toADateTime(new kotlinx.datetime.LocalDateTime(old.getYear(), old.getMonth(), old.getDayOfMonth(), hours, minutes, seconds, mills * 1000000), $this$withTime.getZone());
    }

    @NotNull
    public static final KotlinXDate toDate(@NotNull KotlinXDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        return ADateJvmKt.getADate($this$toDate.getDateTime().getDate());
    }

    @NotNull
    public static final JodaDate toLegacyDate(@NotNull KotlinXDateTime $this$toLegacyDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toLegacyDate, (String)"<this>");
        org.joda.time.LocalDate localDate = ADateJvmKt.getJoda($this$toLegacyDate).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"joda.toLocalDate()");
        return JodaDateImpl.box-impl(JodaDateImpl.constructor-impl(localDate));
    }

    @NotNull
    public static final KotlinXDateTime getADateTimeUnsafe(@NotNull KotlinXDate $this$aDateTimeUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTimeUnsafe, (String)"<this>");
        kotlinx.datetime.LocalDateTime localDateTime = ADateJvmKt.getANow().getDateTime();
        boolean bl = false;
        boolean bl2 = false;
        kotlinx.datetime.LocalDateTime now = localDateTime;
        boolean bl3 = false;
        return ADateJvmKt.toADateTime(new kotlinx.datetime.LocalDateTime($this$aDateTimeUnsafe.getDate().getYear(), $this$aDateTimeUnsafe.getDate().getMonth(), $this$aDateTimeUnsafe.getDate().getDayOfMonth(), now.getHour(), now.getMinute(), now.getSecond(), now.getNanosecond()), ADateJvmKt.getClientTimeZone());
    }

    @NotNull
    public static final KotlinXDateTime getADateTime(@NotNull KDateTime $this$aDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTime, (String)"<this>");
        return ADateJvmKt.getADateTime(PrimitivesExKt.dateTime($this$aDateTime));
    }

    @NotNull
    public static final KDateTime getKDateTime(@NotNull KotlinXDateTime $this$kDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$kDateTime, (String)"<this>");
        CharSequence charSequence = $this$kDateTime.getDateTime().toString();
        Regex regex2 = timeWithoutSecond;
        String string2 = "T$1:00";
        boolean bl = false;
        return new KDateTime(Intrinsics.stringPlus((String)regex2.replace(charSequence, string2), (Object)ADateKt.offsetToString($this$kDateTime.getZone(), $this$kDateTime.getInstant())));
    }

    @NotNull
    public static final KotlinXDate wrapCompat(@NotNull KotlinXDate $this$wrapCompat, boolean supportsADate) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapCompat, (String)"<this>");
        return supportsADate ? $this$wrapCompat : (KotlinXDate)new KotlinXDateCompat($this$wrapCompat);
    }

    @NotNull
    public static final JodaDate wrapCompat(@NotNull JodaDate $this$wrapCompat, boolean supportsADate) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapCompat, (String)"<this>");
        return supportsADate ? $this$wrapCompat : (JodaDate)new JodaDateCompat($this$wrapCompat);
    }

    @NotNull
    public static final ATimeZoneWithOffset getATimeZoneWithOffsetNow(@NotNull String $this$aTimeZoneWithOffsetNow) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZoneWithOffsetNow, (String)"<this>");
        DateTimeZone zone = DateTimeZone.forID((String)$this$aTimeZoneWithOffsetNow);
        String string2 = zone.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zone.id");
        return new ATimeZoneWithOffset(string2, zone.getOffset(PrimitivesExKt.getNowMs()));
    }

    @NotNull
    public static final ATimeZoneWithOffset withOffsetOnDate(@NotNull ATimeZone $this$withOffsetOnDate, @Nullable KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)$this$withOffsetOnDate, (String)"<this>");
        KotlinXDate kotlinXDate = date2;
        int offset = TimeZoneKt.offsetIn((Instant)TimeZoneKt.atStartOfDayIn((kotlinx.datetime.LocalDate)(kotlinXDate == null ? ADateJvmKt.getToday() : kotlinXDate).getDate(), (kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.of($this$withOffsetOnDate.getId())), (kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.getUTC()).getTotalSeconds() / 60;
        return new ATimeZoneWithOffset($this$withOffsetOnDate.getId(), offset);
    }

    public static /* synthetic */ ATimeZoneWithOffset withOffsetOnDate$default(ATimeZone aTimeZone, KotlinXDate kotlinXDate, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate = null;
        }
        return ADateJvmKt.withOffsetOnDate(aTimeZone, kotlinXDate);
    }

    public static final int offsetOnTime(@NotNull ATimeZone $this$offsetOnTime, @NotNull KotlinXDateTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetOnTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return TimeZoneKt.offsetIn((Instant)time.getInstant(), (kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.of($this$offsetOnTime.getId())).getTotalSeconds() / 60;
    }

    @Nullable
    public static final KotlinXDateTime nextTransition(@NotNull ATimeZone $this$nextTransition, @NotNull KotlinXDateTime from) {
        Intrinsics.checkNotNullParameter((Object)$this$nextTransition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        long fromMillis = ADateJvmKt.getMillis(from);
        long transitionMillis = DateTimeZone.forID((String)$this$nextTransition.getId()).nextTransition(fromMillis);
        return fromMillis == transitionMillis ? null : ADateJvmKt.toADateTime(Instant.Companion.fromEpochMilliseconds(transitionMillis), from.getZone());
    }

    public static final long getMillis(@NotNull KotlinXDateTime $this$millis) {
        Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
        return $this$millis.getInstant().toEpochMilliseconds();
    }

    public static final long getMillis(@NotNull JodaDateTime $this$millis) {
        Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
        return $this$millis.getDateTime().getMillis();
    }

    @NotNull
    public static final KotlinXDateTime getANow() {
        return ADateJvmKt.getADateTime(Clock.System.INSTANCE.now());
    }

    @NotNull
    public static final KotlinXDate getEpochStart() {
        return epochStart;
    }

    @NotNull
    public static final KotlinXDate getToday() {
        return new KotlinXDateImpl(ClockKt.todayAt((Clock)((Clock)Clock.System.INSTANCE), (kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.currentSystemDefault()));
    }

    @NotNull
    public static final KotlinXDateTime roundToMillis(@NotNull KotlinXDateTime $this$roundToMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$roundToMillis, (String)"<this>");
        return ADateJvmKt.withTime($this$roundToMillis, $this$roundToMillis.getDateTime().getHour(), $this$roundToMillis.getDateTime().getMinute(), $this$roundToMillis.getDateTime().getSecond(), $this$roundToMillis.getDateTime().getNanosecond() / 1000000);
    }

    @NotNull
    public static final KotlinXDateTime aDateTime(long millis) {
        return ADateJvmKt.getADateTime(Instant.Companion.fromEpochMilliseconds(millis));
    }

    @Deprecated(message="Do not use ADateTimeLegacy")
    @NotNull
    public static final JodaDateTime aDateTimeLegacy(long millis) {
        return JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl(new DateTime(millis)));
    }

    @NotNull
    public static final JodaDateTime aDateTimeLegacy(@NotNull String internal) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        DateTime dateTime2 = DateTime.parse((String)internal);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"parse(internal)");
        return JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl(dateTime2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final KotlinXDateTime aDateTime(@NotNull String internal) {
        KotlinXDateTime kotlinXDateTime;
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        int timeStart = StringsKt.indexOf$default((CharSequence)internal, (char)'T', (int)0, (boolean)true, (int)2, null);
        if (timeStart < 0) {
            return ADateJvmKt.toADateTime(kotlinx.datetime.LocalDateTime.Companion.parse(Intrinsics.stringPlus((String)internal, (Object)"T00:00")), ADateJvmKt.getClientTimeZone());
        }
        if (!StringsKt.endsWith((CharSequence)internal, (char)'Z', (boolean)true)) {
            Object[] objectArray = new String[]{"+", "-"};
            if (StringsKt.indexOfAny$default((CharSequence)internal, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)timeStart, (boolean)false, (int)4, null) < 0) {
                kotlinXDateTime = ADateJvmKt.toADateTime(kotlinx.datetime.LocalDateTime.Companion.parse(internal), ADateJvmKt.getClientTimeZone());
                return kotlinXDateTime;
            }
        }
        kotlinXDateTime = ADateJvmKt.toADateTime(Instant.Companion.parse(internal), ADateJvmKt.getClientTimeZone());
        return kotlinXDateTime;
    }

    @NotNull
    public static final KotlinXDate aDate(@NotNull String internal) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        return ADateJvmKt.getADate(kotlinx.datetime.LocalDate.Companion.parse(internal));
    }

    @NotNull
    public static final JodaDate aDateLegacy(@NotNull String internal) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        org.joda.time.LocalDate localDate = org.joda.time.LocalDate.parse((String)internal);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(internal)");
        return JodaDateImpl.box-impl(JodaDateImpl.constructor-impl(localDate));
    }

    @NotNull
    public static final KotlinXDate aDate(int year, int month, int day) {
        return ADateJvmKt.getADate(new kotlinx.datetime.LocalDate(year, month, day));
    }

    public static final int getDayOfMonth(@NotNull KotlinXDate $this$dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$dayOfMonth, (String)"<this>");
        return $this$dayOfMonth.getDate().getDayOfMonth();
    }

    public static final int getMonth(@NotNull KotlinXDate $this$month) {
        Intrinsics.checkNotNullParameter((Object)$this$month, (String)"<this>");
        return $this$month.getDate().getMonthNumber();
    }

    public static final int getYear(@NotNull KotlinXDate $this$year) {
        Intrinsics.checkNotNullParameter((Object)$this$year, (String)"<this>");
        return $this$year.getDate().getYear();
    }

    @NotNull
    public static final Weekday getWeekday(@NotNull KotlinXDate $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        Weekday weekday = WorkingDaysKt.weekday($this$weekday.getDate().getDayOfWeek().name());
        if (weekday == null) {
            throw new IllegalArgumentException("Unknown weekday name");
        }
        return weekday;
    }

    public static final int getMillisOfSecond(@NotNull KotlinXDateTime $this$millisOfSecond) {
        Intrinsics.checkNotNullParameter((Object)$this$millisOfSecond, (String)"<this>");
        return $this$millisOfSecond.getDateTime().getNanosecond() / 1000000;
    }

    public static final int getSecond(@NotNull KotlinXDateTime $this$second) {
        Intrinsics.checkNotNullParameter((Object)$this$second, (String)"<this>");
        return $this$second.getDateTime().getSecond();
    }

    public static final int getMinute(@NotNull KotlinXDateTime $this$minute) {
        Intrinsics.checkNotNullParameter((Object)$this$minute, (String)"<this>");
        return $this$minute.getDateTime().getMinute();
    }

    public static final int getMinuteOfDay(@NotNull KotlinXDateTime $this$minuteOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$minuteOfDay, (String)"<this>");
        return $this$minuteOfDay.getDateTime().getHour() * 60 + $this$minuteOfDay.getDateTime().getMinute();
    }

    public static final int getHour(@NotNull KotlinXDateTime $this$hour) {
        Intrinsics.checkNotNullParameter((Object)$this$hour, (String)"<this>");
        return $this$hour.getDateTime().getHour();
    }

    public static final int getDayOfMonth(@NotNull KotlinXDateTime $this$dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$dayOfMonth, (String)"<this>");
        return $this$dayOfMonth.getDateTime().getDayOfMonth();
    }

    public static final int getMonth(@NotNull KotlinXDateTime $this$month) {
        Intrinsics.checkNotNullParameter((Object)$this$month, (String)"<this>");
        return $this$month.getDateTime().getMonthNumber();
    }

    public static final int getYear(@NotNull KotlinXDateTime $this$year) {
        Intrinsics.checkNotNullParameter((Object)$this$year, (String)"<this>");
        return $this$year.getDateTime().getYear();
    }

    @NotNull
    public static final Weekday getWeekday(@NotNull KotlinXDateTime $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        return WorkingDaysKt.weekday($this$weekday.getDateTime().getDayOfWeek());
    }

    @NotNull
    public static final KotlinXDate withDay(@NotNull KotlinXDate $this$withDay, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDay, (String)"<this>");
        return ADateJvmKt.getADate(new kotlinx.datetime.LocalDate($this$withDay.getDate().getYear(), $this$withDay.getDate().getMonth(), day));
    }

    public static final int getLastMonthDay(@NotNull KotlinXDate $this$getLastMonthDay) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastMonthDay, (String)"<this>");
        return LocalDateKt.minus((kotlinx.datetime.LocalDate)LocalDateJvmKt.plus((kotlinx.datetime.LocalDate)new kotlinx.datetime.LocalDate($this$getLastMonthDay.getDate().getYear(), $this$getLastMonthDay.getDate().getMonth(), 1), (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.MonthBased(1))), (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.DayBased(1))).getDayOfMonth();
    }

    @NotNull
    public static final KotlinXDate withDayOrLastMonthDay(@NotNull KotlinXDate $this$withDayOrLastMonthDay, int day) {
        KotlinXDate kotlinXDate;
        Intrinsics.checkNotNullParameter((Object)$this$withDayOrLastMonthDay, (String)"<this>");
        try {
            kotlinXDate = ADateJvmKt.withDay($this$withDayOrLastMonthDay, day);
        }
        catch (IllegalArgumentException _) {
            kotlinXDate = ADateJvmKt.getADate(LocalDateKt.minus((kotlinx.datetime.LocalDate)LocalDateJvmKt.plus((kotlinx.datetime.LocalDate)new kotlinx.datetime.LocalDate($this$withDayOrLastMonthDay.getDate().getYear(), $this$withDayOrLastMonthDay.getDate().getMonth(), 1), (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.MonthBased(1))), (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.DayBased(1))));
        }
        return kotlinXDate;
    }

    @NotNull
    public static final KotlinXDate minusDays(@NotNull KotlinXDate $this$minusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$minusDays, (String)"<this>");
        return ADateJvmKt.getADate(LocalDateJvmKt.minus((kotlinx.datetime.LocalDate)$this$minusDays.getDate(), (int)days, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.DayBased(1))));
    }

    @NotNull
    public static final KotlinXDate minusMonths(@NotNull KotlinXDate $this$minusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$minusMonths, (String)"<this>");
        return ADateJvmKt.getADate(LocalDateJvmKt.minus((kotlinx.datetime.LocalDate)$this$minusMonths.getDate(), (int)months, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.MonthBased(1))));
    }

    @NotNull
    public static final KotlinXDate plusDays(@NotNull KotlinXDate $this$plusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        return ADateJvmKt.getADate(LocalDateJvmKt.plus((kotlinx.datetime.LocalDate)$this$plusDays.getDate(), (int)days, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.DayBased(1))));
    }

    @NotNull
    public static final KotlinXDate plusMonths(@NotNull KotlinXDate $this$plusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        return ADateJvmKt.getADate(LocalDateJvmKt.plus((kotlinx.datetime.LocalDate)$this$plusMonths.getDate(), (int)months, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.MonthBased(1))));
    }

    @NotNull
    public static final KotlinXDate plusYears(@NotNull KotlinXDate $this$plusYears, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$plusYears, (String)"<this>");
        return ADateJvmKt.getADate(LocalDateJvmKt.plus((kotlinx.datetime.LocalDate)$this$plusYears.getDate(), (int)years, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DateBased.MonthBased(12))));
    }

    @NotNull
    public static final ATimeZone getClientTimeZone() {
        String string2 = TimeZone.getDefault().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().id");
        return ADateKt.getATimeZone(string2);
    }

    @NotNull
    public static final String getInternal(@NotNull KotlinXDate $this$internal) {
        Intrinsics.checkNotNullParameter((Object)$this$internal, (String)"<this>");
        return $this$internal.getDate().toString();
    }

    @NotNull
    public static final Object getInternalCompat(@NotNull KotlinXDate $this$internalCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$internalCompat, (String)"<this>");
        return $this$internalCompat.getInternalCompatible();
    }

    @NotNull
    public static final Object getInternalString(@NotNull JodaDate $this$internalString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$internalString, (String)"<this>");
        if ($this$internalString instanceof JodaDateCompat) {
            String string2 = PrimitivesExKt.getDEFAULT_DATE_FORMAT().print((ReadablePartial)$this$internalString.getDate());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEFAULT_DATE_FORMAT.print(date)");
            ADateObsolete aDateObsolete = new ADateObsolete(string2);
            object = aDateObsolete;
        } else {
            object = PrimitivesExKt.getDEFAULT_DATE_FORMAT().print((ReadablePartial)$this$internalString.getDate());
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"if (this is JodaDateComp\u2026MAT.print(date)\n        }");
        return object2;
    }

    @NotNull
    public static final String formatDate(@NotNull KotlinXDate $this$formatDate, @NotNull KotlinXDate now) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return DatesKt.formatDate($this$formatDate.getDate(), now.getDate());
    }

    public static /* synthetic */ String formatDate$default(KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate2 = ADateJvmKt.getToday();
        }
        return ADateJvmKt.formatDate(kotlinXDate, kotlinXDate2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull KotlinXDateTime $this$formatDateTime, @NotNull DateTimeMode mode2, @NotNull KotlinXDateTime now) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return DatesKt.formatDateTime($this$formatDateTime.getDateTime(), mode2, now.getDateTime(), kotlinx.datetime.TimeZone.Companion.currentSystemDefault());
    }

    public static /* synthetic */ String formatDateTime$default(KotlinXDateTime kotlinXDateTime, DateTimeMode dateTimeMode, KotlinXDateTime kotlinXDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 2) != 0) {
            kotlinXDateTime2 = ADateJvmKt.getANow();
        }
        return ADateJvmKt.formatDateTime(kotlinXDateTime, dateTimeMode, kotlinXDateTime2);
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull KotlinXDateTime $this$formatFullDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$formatFullDateTime, (String)"<this>");
        return DatesKt.formatFullDateTime($this$formatFullDateTime.getDateTime());
    }

    @NotNull
    public static final KotlinXDateTime aDateTime(int year, int month, int day, int hours, int minutes, @NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        return ADateJvmKt.toADateTime(new kotlinx.datetime.LocalDateTime(year, month, day, hours, minutes, 0, 0, 96, null), timezone);
    }

    @NotNull
    public static final KotlinXDateTime atTime(@NotNull KotlinXDate $this$atTime, @NotNull KotlinXDateTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$atTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        kotlinx.datetime.LocalDateTime localDateTime = time.getDateTime();
        boolean bl = false;
        boolean bl2 = false;
        kotlinx.datetime.LocalDateTime localTime = localDateTime;
        boolean bl3 = false;
        return ADateJvmKt.toADateTime(new kotlinx.datetime.LocalDateTime($this$atTime.getDate().getYear(), $this$atTime.getDate().getMonth(), $this$atTime.getDate().getDayOfMonth(), localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNanosecond()), time.getZone());
    }

    private static final DateTimeZone dateTimeZoneSafe(String $this$dateTimeZoneSafe) {
        DateTimeZone dateTimeZone;
        try {
            dateTimeZone = DateTimeZone.forID((String)$this$dateTimeZoneSafe);
        }
        catch (IllegalArgumentException e) {
            dateTimeZone = null;
        }
        return dateTimeZone;
    }

    static {
        String string2 = "T(\\d{2}:\\d{2})$";
        boolean bl = false;
        timeWithoutSecond = new Regex(string2);
        epochStart = new KotlinXDateImpl(new kotlinx.datetime.LocalDate(LocalDate.ofEpochDay(0L).getYear(), 1, 1));
    }
}

