/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.StringUtilsKt;
import runtime.stringUtils.Symbols;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u001a\n\u0010\u0019\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u0005\u001a\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u00052\n\u0010\u001c\u001a\u00020\u001d\"\u00020\u001e\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u0005\u001a\u001c\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!0\n*\u00020\u0005\u001a\u001c\u0010#\u001a\u00020\u0005*\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\t\u001a\u0015\u0010&\u001a\u00020\u0005*\u00020\u00052\u0006\u0010'\u001a\u00020\u000eH\u0086\u0002\u001a\n\u0010(\u001a\u00020\u0005*\u00020\u0005\u001a0\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\n\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0\n2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020\"0,\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006-"}, d2={"whitespaceRegex", "Lkotlin/text/Regex;", "getWhitespaceRegex", "()Lkotlin/text/Regex;", "getPostfix", "", "string", "prefix", "containsIgnoreCase", "", "", "element", "ellipsize", "take", "", "limitedView", "maxLength", "pluralize", "count", "", "quoted", "quotation", "removePrefixOrNull", "removeSuffixOrNull", "suffix", "removeWhitespace", "singularize", "splitByCamelHumpsAndPunctuation", "letterLikeChars", "", "", "splitByWhitespace", "splitByWhitespaceWithRanges", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "surround", "symbols", "reverseSuffix", "times", "n", "withNbsp", "withoutIntersections", "T", "getRange", "Lkotlin/Function1;", "platform-runtime"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex whitespaceRegex = new Regex("\\s");

    @NotNull
    public static final String getPostfix(@NotNull String string2, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CharSequence charSequence = string2;
        String string3 = Intrinsics.stringPlus((String)prefix, (Object)"(.*)");
        boolean bl = false;
        string3 = new Regex(string3);
        String string4 = "$1";
        boolean bl2 = false;
        return string3.replaceFirst(charSequence, string4);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, long count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return count2 == 1L ? $this$pluralize : (StringsKt.endsWith$default((String)$this$pluralize, (String)"s", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"x", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"z", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)$this$pluralize, (Object)"es") : (StringsKt.endsWith$default((String)$this$pluralize, (String)"y", (boolean)false, (int)2, null) ? (StringsKt.endsWith$default((String)$this$pluralize, (String)"ay", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ey", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"oy", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"uy", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)$this$pluralize, (Object)"s") : (StringsKt.endsWith$default((String)$this$pluralize, (String)"iy", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$pluralize, (int)1), (Object)"es") : Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$pluralize, (int)1), (Object)"ies"))) : Intrinsics.stringPlus((String)$this$pluralize, (Object)"s")));
    }

    @NotNull
    public static final String singularize(@NotNull String $this$singularize) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$singularize, (String)"<this>");
        if (StringsKt.endsWith$default((String)$this$singularize, (String)"ies", (boolean)false, (int)2, null)) {
            string2 = Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$singularize, (int)3), (Object)"y");
        } else if (StringsKt.endsWith$default((String)$this$singularize, (String)"es", (boolean)false, (int)2, null)) {
            String string3;
            String string4 = StringsKt.dropLast((String)$this$singularize, (int)2);
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            String string5 = string3 = StringsKt.endsWith$default((CharSequence)it, (char)'s', (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)it, (char)'x', (boolean)false, (int)2, null) ? string4 : null;
            string2 = string3 == null ? StringsKt.dropLast((String)$this$singularize, (int)1) : string3;
        } else {
            string2 = StringsKt.endsWith$default((CharSequence)$this$singularize, (char)'s', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$singularize, (int)1) : $this$singularize;
        }
        return string2;
    }

    @NotNull
    public static final List<String> splitByCamelHumpsAndPunctuation(@NotNull String $this$splitByCamelHumpsAndPunctuation, char ... letterLikeChars) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByCamelHumpsAndPunctuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)letterLikeChars, (String)"letterLikeChars");
        StringBuilder currentToken = new StringBuilder();
        boolean bl = false;
        List result2 = new ArrayList();
        boolean isPrevUpperCase = false;
        CharSequence $this$forEach$iv = $this$splitByCamelHumpsAndPunctuation;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            boolean bl2 = false;
            boolean isUpperCase = UnicodeUtilKt.isUpperCase(c);
            if (!UnicodeUtilKt.isAlphaNumeric(c) && !ArraysKt.contains((char[])letterLikeChars, (char)c)) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
            } else if (!isPrevUpperCase && isUpperCase) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
                currentToken.append(c);
            } else {
                currentToken.append(c);
            }
            isPrevUpperCase = isUpperCase;
        }
        StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
        return result2;
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, int count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (long)count2);
    }

    @NotNull
    public static final String surround(@NotNull String $this$surround, @NotNull String symbols, boolean reverseSuffix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$surround, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        StringBuilder stringBuilder = new StringBuilder().append(symbols).append($this$surround);
        if (reverseSuffix) {
            String string3 = symbols;
            boolean bl = false;
            string2 = ((Object)StringsKt.reversed((CharSequence)string3)).toString();
        } else {
            string2 = symbols;
        }
        return stringBuilder.append(string2).toString();
    }

    public static /* synthetic */ String surround$default(String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringUtilsKt.surround(string2, string3, bl);
    }

    @NotNull
    public static final String quoted(@NotNull String $this$quoted, @NotNull String quotation) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)quotation, (String)"quotation");
        return StringUtilsKt.surround$default($this$quoted, quotation, false, 2, null);
    }

    public static /* synthetic */ String quoted$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "\"";
        }
        return StringUtilsKt.quoted(string2, string3);
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return Intrinsics.stringPlus((String)$this$ellipsize, (Object)((Object)Symbols.Ellipsis));
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize, int take2) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return Intrinsics.stringPlus((String)StringsKt.take((String)$this$ellipsize, (int)take2), (Object)($this$ellipsize.length() > take2 + 1 ? Symbols.Ellipsis : ""));
    }

    @NotNull
    public static final String times(@NotNull String $this$times, int n) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        int n2 = n;
        switch (n2) {
            case 0: {
                string2 = "";
                break;
            }
            case 1: {
                string2 = $this$times;
                break;
            }
            default: {
                int i = 0;
                StringBuilder result2 = new StringBuilder($this$times);
                while (++i < n) {
                    result2.append($this$times);
                }
                String string3 = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            var i = 0\n\u2026sult.toString()\n        }");
                string2 = string3;
            }
        }
        return string2;
    }

    @Nullable
    public static final String removePrefixOrNull(@NotNull String $this$removePrefixOrNull, @NotNull String prefix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$removePrefixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((String)$this$removePrefixOrNull, (String)prefix, (boolean)false, (int)2, null)) {
            String string3 = $this$removePrefixOrNull;
            int n = prefix.length();
            boolean bl = false;
            String string4 = string3.substring(n);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public static final String removeSuffixOrNull(@NotNull String $this$removeSuffixOrNull, @NotNull String suffix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$removeSuffixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (StringsKt.endsWith$default((String)$this$removeSuffixOrNull, (String)suffix, (boolean)false, (int)2, null)) {
            String string3 = $this$removeSuffixOrNull;
            int n = 0;
            int n2 = $this$removeSuffixOrNull.length() - suffix.length();
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final String withNbsp(@NotNull String $this$withNbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$withNbsp, (String)"<this>");
        return StringsKt.replace$default((String)$this$withNbsp, (String)" ", (String)Symbols.Nbsp.toString(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String limitedView(@NotNull String $this$limitedView, int maxLength) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$limitedView, (String)"<this>");
        if ($this$limitedView.length() > maxLength) {
            String string3 = $this$limitedView;
            int n = 0;
            int n2 = maxLength - 3;
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = Intrinsics.stringPlus((String)string4, (Object)"...");
        } else {
            string2 = $this$limitedView;
        }
        return string2;
    }

    public static final boolean containsIgnoreCase(@NotNull List<String> $this$containsIgnoreCase, @NotNull String element) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$containsIgnoreCase, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable $this$any$iv = $this$containsIgnoreCase;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)element, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final Regex getWhitespaceRegex() {
        return whitespaceRegex;
    }

    @NotNull
    public static final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$removeWhitespace, (String)"<this>");
        CharSequence charSequence = $this$removeWhitespace;
        Regex regex2 = whitespaceRegex;
        String string2 = "";
        boolean bl = false;
        return regex2.replace(charSequence, string2);
    }

    @NotNull
    public static final List<String> splitByWhitespace(@NotNull String $this$splitByWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespace, (String)"<this>");
        CharSequence charSequence = $this$splitByWhitespace;
        Regex regex2 = whitespaceRegex;
        int n = 0;
        boolean bl = false;
        return regex2.split(charSequence, n);
    }

    @NotNull
    public static final List<Pair<String, IntRange>> splitByWhitespaceWithRanges(@NotNull String $this$splitByWhitespaceWithRanges) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespaceWithRanges, (String)"<this>");
        Ref.IntRef prevIndex = new Ref.IntRef();
        Sequence wordBoundaries2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super IntRange>, Continuation<? super Unit>, Object>($this$splitByWhitespaceWithRanges, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $this_splitByWhitespaceWithRanges;
            {
                this.$this_splitByWhitespaceWithRanges = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.map((Sequence)Regex.findAll$default((Regex)StringUtilsKt.getWhitespaceRegex(), (CharSequence)this.$this_splitByWhitespaceWithRanges, (int)0, (int)2, null), (Function1)splitByWhitespaceWithRanges.wordBoundaries.1.INSTANCE), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield((Object)new IntRange(this.$this_splitByWhitespaceWithRanges.length(), this.$this_splitByWhitespaceWithRanges.length()), (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super IntRange>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super IntRange> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)wordBoundaries2, (Function1)((Function1)new Function1<IntRange, Pair<? extends String, ? extends IntRange>>(prevIndex, $this$splitByWhitespaceWithRanges){
            final /* synthetic */ Ref.IntRef $prevIndex;
            final /* synthetic */ String $this_splitByWhitespaceWithRanges;
            {
                this.$prevIndex = $prevIndex;
                this.$this_splitByWhitespaceWithRanges = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<String, IntRange> invoke(@NotNull IntRange range3) {
                Ref.IntRef intRef;
                IntRange intRange;
                Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
                IntRange intRange2 = range3;
                Ref.IntRef intRef2 = this.$prevIndex;
                boolean bl = false;
                boolean bl2 = false;
                IntRange it = intRange2;
                boolean bl3 = false;
                Object object = intRange = it.getFirst() > intRef2.element ? intRange2 : null;
                if (intRange == null) {
                    intRef = null;
                } else {
                    intRef2 = intRange;
                    String string2 = this.$this_splitByWhitespaceWithRanges;
                    Ref.IntRef intRef3 = this.$prevIndex;
                    boolean bl4 = false;
                    bl3 = false;
                    Ref.IntRef it2 = intRef2;
                    boolean bl5 = false;
                    String string3 = string2;
                    int n = intRef3.element;
                    int n2 = it2.getFirst();
                    boolean bl6 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    intRange2 = TuplesKt.to((Object)string5, (Object)RangesKt.until((int)intRef3.element, (int)it2.getFirst()));
                    if (intRange2 == null) {
                        intRef = null;
                    } else {
                        intRef2 = intRange2;
                        string2 = this.$prevIndex;
                        boolean bl7 = false;
                        bl4 = false;
                        Ref.IntRef it3 = intRef2;
                        boolean bl8 = false;
                        ((Ref.IntRef)string2).element = range3.getLast() + 1;
                        intRef = intRef2;
                    }
                }
                return intRef;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> withoutIntersections(@NotNull List<? extends T> $this$withoutIntersections, @NotNull Function1<? super T, IntRange> getRange) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$withoutIntersections, (String)"<this>");
        Intrinsics.checkNotNullParameter(getRange, (String)"getRange");
        int lastRangeEndIx = 0;
        lastRangeEndIx = -1;
        Function1[] function1Array = new Function1[]{new Function1<T, Comparable<?>>(getRange){
            final /* synthetic */ Function1<T, IntRange> $getRange;
            {
                this.$getRange = $getRange;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(T it) {
                return ((IntRange)this.$getRange.invoke(it)).getFirst();
            }
        }, new Function1<T, Comparable<?>>(getRange){
            final /* synthetic */ Function1<T, IntRange> $getRange;
            {
                this.$getRange = $getRange;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(T it) {
                return -((IntRange)this.$getRange.invoke(it)).getLast();
            }
        }};
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$withoutIntersections, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = ((IntRange)getRange.invoke(it)).getFirst() > lastRangeEndIx;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean $this$withoutIntersections_u24lambda_u2d4_u24lambda_u2d3 = bl2;
            boolean bl5 = false;
            lastRangeEndIx = ((IntRange)getRange.invoke(it)).getLast();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void splitByCamelHumpsAndPunctuation$flushToken(StringBuilder currentToken, List<String> result2) {
        CharSequence charSequence = currentToken;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = currentToken.toString();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"currentToken.toString()");
            result2.add((String)charSequence);
            StringsKt.clear((StringBuilder)currentToken);
        }
    }
}

