/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.utils.LogUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aK\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a;\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a5\u0010\u000b\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\u000b\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"measureAndReturn", "T", "beforeAction", "Lkotlin/Function0;", "", "afterAction", "Lkotlin/Function1;", "", "action", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "measureTimeMillisAndLog", "opName", "", "log", "Llibraries/klogging/KLogger;", "block", "(Ljava/lang/String;Llibraries/klogging/KLogger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "printStartMsg", "", "(Ljava/lang/String;Llibraries/klogging/KLogger;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "platform-runtime"})
public final class LogUtilsKt {
    public static final <T> T measureTimeMillisAndLog(@NotNull String opName, @NotNull KLogger log2, boolean printStartMsg, @NotNull Function0<? extends T> block) {
        long ms$iv;
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (printStartMsg) {
            log2.debug(Intrinsics.stringPlus((String)opName, (Object)". Started."));
        }
        Object res$iv = block.invoke();
        long ms = ms$iv = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder().append(opName).append(" took ");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{(double)ms / (double)1000};
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        log2.debug(stringBuilder.append(string3).append('s').toString());
        return (T)res$iv;
    }

    public static /* synthetic */ Object measureTimeMillisAndLog$default(String opName, KLogger log2, boolean printStartMsg, Function0 block, int n, Object object) {
        long ms$iv;
        if ((n & 4) != 0) {
            printStartMsg = false;
        }
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (printStartMsg) {
            log2.debug(Intrinsics.stringPlus((String)opName, (Object)". Started."));
        }
        Object res$iv = block.invoke();
        long ms = ms$iv = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder().append(opName).append(" took ");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{(double)ms / (double)1000};
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        log2.debug(stringBuilder.append(string3).append('s').toString());
        return res$iv;
    }

    public static final <T> T measureTimeMillisAndLog(@NotNull String opName, @NotNull KLogger log2, @NotNull Function0<? extends T> block) {
        long ms$iv$iv;
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean printStartMsg$iv = false;
        boolean $i$f$measureTimeMillisAndLog2 = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv$iv = block.invoke();
        long ms$iv = ms$iv$iv = System.currentTimeMillis() - start$iv$iv;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder().append(opName).append(" took ");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{(double)ms$iv / (double)1000};
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        log2.debug(stringBuilder.append(string3).append('s').toString());
        return (T)res$iv$iv;
    }

    public static final <T> T measureAndReturn(@NotNull Function1<? super Long, Unit> afterAction, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        boolean $i$f$measureAndReturn2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv = action2.invoke();
        long ms$iv = System.currentTimeMillis() - start$iv;
        afterAction.invoke((Object)ms$iv);
        return (T)res$iv;
    }

    public static /* synthetic */ Object measureAndReturn$default(Function1 afterAction, Function0 action2, int n, Object object) {
        if ((n & 1) != 0) {
            afterAction = measureAndReturn.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        boolean $i$f$measureAndReturn2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv = action2.invoke();
        long ms$iv = System.currentTimeMillis() - start$iv;
        afterAction.invoke((Object)ms$iv);
        return res$iv;
    }

    public static final <T> T measureAndReturn(@NotNull Function0<Unit> beforeAction, @NotNull Function1<? super Long, Unit> afterAction, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(beforeAction, (String)"beforeAction");
        Intrinsics.checkNotNullParameter(afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        long start2 = System.currentTimeMillis();
        beforeAction.invoke();
        Object res = action2.invoke();
        long ms = System.currentTimeMillis() - start2;
        afterAction.invoke((Object)ms);
        return (T)res;
    }

    public static /* synthetic */ Object measureAndReturn$default(Function0 beforeAction, Function1 afterAction, Function0 action2, int n, Object object) {
        if ((n & 1) != 0) {
            beforeAction = measureAndReturn.3.INSTANCE;
        }
        if ((n & 2) != 0) {
            afterAction = measureAndReturn.4.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)beforeAction, (String)"beforeAction");
        Intrinsics.checkNotNullParameter((Object)afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        long start2 = System.currentTimeMillis();
        beforeAction.invoke();
        Object res = action2.invoke();
        long ms = System.currentTimeMillis() - start2;
        afterAction.invoke((Object)ms);
        return res;
    }
}

