/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.MathJvmKt;
import kotlinx.datetime.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u001a\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u001a\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0086\u0002\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u0013\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0014\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"maxEpochDay", "", "minEpochDay", "ofEpochDayChecked", "Ljava/time/LocalDate;", "epochDay", "daysUntil", "", "Lkotlinx/datetime/LocalDate;", "other", "minus", "value", "unit", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "monthsUntil", "periodUntil", "Lkotlinx/datetime/DatePeriod;", "plus", "period", "until", "yearsUntil", "kotlinx-datetime"})
@JvmName(name="LocalDateJvmKt")
public final class LocalDateJvmKt {
    private static final long minEpochDay = java.time.LocalDate.MIN.toEpochDay();
    private static final long maxEpochDay = java.time.LocalDate.MAX.toEpochDay();

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$plus, 1L, unit);
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, int value, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$plus, (long)value, unit);
    }

    @NotNull
    public static final LocalDate minus(@NotNull LocalDate $this$minus, int value, @NotNull DateTimeUnit.DateBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return LocalDateJvmKt.plus($this$minus, -((long)value), unit);
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, long value, @NotNull DateTimeUnit.DateBased unit) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            java.time.LocalDate localDate;
            object = unit;
            if (object instanceof DateTimeUnit.DateBased.DayBased) {
                long addDays = MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DateBased.DayBased)unit).getDays());
                localDate = LocalDateJvmKt.ofEpochDayChecked(MathJvmKt.safeAdd($this$plus.getValue$kotlinx_datetime().toEpochDay(), addDays));
            } else if (object instanceof DateTimeUnit.DateBased.MonthBased) {
                localDate = $this$plus.getValue$kotlinx_datetime().plusMonths(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DateBased.MonthBased)unit).getMonths()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = localDate;
            boolean addDays = false;
            boolean bl = false;
            Object p0 = object;
            boolean bl2 = false;
            object = new LocalDate((java.time.LocalDate)p0);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("The result of adding " + value + " of " + unit + " to " + $this$plus + " is out of LocalDate range.", e);
        }
        return object;
    }

    private static final java.time.LocalDate ofEpochDayChecked(long epochDay) {
        long l = minEpochDay;
        if (!(epochDay <= maxEpochDay ? l <= epochDay : false)) {
            throw new DateTimeException("The resulting day " + epochDay + " is out of supported LocalDate range.");
        }
        java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(epochDay);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(epochDay)");
        return localDate;
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $this$plus, @NotNull DatePeriod period) {
        Comparable<ChronoLocalDate> comparable;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        try {
            boolean bl = false;
            boolean bl2 = false;
            DatePeriod $this$plus_u24lambda_u2d2 = period;
            boolean bl3 = false;
            java.time.LocalDate localDate = $this$plus.getValue$kotlinx_datetime();
            boolean bl4 = false;
            boolean bl5 = false;
            java.time.LocalDate $this$plus_u24lambda_u2d2_u24lambda_u2d0 = localDate;
            boolean bl6 = false;
            localDate = $this$plus_u24lambda_u2d2.getTotalMonths$kotlinx_datetime() != 0 ? $this$plus_u24lambda_u2d2_u24lambda_u2d0.plusMonths($this$plus_u24lambda_u2d2.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u2d2_u24lambda_u2d0;
            bl4 = false;
            bl5 = false;
            java.time.LocalDate $this$plus_u24lambda_u2d2_u24lambda_u2d1 = localDate;
            boolean bl7 = false;
            comparable = $this$plus_u24lambda_u2d2.getDays() != 0 ? $this$plus_u24lambda_u2d2_u24lambda_u2d1.plusDays($this$plus_u24lambda_u2d2.getDays()) : $this$plus_u24lambda_u2d2_u24lambda_u2d1;
            bl2 = false;
            boolean bl8 = false;
            java.time.LocalDate p0 = comparable;
            boolean bl9 = false;
            comparable = new LocalDate(p0);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException("The result of adding " + $this$plus.getValue$kotlinx_datetime() + " to " + $this$plus + " is out of LocalDate range.");
        }
        return comparable;
    }

    @NotNull
    public static final DatePeriod periodUntil(@NotNull LocalDate $this$periodUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$periodUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.time.LocalDate startD = $this$periodUntil.getValue$kotlinx_datetime();
        java.time.LocalDate endD = other.getValue$kotlinx_datetime();
        long months = startD.until(endD, ChronoUnit.MONTHS);
        java.time.LocalDate localDate = startD.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"startD.plusMonths(months)");
        startD = localDate;
        long days = startD.until(endD, ChronoUnit.DAYS);
        if (months > Integer.MAX_VALUE || months < Integer.MIN_VALUE) {
            throw new DateTimeArithmeticException("The number of months between " + $this$periodUntil + " and " + other + " does not fit in an Int");
        }
        return new DatePeriod((int)months, (int)days);
    }

    public static final int until(@NotNull LocalDate $this$until, @NotNull LocalDate other, @NotNull DateTimeUnit.DateBased unit) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        DateTimeUnit.DateBased dateBased = unit;
        if (dateBased instanceof DateTimeUnit.DateBased.MonthBased) {
            n = MathKt.clampToInt($this$until.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.MONTHS) / (long)((DateTimeUnit.DateBased.MonthBased)unit).getMonths());
        } else if (dateBased instanceof DateTimeUnit.DateBased.DayBased) {
            n = MathKt.clampToInt($this$until.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.DAYS) / (long)((DateTimeUnit.DateBased.DayBased)unit).getDays());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final int daysUntil(@NotNull LocalDate $this$daysUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$daysUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt($this$daysUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.DAYS));
    }

    public static final int monthsUntil(@NotNull LocalDate $this$monthsUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$monthsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt($this$monthsUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.MONTHS));
    }

    public static final int yearsUntil(@NotNull LocalDate $this$yearsUntil, @NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$yearsUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt($this$yearsUntil.getValue$kotlinx_datetime().until(other.getValue$kotlinx_datetime(), ChronoUnit.YEARS));
    }
}

