/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "serialName", "", "values", "", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "[Ljava/lang/Enum;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "toString", "kotlinx-serialization-core"})
@PublishedApi
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    @NotNull
    private final T[] values;
    @NotNull
    private final SerialDescriptor descriptor;

    public EnumSerializer(@NotNull String serialName, @NotNull T[] values2) {
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.values = values2;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor(serialName, SerialKind.ENUM.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)((Function1)new Function1<ClassSerialDescriptorBuilder, Unit>(this, serialName){
            final /* synthetic */ EnumSerializer<T> this$0;
            final /* synthetic */ String $serialName;
            {
                this.this$0 = $receiver;
                this.$serialName = $serialName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$buildSerialDescriptor, (String)"$this$buildSerialDescriptor");
                Enum[] enumArray = EnumSerializer.access$getValues$p(this.this$0);
                String string = this.$serialName;
                boolean $i$f$forEach = false;
                void var5_5 = $this$forEach$iv;
                int n = ((void)var5_5).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = var5_5[i];
                    boolean bl = false;
                    String fqn = string + '.' + it.name();
                    SerialDescriptor enumMemberDescriptor = SerialDescriptorsKt.buildSerialDescriptor$default(fqn, StructureKind.OBJECT.INSTANCE, new SerialDescriptor[0], null, 8, null);
                    ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, it.name(), enumMemberDescriptor, null, false, 12, null);
                }
            }
        }));
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index = ArraysKt.indexOf((Object[])this.values, value);
        if (index == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(value).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            Object[] objectArray = this.values;
            boolean bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        encoder2.encodeEnum(this.getDescriptor(), index);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        int index = decoder.decodeEnum(this.getDescriptor());
        if (!(0 <= index ? index <= this.values.length + -1 : false)) {
            throw new SerializationException(index + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[index];
    }

    @NotNull
    public String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    public static final /* synthetic */ Enum[] access$getValues$p(EnumSerializer $this) {
        return $this.values;
    }
}

