/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProviderUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getEventLogProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "recorderId", "", "getEventLogProviders", "", "isJetBrainsProduct", "", "isProviderApplicable", "extension", "intellij.platform.statistics"})
public final class StatisticsEventLogProviderUtil {
    private static final Logger LOG;
    @NotNull
    public static final StatisticsEventLogProviderUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<StatisticsEventLoggerProvider> getEventLogProviders() {
        List list = StatisticsEventLoggerProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionsIfPointIsRegistered");
        List providers = list;
        if (providers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean isJetBrainsProduct = INSTANCE.isJetBrainsProduct();
        List list2 = ContainerUtil.filter((Collection)providers, (Condition)new Condition(isJetBrainsProduct){
            final /* synthetic */ boolean $isJetBrainsProduct;

            public final boolean value(StatisticsEventLoggerProvider it) {
                String string = it.getRecorderId();
                StatisticsEventLoggerProvider statisticsEventLoggerProvider = it;
                Intrinsics.checkNotNullExpressionValue((Object)statisticsEventLoggerProvider, (String)"it");
                return StatisticsEventLogProviderUtil.access$isProviderApplicable(StatisticsEventLogProviderUtil.INSTANCE, this.$isJetBrainsProduct, string, statisticsEventLoggerProvider);
            }
            {
                this.$isJetBrainsProduct = bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.filter(pro\u2026uct, it.recorderId, it) }");
        Iterable $this$distinctBy$iv = list2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)e$iv;
            boolean bl = false;
            String key$iv = it.getRecorderId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @JvmStatic
    @NotNull
    public static final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.getExtensionArea().hasExtensionPoint(StatisticsEventLoggerProvider.Companion.getEP_NAME().getName())) {
            StatisticsEventLoggerProvider provider2;
            boolean isJetBrainsProduct = INSTANCE.isJetBrainsProduct();
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = provider2 = (StatisticsEventLoggerProvider)StatisticsEventLoggerProvider.Companion.getEP_NAME().findFirstSafe(new Predicate(isJetBrainsProduct, recorderId){
                final /* synthetic */ boolean $isJetBrainsProduct;
                final /* synthetic */ String $recorderId;

                public final boolean test(StatisticsEventLoggerProvider it) {
                    StatisticsEventLoggerProvider statisticsEventLoggerProvider = it;
                    Intrinsics.checkNotNullExpressionValue((Object)statisticsEventLoggerProvider, (String)"it");
                    return StatisticsEventLogProviderUtil.access$isProviderApplicable(StatisticsEventLogProviderUtil.INSTANCE, this.$isJetBrainsProduct, this.$recorderId, statisticsEventLoggerProvider);
                }
                {
                    this.$isJetBrainsProduct = bl;
                    this.$recorderId = string;
                }
            });
            if (statisticsEventLoggerProvider != null) {
                StatisticsEventLoggerProvider statisticsEventLoggerProvider2 = statisticsEventLoggerProvider;
                boolean bl = false;
                boolean bl2 = false;
                StatisticsEventLoggerProvider it = statisticsEventLoggerProvider2;
                boolean bl3 = false;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Use event log provider '" + provider2.getClass().getSimpleName() + "' for recorder-id=" + recorderId);
                }
                return it;
            }
        }
        LOG.warn("Cannot find event log provider with recorder-id=" + recorderId);
        return new EmptyStatisticsEventLoggerProvider(recorderId);
    }

    private final boolean isJetBrainsProduct() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        if (appInfo == null || StringUtil.isEmpty((String)appInfo.getShortCompanyName())) {
            return true;
        }
        return PlatformUtils.isJetBrainsProduct();
    }

    private final boolean isProviderApplicable(boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        if (Intrinsics.areEqual((Object)recorderId, (Object)extension.getRecorderId())) {
            if (!isJetBrainsProduct || !StatisticsRecorderUtil.isBuildInRecorder(recorderId)) {
                return true;
            }
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
            return Intrinsics.areEqual((Object)recorderId, (Object)"MLSE") ? pluginInfo.isDevelopedByJetBrains() : pluginInfo.getType() == PluginType.PLATFORM || pluginInfo.getType() == PluginType.FROM_SOURCES || pluginInfo.isAllowedToInjectIntoFUS();
        }
        return false;
    }

    private StatisticsEventLogProviderUtil() {
    }

    static {
        StatisticsEventLogProviderUtil statisticsEventLogProviderUtil;
        INSTANCE = statisticsEventLogProviderUtil = new StatisticsEventLogProviderUtil();
        Logger logger2 = Logger.getInstance(StatisticsEventLogProviderUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Stati\u2026ProviderUtil::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ boolean access$isProviderApplicable(StatisticsEventLogProviderUtil $this, boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        return $this.isProviderApplicable(isJetBrainsProduct, recorderId, extension);
    }
}

