/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.SeparatorAction;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J>\u0010\b\u001a\u00020\t2\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0016\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0016JL\u0010\u0014\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0017j\b\u0012\u0004\u0012\u00020\u0004`\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0017j\b\u0012\u0004\u0012\u00020\u001a`\u0018H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "appendName", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "parentMenuPath", "collectMainMenuActions", "", "groups", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "parentName", "dumpActionsNames", "outputFile", "getCommandName", "main", "args", "", "processAction", "actionId", "visitedActions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "actionsDescriptions", "Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter$ActionDescription;", "ActionDescription", "intellij.platform.statistics"})
public final class DumpActionsAppStarter
implements ApplicationStarter {
    @NotNull
    public String getCommandName() {
        return "dumpActions";
    }

    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object object = CollectionsKt.getOrNull(args, (int)1);
        Intrinsics.checkNotNull((Object)object);
        String outputFile = (String)object;
        this.dumpActionsNames(outputFile);
        int n = 0;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void dumpActionsNames(String outputFile) {
        Object action;
        ActionManager actionManager = ActionManager.getInstance();
        List list = actionManager.getActionIdList("");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"actionManager.getActionIdList(\"\")");
        List actionIdList = list;
        HashSet<String> visitedActions = new HashSet<String>();
        HashSet<ActionDescription> actionsDescriptions = new HashSet<ActionDescription>();
        for (String actionId : actionIdList) {
            action = actionManager.getAction(actionId);
            this.processAction((AnAction)action, actionId, visitedActions, actionsDescriptions);
        }
        HashMap<String, String> mainMenuAction = new HashMap<String, String>();
        AnAction anAction = actionManager.getAction("MainMenu");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        this.collectMainMenuActions(mainMenuAction, (AnAction)((ActionGroup)anAction), null);
        StringBuilder builder = new StringBuilder();
        action = builder;
        String string = "Id;Name;Description;Path";
        boolean bl = false;
        StringBuilder stringBuilder = ((StringBuilder)action).append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        for (ActionDescription description : actionsDescriptions) {
            StringBuilder stringBuilder3;
            String string2 = mainMenuAction.get(description.getId());
            if (string2 == null) {
                string2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mainMenuAction[description.id] ?: \"\"");
            String path = string2;
            stringBuilder2 = builder;
            String string3 = description.getId() + ';' + description.getName() + ';' + description.getDescription() + ';' + path;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(string3), (String)"append(value)");
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        FileUtil.writeToFile((File)new File(outputFile), (String)builder.toString());
        File file = new File(outputFile);
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
        FilesKt.writeText$default((File)file, (String)string4, null, (int)2, null);
    }

    private final void collectMainMenuActions(HashMap<String, String> groups, AnAction action, String parentName) {
        if (action instanceof SeparatorAction) {
            return;
        }
        try {
            String path = this.appendName(action, parentName);
            if (action instanceof ActionGroup) {
                AnAction[] anActionArray = ((ActionGroup)action).getChildren(null);
                int n = anActionArray.length;
                for (int i = 0; i < n; ++i) {
                    AnAction child;
                    AnAction anAction = child = anActionArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"child");
                    this.collectMainMenuActions(groups, anAction, path);
                }
            } else {
                String string = ActionManager.getInstance().getId(action);
                if (string == null) {
                    string = action.getClass().getName();
                }
                String id = string;
                Map map = groups;
                String string2 = id;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
                map.put(string2, path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void processAction(AnAction action, String actionId, HashSet<String> visitedActions, HashSet<ActionDescription> actionsDescriptions) {
        if (action == null) {
            return;
        }
        if (action instanceof SeparatorAction) {
            return;
        }
        try {
            String name;
            String id;
            String string;
            String string2 = actionId;
            if (string2 == null) {
                string2 = string = ActionManager.getInstance().getId(action);
            }
            if (string2 == null) {
                string = id = action.getClass().getName();
            }
            if (visitedActions.contains(id)) {
                return;
            }
            visitedActions.add(id);
            Presentation presentation = action.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation");
            Presentation templatePresentation = presentation;
            String string3 = templatePresentation.getText();
            if (string3 == null) {
                string3 = name = "";
            }
            if (action instanceof ActionGroup) {
                AnAction[] children;
                for (AnAction child : children = ((ActionGroup)action).getChildren(null)) {
                    this.processAction(child, null, visitedActions, actionsDescriptions);
                }
            } else {
                String string4 = id;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"id");
                if (!StringsKt.startsWith$default((String)string4, (String)"<anonymous-group", (boolean)false, (int)2, null)) {
                    String string5 = templatePresentation.getDescription();
                    if (string5 == null) {
                        string5 = "";
                    }
                    String description = string5;
                    actionsDescriptions.add(new ActionDescription(id, name, description));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String appendName(AnAction action, String parentMenuPath) {
        String string;
        Presentation presentation = action.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation");
        Presentation templatePresentation = presentation;
        if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
            String string2 = parentMenuPath;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
        CharSequence charSequence = templatePresentation.getText();
        boolean bl = false;
        boolean bl2 = false;
        String text = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "?" : templatePresentation.getText();
        charSequence = parentMenuPath;
        bl = false;
        bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string3 = text;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text");
        } else {
            string = parentMenuPath + " | " + text;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter$ActionDescription;", "", "id", "", "name", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getId", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ActionDescription {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String description;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public ActionDescription(@NotNull String id, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.id = id;
            this.name = name;
            this.description = description;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ActionDescription copy(@NotNull String id, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new ActionDescription(id, name, description);
        }

        public static /* synthetic */ ActionDescription copy$default(ActionDescription actionDescription, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = actionDescription.id;
            }
            if ((n & 2) != 0) {
                string2 = actionDescription.name;
            }
            if ((n & 4) != 0) {
                string3 = actionDescription.description;
            }
            return actionDescription.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ActionDescription(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.name;
            String string3 = this.description;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActionDescription)) break block3;
                    ActionDescription actionDescription = (ActionDescription)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)actionDescription.id) || !Intrinsics.areEqual((Object)this.name, (Object)actionDescription.name) || !Intrinsics.areEqual((Object)this.description, (Object)actionDescription.description)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

