/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.vcs.FilePath;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/ignore/GitRepositoryIgnoredFilesHolder;", "", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "ignoredFilePaths", "", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredFilePaths", "()Ljava/util/Set;", "containsFile", "", "file", "createWaiter", "Lgit4idea/repo/GitUntrackedFilesHolder$Waiter;", "isInUpdateMode", "removeIgnoredFiles", "", "filePaths", "", "retrieveIgnoredFilePaths", "intellij.vcs.git"})
public final class GitRepositoryIgnoredFilesHolder {
    private final GitRepository repository;

    public final boolean isInUpdateMode() {
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.repository.getUntrackedFilesHolder();
        Intrinsics.checkNotNullExpressionValue((Object)gitUntrackedFilesHolder, (String)"repository.untrackedFilesHolder");
        return gitUntrackedFilesHolder.isInUpdateMode();
    }

    public final boolean containsFile(@NotNull FilePath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.repository.getUntrackedFilesHolder().containsIgnoredFile(file);
    }

    @NotNull
    public final Set<FilePath> getIgnoredFilePaths() {
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.repository.getUntrackedFilesHolder();
        Intrinsics.checkNotNullExpressionValue((Object)gitUntrackedFilesHolder, (String)"repository.untrackedFilesHolder");
        Collection<FilePath> collection = gitUntrackedFilesHolder.getIgnoredFilePaths();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.untrackedFilesHolder.ignoredFilePaths");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @NotNull
    public final Collection<FilePath> retrieveIgnoredFilePaths() {
        Collection<FilePath> collection = this.repository.getUntrackedFilesHolder().retrieveIgnoredFilePaths();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.untrackedFile\u2026etrieveIgnoredFilePaths()");
        return collection;
    }

    public final void removeIgnoredFiles(@NotNull Collection<? extends FilePath> filePaths) {
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
        this.repository.getUntrackedFilesHolder().removeIgnored(filePaths);
    }

    @TestOnly
    @NotNull
    public final GitUntrackedFilesHolder.Waiter createWaiter() {
        GitUntrackedFilesHolder.Waiter waiter = this.repository.getUntrackedFilesHolder().createWaiter();
        Intrinsics.checkNotNullExpressionValue((Object)waiter, (String)"repository.untrackedFilesHolder.createWaiter()");
        return waiter;
    }

    public GitRepositoryIgnoredFilesHolder(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }
}

