/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays;

import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.datavis.r.inlays.NotebookInlayComponent;
import org.intellij.datavis.r.inlays.NotebookInlayComponentPsiKt;
import org.intellij.datavis.r.ui.UiCustomizer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/intellij/datavis/r/inlays/NotebookInlayComponentPsi;", "Lorg/intellij/datavis/r/inlays/NotebookInlayComponent;", "cell", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getCell", "()Lcom/intellij/psi/PsiElement;", "updateCellSeparator", "", "intellij.notebooks.visualization"})
public final class NotebookInlayComponentPsi
extends NotebookInlayComponent {
    @NotNull
    private final PsiElement cell;

    @Override
    protected void updateCellSeparator() {
        if (!UiCustomizer.Companion.getInstance().getShowUpdateCellSeparator()) {
            return;
        }
        if (this.getSeparatorHighlighter() != null) {
            RangeHighlighter rangeHighlighter = this.getSeparatorHighlighter();
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            int n = rangeHighlighter.getStartOffset();
            TextRange textRange = this.cell.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"cell.textRange");
            if (n == textRange.getStartOffset()) {
                RangeHighlighter rangeHighlighter2 = this.getSeparatorHighlighter();
                Intrinsics.checkNotNull((Object)rangeHighlighter2);
                int n2 = rangeHighlighter2.getEndOffset();
                TextRange textRange2 = this.cell.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"cell.textRange");
                if (n2 == textRange2.getEndOffset()) {
                    return;
                }
            }
        }
        if (this.getSeparatorHighlighter() != null) {
            MarkupModelEx markupModelEx = this.getEditor().getMarkupModel();
            RangeHighlighter rangeHighlighter = this.getSeparatorHighlighter();
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            markupModelEx.removeHighlighter(rangeHighlighter);
        }
        TextRange textRange = this.cell.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"cell.textRange");
        int n = textRange.getEndOffset();
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        if (n > documentEx.getTextLength()) {
            return;
        }
        try {
            EditorImpl editorImpl = this.getEditor();
            TextRange textRange3 = this.cell.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"cell.textRange");
            this.setSeparatorHighlighter(NotebookInlayComponentPsiKt.access$createSeparatorHighlighter(editorImpl, textRange3));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final PsiElement getCell() {
        return this.cell;
    }

    public NotebookInlayComponentPsi(@NotNull PsiElement cell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(editor);
        this.cell = cell;
    }
}

