/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import java.awt.Dimension;
import java.awt.Toolkit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.datavis.r.inlays.components.DialogUtil$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/intellij/datavis/r/inlays/components/DialogUtil;", "", "()V", "calculatePreferredSize", "Ljava/awt/Dimension;", "widthRatio", "", "heightRatio", "sizePreference", "Lorg/intellij/datavis/r/inlays/components/DialogUtil$SizePreference;", "widthPreference", "heightPreference", "calculateRatioByPreference", "checkRatio", "", "ratio", "name", "", "SizePreference", "intellij.notebooks.visualization"})
public final class DialogUtil {
    @NotNull
    public static final DialogUtil INSTANCE;

    @NotNull
    public final Dimension calculatePreferredSize(@NotNull SizePreference sizePreference) {
        Intrinsics.checkNotNullParameter((Object)((Object)sizePreference), (String)"sizePreference");
        return this.calculatePreferredSize(sizePreference, sizePreference);
    }

    @NotNull
    public final Dimension calculatePreferredSize(@NotNull SizePreference widthPreference, @NotNull SizePreference heightPreference) {
        Intrinsics.checkNotNullParameter((Object)((Object)widthPreference), (String)"widthPreference");
        Intrinsics.checkNotNullParameter((Object)((Object)heightPreference), (String)"heightPreference");
        double widthRatio = this.calculateRatioByPreference(widthPreference);
        double heightRatio = this.calculateRatioByPreference(heightPreference);
        return this.calculatePreferredSize(widthRatio, heightRatio);
    }

    private final Dimension calculatePreferredSize(double widthRatio, double heightRatio) {
        this.checkRatio(widthRatio, "Width");
        this.checkRatio(heightRatio, "Height");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
        Dimension screenSize = toolkit.getScreenSize();
        int width = (int)((double)screenSize.width * widthRatio);
        int height = (int)((double)screenSize.height * heightRatio);
        return new Dimension(width, height);
    }

    private final void checkRatio(double ratio, String name) {
        if (ratio <= 0.0 || ratio > 1.0) {
            throw (Throwable)new IllegalArgumentException(name + " ratio must fall within the range (0.0; 1.0]. Actual value was " + ratio);
        }
    }

    private final double calculateRatioByPreference(SizePreference sizePreference) {
        double d;
        switch (DialogUtil$WhenMappings.$EnumSwitchMapping$0[sizePreference.ordinal()]) {
            case 1: {
                d = 0.15;
                break;
            }
            case 2: {
                d = 0.25;
                break;
            }
            case 3: {
                d = 0.5;
                break;
            }
            case 4: {
                d = 0.75;
                break;
            }
            case 5: {
                d = 0.85;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    private DialogUtil() {
    }

    static {
        DialogUtil dialogUtil;
        INSTANCE = dialogUtil = new DialogUtil();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/datavis/r/inlays/components/DialogUtil$SizePreference;", "", "(Ljava/lang/String;I)V", "VERY_NARROW", "NARROW", "MODERATE", "WIDE", "VERY_WIDE", "intellij.notebooks.visualization"})
    public static final class SizePreference
    extends Enum<SizePreference> {
        public static final /* enum */ SizePreference VERY_NARROW;
        public static final /* enum */ SizePreference NARROW;
        public static final /* enum */ SizePreference MODERATE;
        public static final /* enum */ SizePreference WIDE;
        public static final /* enum */ SizePreference VERY_WIDE;
        private static final /* synthetic */ SizePreference[] $VALUES;

        static {
            SizePreference[] sizePreferenceArray = new SizePreference[5];
            SizePreference[] sizePreferenceArray2 = sizePreferenceArray;
            sizePreferenceArray[0] = VERY_NARROW = new SizePreference();
            sizePreferenceArray[1] = NARROW = new SizePreference();
            sizePreferenceArray[2] = MODERATE = new SizePreference();
            sizePreferenceArray[3] = WIDE = new SizePreference();
            sizePreferenceArray[4] = VERY_WIDE = new SizePreference();
            $VALUES = sizePreferenceArray;
        }

        public static SizePreference[] values() {
            return (SizePreference[])$VALUES.clone();
        }

        public static SizePreference valueOf(String string) {
            return Enum.valueOf(SizePreference.class, string);
        }
    }
}

