/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import com.intellij.util.ui.ImageUtil;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.datavis.r.inlays.components.HSLUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J'\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/intellij/datavis/r/inlays/components/ImageInverter;", "", "foreground", "Ljava/awt/Color;", "background", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/GraphicsConfiguration;)V", "blackHsl", "", "hsl", "rgb", "whiteHsl", "createImageWithInvertedPalette", "Ljava/awt/image/BufferedImage;", "image", "getBrightness", "", "argb", "", "hasAlpha", "", "getImageSample", "", "hasLightBackground", "colors", "brightnessThreshold", "", "([IZD)Ljava/lang/Boolean;", "invert", "color", "", "content", "invertInPlace", "", "outputImage", "shouldInvert", "Companion", "intellij.notebooks.visualization"})
public final class ImageInverter {
    private final float[] rgb;
    private final float[] hsl;
    private final float[] whiteHsl;
    private final float[] blackHsl;
    private final GraphicsConfiguration graphicsConfiguration;
    private static final int SATURATION = 1;
    private static final int LUMINANCE = 2;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final boolean shouldInvert(@NotNull BufferedImage image, double brightnessThreshold) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int[] colors = this.getImageSample(image);
        int numberOfColorsInComplexImage = 5000;
        int numberOfPixels = colors.length;
        int n = numberOfPixels / 3;
        boolean bl = false;
        int numberOfColorsThreshold = Math.min(n, numberOfColorsInComplexImage);
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int[] $this$map$iv = colors;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var15_15 = $this$mapTo$iv$iv;
        int n2 = ((void)var15_15).length;
        for (int i = 0; i < n2; ++i) {
            void it;
            void item$iv$iv;
            void var19_19 = item$iv$iv = var15_15[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Float f = Float.valueOf(this.getBrightness((int)it, hasAlpha));
            collection.add(f);
        }
        float averageBrightness = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)) / (float)numberOfPixels;
        Set numberOfColors = ArraysKt.toSet((int[])colors);
        return (double)averageBrightness > brightnessThreshold && numberOfColors.size() < numberOfColorsThreshold || Intrinsics.areEqual((Object)this.hasLightBackground(colors, hasAlpha, brightnessThreshold), (Object)true);
    }

    public static /* synthetic */ boolean shouldInvert$default(ImageInverter imageInverter, BufferedImage bufferedImage, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return imageInverter.shouldInvert(bufferedImage, d);
    }

    private final int[] getImageSample(BufferedImage image) {
        if (image.getHeight() < 10 || image.getWidth() < 10) {
            int[] colors = new int[image.getHeight() * image.getWidth()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), colors, 0, image.getWidth());
            return colors;
        }
        int n = image.getHeight() / 10;
        int n2 = image.getWidth() / 10;
        int n3 = 0;
        n = Math.max(n, n2);
        n2 = image.getHeight();
        n3 = image.getWidth();
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        int defaultSpotSize = Math.min(n, n2);
        n2 = image.getHeight();
        n3 = 0;
        int spotHeight = Math.min(n2, defaultSpotSize);
        n3 = image.getWidth();
        bl = false;
        int spotWidth = Math.min(n3, defaultSpotSize);
        int spotSize = spotHeight * spotWidth;
        int[] colors = new int[spotSize * 5];
        image.getRGB(0, 0, spotWidth, spotHeight, colors, 0, spotWidth);
        image.getRGB(image.getWidth() - spotWidth, 0, spotWidth, spotHeight, colors, spotSize, spotWidth);
        image.getRGB(0, image.getHeight() - spotHeight, spotWidth, spotHeight, colors, 2 * spotSize, spotWidth);
        image.getRGB(image.getWidth() - spotWidth, image.getHeight() - spotHeight, spotWidth, spotHeight, colors, 3 * spotSize, spotWidth);
        int centralSpotX = image.getWidth() / spotWidth / 2 * spotWidth;
        int centralSpotY = image.getHeight() / spotHeight / 2 * spotHeight;
        image.getRGB(centralSpotX, centralSpotY, spotWidth, spotHeight, colors, 4 * spotSize, spotWidth);
        return colors;
    }

    private final float getBrightness(int argb, boolean hasAlpha) {
        Color color = new Color(argb, hasAlpha);
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return hsb[2];
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean hasLightBackground(int[] colors, boolean hasAlpha, double brightnessThreshold) {
        Object v1;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = colors;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object t = $this$groupByTo$iv$iv;
        int n = ((void)t).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            void element$iv$iv;
            void it = element$iv$iv = t[i];
            boolean bl = false;
            Integer key$iv$iv = (int)it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add((int)element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$groupBy = false;
        object = $this$groupBy$iv.entrySet();
        boolean bl = false;
        Iterator iterator = object.iterator();
        if (!iterator.hasNext()) {
            v1 = null;
        } else {
            t = iterator.next();
            if (!iterator.hasNext()) {
                v1 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                int n2 = ((List)it.getValue()).size();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-ImageInverter$hasLightBackground$dominantColorPair$2 = false;
                    int n3 = ((List)it2.getValue()).size();
                    if (n2 >= n3) continue;
                    t = t2;
                    n2 = n3;
                } while (iterator.hasNext());
                v1 = t;
            }
        }
        Map.Entry entry = v1;
        if (entry == null) {
            return null;
        }
        Map.Entry dominantColorPair = entry;
        int dominantColor = ((Number)dominantColorPair.getKey()).intValue();
        List dominantPixels = (List)dominantColorPair.getValue();
        return (double)dominantPixels.size() / (double)colors.length > 0.5 && (double)this.getBrightness(dominantColor, hasAlpha) > brightnessThreshold;
    }

    @NotNull
    public final Color invert(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float alpha = this.invert(color.getRGB());
        int argb = HSLUtilKt.convertHSLtoRGB(this.hsl, alpha);
        return new Color(argb, true);
    }

    @NotNull
    public final BufferedImage invert(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int width = ImageUtil.getUserWidth((Image)image);
        int height = ImageUtil.getUserHeight((Image)image);
        BufferedImage bufferedImage = ImageUtil.createImage((int)width, (int)height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(wi\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage bufferedImage2 = bufferedImage;
        boolean bl = false;
        boolean bl2 = false;
        BufferedImage outputImage = bufferedImage2;
        boolean bl3 = false;
        this.invertInPlace(image, outputImage);
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] invert(@NotNull byte[] content) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(content));
        if (bufferedImage == null) {
            return content;
        }
        BufferedImage image = bufferedImage;
        BufferedImage outputImage = this.createImageWithInvertedPalette(image);
        this.invertInPlace(image, outputImage);
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            ImageIO.write((RenderedImage)outputImage, "png", outputStream);
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteArrayOutputStream().\u2026tream.toByteArray()\n    }");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void invertInPlace(BufferedImage image, BufferedImage outputImage) {
        int[] rgbArray = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        Intrinsics.checkNotNullExpressionValue((Object)rgbArray, (String)"rgbArray");
        int[] nArray = rgbArray;
        boolean bl = false;
        if (nArray.length == 0) {
            return;
        }
        int prevArgb = rgbArray[0];
        int prevConverted = HSLUtilKt.convertHSLtoRGB(this.hsl, this.invert(prevArgb));
        int n = 0;
        int n2 = rgbArray.length;
        while (n < n2) {
            void i;
            int argb = rgbArray[i];
            if (argb != prevArgb) {
                prevArgb = argb;
                prevConverted = HSLUtilKt.convertHSLtoRGB(this.hsl, this.invert(argb));
            }
            rgbArray[i] = prevConverted;
            ++i;
        }
        outputImage.setRGB(0, 0, image.getWidth(), image.getHeight(), rgbArray, 0, image.getWidth());
    }

    /*
     * WARNING - void declaration
     */
    private final BufferedImage createImageWithInvertedPalette(BufferedImage image) {
        ColorModel model = image.getColorModel();
        if (!(model instanceof IndexColorModel)) {
            return image;
        }
        int[] palette = new int[((IndexColorModel)model).getMapSize()];
        ((IndexColorModel)model).getRGBs(palette);
        int[] nArray = palette;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index;
            int argb = nArray[n2];
            float alpha = this.invert(argb);
            palette[index] = HSLUtilKt.convertHSLtoRGB(this.hsl, alpha);
            ++index;
        }
        BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)this.graphicsConfiguration, (int)image.getWidth(), (int)image.getHeight(), (int)13);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(gr\u2026dImage.TYPE_BYTE_INDEXED)");
        return bufferedImage;
    }

    private final float invert(int argb) {
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.rgb[0] = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.rgb[1] = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.rgb[2] = (float)(argb & 0xFF) / 255.0f;
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.hsl);
        this.hsl[1] = this.hsl[1] * (50.0f + this.whiteHsl[1]) / 1.5f / 100.0f;
        this.hsl[2] = ((float)100 - this.hsl[2]) * (this.whiteHsl[2] - this.blackHsl[2]) / 100.0f + this.blackHsl[2];
        return alpha;
    }

    public ImageInverter(@NotNull Color foreground, @NotNull Color background, @Nullable GraphicsConfiguration graphicsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.graphicsConfiguration = graphicsConfiguration;
        this.rgb = new float[3];
        this.hsl = new float[3];
        this.whiteHsl = new float[3];
        this.blackHsl = new float[3];
        foreground.getRGBColorComponents(this.rgb);
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.whiteHsl);
        background.getRGBColorComponents(this.rgb);
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.blackHsl);
    }

    public /* synthetic */ ImageInverter(Color color, Color color2, GraphicsConfiguration graphicsConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            graphicsConfiguration = null;
        }
        this(color, color2, graphicsConfiguration);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/datavis/r/inlays/components/ImageInverter$Companion;", "", "()V", "B", "", "G", "LUMINANCE", "R", "SATURATION", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

