/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.editor.CaretBasedCellSelectionModelKt;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLines;
import org.jetbrains.plugins.notebooks.editor.NotebookCellSelectionModel;
import org.jetbrains.plugins.notebooks.editor.NotebookVisualizationUiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR \u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/CaretBasedCellSelectionModel;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellSelectionModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "primarySelectedCell", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "getPrimarySelectedCell", "()Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "primarySelectedRegion", "", "getPrimarySelectedRegion", "()Ljava/util/List;", "selectedCells", "getSelectedCells", "selectedRegions", "getSelectedRegions", "isSelectedCell", "", "cell", "removeSecondarySelections", "", "removeSelection", "selectCell", "makePrimary", "intellij.notebooks.visualization"})
public final class CaretBasedCellSelectionModel
implements NotebookCellSelectionModel {
    private final Editor editor;

    @Override
    @NotNull
    public NotebookCellLines.Interval getPrimarySelectedCell() {
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.primaryCaret");
        return NotebookVisualizationUiUtilKt.getCell(this.editor, caret.getLogicalPosition().line);
    }

    @Override
    @NotNull
    public List<NotebookCellLines.Interval> getPrimarySelectedRegion() {
        Object v0;
        block1: {
            NotebookCellLines.Interval primary = this.getPrimarySelectedCell();
            Iterable iterable = this.getSelectedRegions();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                List it = (List)t;
                boolean bl3 = false;
                if (!it.contains(primary)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @Override
    @NotNull
    public List<List<NotebookCellLines.Interval>> getSelectedRegions() {
        return NotebookVisualizationUiUtilKt.groupNeighborCells(this.getSelectedCells());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<NotebookCellLines.Interval> getSelectedCells() {
        void $this$flatMapTo$iv$iv;
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(this.editor);
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        List list = caretModel.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.caretModel.allCarets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Caret caret = (Caret)element$iv$iv;
            boolean bl = false;
            Document document = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Caret caret2 = caret;
            Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"caret");
            Sequence<NotebookCellLines.Interval> list$iv$iv = NotebookVisualizationUiUtilKt.getCells(notebookCellLines, CaretBasedCellSelectionModelKt.access$getSelectionLines(document, caret2));
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @Override
    public boolean isSelectedCell(@NotNull NotebookCellLines.Interval cell) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            List list = caretModel.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.caretModel.allCarets");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Caret caret = (Caret)element$iv;
                    boolean bl2 = false;
                    Document document = this.editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    Caret caret2 = caret;
                    Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"caret");
                    if (!NotebookVisualizationUiUtilKt.hasIntersectionWith(CaretBasedCellSelectionModelKt.access$getSelectionLines(document, caret2), cell.getLines())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void selectCell(@NotNull NotebookCellLines.Interval cell, boolean makePrimary) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor.getCaretModel().addCaret(CaretBasedCellSelectionModelKt.access$getStartLogicalPosition$p(cell), makePrimary);
    }

    @Override
    public void removeSecondarySelections() {
        this.editor.getCaretModel().removeSecondaryCarets();
    }

    @Override
    public void removeSelection(@NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        for (Caret caret : caretModel.getAllCarets()) {
            IntRange intRange = cell.getLines();
            Caret caret2 = caret;
            Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"caret");
            if (!intRange.contains(caret2.getLogicalPosition().line)) continue;
            this.editor.getCaretModel().removeCaret(caret);
        }
    }

    public CaretBasedCellSelectionModel(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    public void selectSingleCell(@NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        NotebookCellSelectionModel.DefaultImpls.selectSingleCell(this, cell);
    }
}

