/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor.outputs;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.editor.outputs.NotebookOutputDefaultScrollPane;
import org.jetbrains.plugins.notebooks.editor.outputs.NotebookOutputScrollPanesKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J#\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001fH\u0014J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane;", "Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputDefaultScrollPane;", "view", "Ljava/awt/Component;", "validateRoot", "", "(Ljava/awt/Component;Z)V", "consequentialDownRotationEvents", "", "consequentialScrollsSensitivity", "consequentialUpRotationEvents", "containerAdapter", "Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane$MyContainerAdapter;", "isScrollCaptured", "latestMouseWheelEventTime", "", "mouseAdapter", "Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler;", "mouseEnteredTime", "reachedTopOrBottomTime", "threshold", "delegateToParentScrollPane", "", "e", "Ljava/awt/event/MouseEvent;", "findParentOfType", "T", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "handleScrollEventTopBottomAware", "Ljava/awt/event/MouseWheelEvent;", "hasReachedBottom", "hasReachedTop", "isDownRotation", "isUpRotation", "processMouseWheelEvent", "rememberRotationDirection", "MyContainerAdapter", "MyMouseHandler", "intellij.notebooks.visualization"})
public class NotebookOutputNonStickyScrollPane
extends NotebookOutputDefaultScrollPane {
    private long latestMouseWheelEventTime;
    private long mouseEnteredTime;
    private long reachedTopOrBottomTime;
    private int consequentialUpRotationEvents;
    private int consequentialDownRotationEvents;
    private final int consequentialScrollsSensitivity;
    private final long threshold;
    private boolean isScrollCaptured;
    private final MyMouseHandler mouseAdapter;
    private final MyContainerAdapter containerAdapter;

    protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.rememberRotationDirection(e);
        long eventTime = e.getWhen();
        if (this.isScrollCaptured) {
            this.handleScrollEventTopBottomAware(e);
        } else if (eventTime - this.mouseEnteredTime < this.threshold || eventTime - this.latestMouseWheelEventTime < this.threshold) {
            this.latestMouseWheelEventTime = eventTime;
            this.delegateToParentScrollPane(e);
        } else {
            this.isScrollCaptured = true;
            this.handleScrollEventTopBottomAware(e);
        }
    }

    private final void handleScrollEventTopBottomAware(MouseWheelEvent e) {
        if (this.hasReachedTop() || this.hasReachedBottom()) {
            if (this.reachedTopOrBottomTime == 0L) {
                this.reachedTopOrBottomTime = e.getWhen();
            } else {
                long delta = e.getWhen() - this.reachedTopOrBottomTime;
                if (delta > this.threshold / (long)10) {
                    super.processMouseWheelEvent(e);
                } else {
                    this.reachedTopOrBottomTime = e.getWhen();
                }
            }
        } else {
            this.reachedTopOrBottomTime = 0L;
            super.processMouseWheelEvent(e);
        }
    }

    private final boolean hasReachedTop() {
        if (this.consequentialDownRotationEvents > this.consequentialScrollsSensitivity) {
            return false;
        }
        if (this.verticalScrollBar == null) {
            return false;
        }
        JScrollBar jScrollBar = this.verticalScrollBar;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"verticalScrollBar");
        int n = jScrollBar.getValue();
        JScrollBar jScrollBar2 = this.verticalScrollBar;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar2, (String)"verticalScrollBar");
        return n == jScrollBar2.getMinimum();
    }

    private final boolean hasReachedBottom() {
        if (this.consequentialUpRotationEvents > this.consequentialScrollsSensitivity) {
            return false;
        }
        if (this.verticalScrollBar == null) {
            return false;
        }
        JScrollBar jScrollBar = this.verticalScrollBar;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"verticalScrollBar");
        int n = jScrollBar.getValue();
        JScrollBar jScrollBar2 = this.verticalScrollBar;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar2, (String)"verticalScrollBar");
        int n2 = jScrollBar2.getMaximum();
        JScrollBar jScrollBar3 = this.verticalScrollBar;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar3, (String)"verticalScrollBar");
        BoundedRangeModel boundedRangeModel = jScrollBar3.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"verticalScrollBar.model");
        return n == n2 - boundedRangeModel.getExtent();
    }

    private final void rememberRotationDirection(MouseWheelEvent e) {
        if (this.isUpRotation(e)) {
            this.consequentialDownRotationEvents = 0;
            int n = this.consequentialUpRotationEvents;
            this.consequentialUpRotationEvents = n + 1;
        } else if (this.isDownRotation(e)) {
            this.consequentialUpRotationEvents = 0;
            int n = this.consequentialDownRotationEvents;
            this.consequentialDownRotationEvents = n + 1;
        }
    }

    private final boolean isUpRotation(MouseWheelEvent e) {
        return e.getWheelRotation() < 0;
    }

    private final boolean isDownRotation(MouseWheelEvent e) {
        return e.getWheelRotation() > 0;
    }

    private final void delegateToParentScrollPane(MouseEvent e) {
        JScrollPane parentScrollPane = this.findParentOfType(JScrollPane.class);
        if (parentScrollPane != null) {
            e.setSource(parentScrollPane);
            parentScrollPane.dispatchEvent(e);
        }
    }

    private final <T> T findParentOfType(Class<T> type) {
        if (this.getParent() == null) {
            return null;
        }
        return (T)ComponentUtil.getParentOfType(type, (Component)this.getParent());
    }

    public NotebookOutputNonStickyScrollPane(@NotNull Component view, boolean validateRoot) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view, validateRoot);
        this.consequentialScrollsSensitivity = 2;
        this.threshold = Registry.get((String)"python.ds.jupyter.scrolling.innerScrollCooldownTime").asInteger();
        this.mouseAdapter = new MyMouseHandler();
        this.containerAdapter = new MyContainerAdapter();
        NotebookOutputScrollPanesKt.access$recursivelyAddMouseListenerToComponent((JComponent)((Object)this), (MouseListener)((Object)this.mouseAdapter));
        NotebookOutputScrollPanesKt.access$recursivelyAddMouseMotionListenerToComponent((JComponent)((Object)this), (MouseMotionListener)((Object)this.mouseAdapter));
        NotebookOutputScrollPanesKt.access$recursivelyAddContainerListenerToComponent((JComponent)((Object)this), this.containerAdapter);
    }

    public /* synthetic */ NotebookOutputNonStickyScrollPane(Component component, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(component, bl);
    }

    public static final /* synthetic */ long access$getLatestMouseWheelEventTime$p(NotebookOutputNonStickyScrollPane $this) {
        return $this.latestMouseWheelEventTime;
    }

    public static final /* synthetic */ boolean access$isScrollCaptured$p(NotebookOutputNonStickyScrollPane $this) {
        return $this.isScrollCaptured;
    }

    public static final /* synthetic */ void access$setViewport$p(NotebookOutputNonStickyScrollPane $this, JViewport jViewport) {
        $this.viewport = jViewport;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler;", "Lcom/intellij/util/ui/MouseEventHandler;", "(Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane;)V", "contentFitsViewport", "", "handle", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "intellij.notebooks.visualization"})
    public final class MyMouseHandler
    extends MouseEventHandler {
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (NotebookOutputNonStickyScrollPane.this.mouseEnteredTime == 0L) {
                NotebookOutputNonStickyScrollPane.this.mouseEnteredTime = e.getWhen();
                NotebookOutputNonStickyScrollPane.this.latestMouseWheelEventTime = 0L;
            }
            super.mouseEntered(e);
        }

        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!NotebookOutputNonStickyScrollPane.this.isShowing()) {
                NotebookOutputNonStickyScrollPane.this.delegateToParentScrollPane(e);
            } else {
                Point eventPointOnScreen = new Point(e.getXOnScreen(), e.getYOnScreen());
                int n = NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().x;
                IntRange xRange = new IntRange(n, NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().x + NotebookOutputNonStickyScrollPane.this.getWidth());
                int n2 = NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().y;
                IntRange yRange = new IntRange(n2, NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().y + NotebookOutputNonStickyScrollPane.this.getHeight());
                if (!xRange.contains(eventPointOnScreen.x) || !yRange.contains(eventPointOnScreen.y)) {
                    NotebookOutputNonStickyScrollPane.this.mouseEnteredTime = 0L;
                    NotebookOutputNonStickyScrollPane.this.latestMouseWheelEventTime = 0L;
                    NotebookOutputNonStickyScrollPane.this.isScrollCaptured = false;
                }
            }
            super.mouseExited(e);
        }

        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            NotebookOutputNonStickyScrollPane.this.isScrollCaptured = true;
            super.mousePressed(e);
        }

        public void mouseMoved(@Nullable MouseEvent e) {
            if (!this.contentFitsViewport()) {
                NotebookOutputNonStickyScrollPane.this.isScrollCaptured = true;
            }
            super.mouseMoved(e);
        }

        protected void handle(@NotNull MouseEvent e) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                Object object2 = !((InputEvent)it).isConsumed() ? object : null;
                if (object2 == null || (object2 = ((EventObject)object2).getSource()) == null) break block2;
                Object $this$castSafelyTo$iv = object2;
                boolean $i$f$castSafelyTo = false;
                Object object3 = $this$castSafelyTo$iv;
                if (!(object3 instanceof Component)) {
                    object3 = null;
                }
                if ((object2 = (Component)object3) != null && (object2 = ((Component)object2).getParent()) != null) {
                    object = object2;
                    bl = false;
                    bl2 = false;
                    it = object;
                    boolean bl4 = false;
                    ((Component)it).dispatchEvent(new MouseEvent((Component)it, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean contentFitsViewport() {
            JViewport jViewport = NotebookOutputNonStickyScrollPane.this.viewport;
            Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
            Rectangle viewRect = jViewport.getViewRect();
            if (viewRect.x != 0) return false;
            if (viewRect.y != 0) return false;
            int n = viewRect.height;
            JViewport jViewport2 = NotebookOutputNonStickyScrollPane.this.viewport;
            Intrinsics.checkNotNullExpressionValue((Object)jViewport2, (String)"viewport");
            Component component = jViewport2.getView();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"viewport.view");
            if (n != component.getHeight()) return false;
            int n2 = viewRect.width;
            JViewport jViewport3 = NotebookOutputNonStickyScrollPane.this.viewport;
            Intrinsics.checkNotNullExpressionValue((Object)jViewport3, (String)"viewport");
            Component component2 = jViewport3.getView();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"viewport.view");
            if (n2 != component2.getWidth()) return false;
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane$MyContainerAdapter;", "Ljava/awt/event/ContainerAdapter;", "(Lorg/jetbrains/plugins/notebooks/editor/outputs/NotebookOutputNonStickyScrollPane;)V", "componentAdded", "", "e", "Ljava/awt/event/ContainerEvent;", "componentRemoved", "intellij.notebooks.visualization"})
    public final class MyContainerAdapter
    extends ContainerAdapter {
        @Override
        public void componentAdded(@NotNull ContainerEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                if (!(component instanceof JComponent)) {
                    component = null;
                }
                JComponent jComponent = (JComponent)component;
                if (jComponent == null) break block1;
                JComponent jComponent2 = jComponent;
                boolean bl = false;
                boolean bl2 = false;
                JComponent it = jComponent2;
                boolean bl3 = false;
                NotebookOutputScrollPanesKt.access$recursivelyAddMouseListenerToComponent(it, (MouseListener)((Object)NotebookOutputNonStickyScrollPane.this.mouseAdapter));
                NotebookOutputScrollPanesKt.access$recursivelyAddMouseMotionListenerToComponent(it, (MouseMotionListener)((Object)NotebookOutputNonStickyScrollPane.this.mouseAdapter));
            }
        }

        @Override
        public void componentRemoved(@NotNull ContainerEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                if (!(component instanceof JComponent)) {
                    component = null;
                }
                JComponent jComponent = (JComponent)component;
                if (jComponent == null) break block1;
                JComponent jComponent2 = jComponent;
                boolean bl = false;
                boolean bl2 = false;
                JComponent it = jComponent2;
                boolean bl3 = false;
                NotebookOutputScrollPanesKt.access$recursivelyRemoveListeners(it);
            }
        }
    }
}

