/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import com.intellij.rt.coverage.util.TestTrackingIOUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
implements CoverageData,
Serializable {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/ProjectData";
    private static final MethodCaller TOUCH_LINE_METHOD = new MethodCaller("touchLine", new Class[]{Integer.TYPE});
    private static final MethodCaller GET_LINE_MASK_METHOD = new MethodCaller("getLineMask", new Class[0]);
    private static final MethodCaller GET_HITS_MASK_METHOD = new MethodCaller("getHitsMask", new Class[0]);
    private static final MethodCaller GET_TRACE_MASK_METHOD = new MethodCaller("getTraceMask", new Class[0]);
    private static final MethodCaller TOUCH_SWITCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    private static final MethodCaller TOUCH_JUMP_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
    private static final MethodCaller TOUCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE});
    private static final MethodCaller GET_CLASS_DATA_METHOD = new MethodCaller("getClassData", new Class[]{String.class});
    private static final MethodCaller REGISTER_CLASS_FOR_TRACE_METHOD = new MethodCaller("registerClassForTrace", new Class[]{Object.class});
    private static final MethodCaller TRACE_LINE_METHOD = new MethodCaller("traceLine", new Class[]{Object.class, Integer.TYPE});
    private static boolean ourStopped = false;
    public static ProjectData ourProjectData;
    private File myDataFile;
    private boolean myTraceLines;
    private boolean mySampling;
    private final AtomicReference<Map<Object, boolean[]>> myTrace = new AtomicReference();
    private File myTracesDir;
    private List<Pattern> myIncludePatterns;
    private List<Pattern> myExcludePatterns;
    private final ClassesMap myClasses = new ClassesMap();
    private Map<String, FileMapData[]> myLinesMap;
    private static Object ourProjectDataObject;
    private TestTrackingCallback myTestTrackingCallback;

    public ClassData getClassData(String name) {
        return this.myClasses.get(name);
    }

    public ClassData getOrCreateClassData(String name) {
        ClassData classData = this.myClasses.get(name);
        if (classData == null) {
            classData = new ClassData(name);
            this.myClasses.put(name, classData);
        }
        return classData;
    }

    public static ProjectData getProjectData() {
        return ourProjectData;
    }

    public void stop() {
        ourStopped = true;
    }

    public boolean isStopped() {
        return ourStopped;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public boolean isTestTracking() {
        return this.myTraceLines;
    }

    public int getClassesNumber() {
        return this.myClasses.size();
    }

    public Map<String, FileMapData[]> getLinesMap() {
        return this.myLinesMap;
    }

    public static ProjectData createProjectData(File dataFile, ProjectData initialData, boolean traceLines, boolean isSampling, List<Pattern> includePatterns, List<Pattern> excludePatterns, TestTrackingCallback testTrackingCallback) throws IOException {
        ProjectData projectData = ourProjectData = initialData == null ? new ProjectData() : initialData;
        if (dataFile != null && !dataFile.exists()) {
            File parentDir = dataFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            dataFile.createNewFile();
        }
        ProjectData.ourProjectData.mySampling = isSampling;
        ProjectData.ourProjectData.myTraceLines = traceLines;
        ProjectData.ourProjectData.myDataFile = dataFile;
        ProjectData.ourProjectData.myIncludePatterns = includePatterns;
        ProjectData.ourProjectData.myExcludePatterns = excludePatterns;
        ProjectData.ourProjectData.myTestTrackingCallback = testTrackingCallback;
        return ourProjectData;
    }

    @Override
    public void merge(CoverageData data) {
        ProjectData projectData = (ProjectData)data;
        Iterator<String> iterator = projectData.myClasses.names().iterator();
        while (iterator.hasNext()) {
            String o;
            String key = o = iterator.next();
            ClassData mergedData = projectData.myClasses.get(key);
            ClassData classData = this.myClasses.get(key);
            if (classData == null) {
                classData = new ClassData(mergedData.getName());
                this.myClasses.put(key, classData);
            }
            classData.merge(mergedData);
        }
    }

    public void checkLineMappings() {
        if (this.myLinesMap != null) {
            for (Map.Entry<String, FileMapData[]> entry : this.myLinesMap.entrySet()) {
                String className = entry.getKey();
                ClassData classData = this.getClassData(className);
                FileMapData[] fileData = entry.getValue();
                FileMapData mainData = null;
                for (FileMapData aFileData : fileData) {
                    String mappedClassName = aFileData.getClassName();
                    if (mappedClassName.equals(className)) {
                        mainData = aFileData;
                        continue;
                    }
                    if (this.myExcludePatterns != null && ClassNameUtil.matchesPatterns(mappedClassName, this.myExcludePatterns) || this.myIncludePatterns != null && !this.myIncludePatterns.isEmpty() && !ClassNameUtil.matchesPatterns(mappedClassName, this.myIncludePatterns)) continue;
                    ClassData classInfo = this.getOrCreateClassData(mappedClassName);
                    if (classInfo.getSource() == null || classInfo.getSource().length() == 0) {
                        classInfo.setSource(aFileData.getFileName());
                    }
                    classInfo.checkLineMappings(aFileData.getLines(), classData);
                }
                if (mainData == null) continue;
                classData.checkLineMappings(mainData.getLines(), classData);
            }
        }
    }

    public void applyLinesMask() {
        if (!this.mySampling) {
            return;
        }
        for (ClassData data : this.myClasses.myClasses.values()) {
            data.applyLinesMask();
        }
    }

    public void applyBranchData() {
        if (this.mySampling) {
            return;
        }
        for (ClassData data : this.myClasses.myClasses.values()) {
            data.applyBranches();
        }
    }

    public void addLineMaps(String className, FileMapData[] fileDatas) {
        if (this.myLinesMap == null) {
            this.myLinesMap = new HashMap<String, FileMapData[]>();
        }
        this.myLinesMap.put(className, fileDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEnded(String name) {
        Iterator<Map.Entry<Object, boolean[]>> iterator;
        Map<Object, boolean[]> trace = this.myTrace.get();
        if (trace == null) {
            return;
        }
        File tracesDir = this.getTracesDir();
        try {
            try {
                TestTrackingIOUtil.saveTestResults(tracesDir, name, trace);
            }
            catch (IOException e) {
                ErrorReporter.reportError("Error writing traces for test '" + name + "' to directory " + tracesDir.getPath(), e);
                Object var6_5 = null;
                Iterator<Map.Entry<Object, boolean[]>> iterator2 = trace.entrySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        this.myTrace.compareAndSet(trace, null);
                        return;
                    }
                    Map.Entry<Object, boolean[]> entry = iterator2.next();
                    ClassData classData = (ClassData)entry.getKey();
                    boolean[] touched = entry.getValue();
                    Object[] lines = classData.getLines();
                    int lineCount = Math.min(lines.length, touched.length);
                    for (int i = 1; i < lineCount; ++i) {
                        LineData lineData = (LineData)lines[i];
                        if (lineData == null || !touched[i]) continue;
                        lineData.setTestName(name);
                    }
                    this.myTestTrackingCallback.clearTrace(classData);
                }
            }
            Object var6_4 = null;
            iterator = trace.entrySet().iterator();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Iterator<Map.Entry<Object, boolean[]>> iterator3 = trace.entrySet().iterator();
            while (true) {
                if (!iterator3.hasNext()) {
                    this.myTrace.compareAndSet(trace, null);
                    throw throwable;
                }
                Map.Entry<Object, boolean[]> entry = iterator3.next();
                ClassData classData = (ClassData)entry.getKey();
                boolean[] touched = entry.getValue();
                Object[] lines = classData.getLines();
                int lineCount = Math.min(lines.length, touched.length);
                for (int i = 1; i < lineCount; ++i) {
                    LineData lineData = (LineData)lines[i];
                    if (lineData == null || !touched[i]) continue;
                    lineData.setTestName(name);
                }
                this.myTestTrackingCallback.clearTrace(classData);
            }
        }
        while (iterator.hasNext()) {
            Map.Entry<Object, boolean[]> entry = iterator.next();
            ClassData classData = (ClassData)entry.getKey();
            boolean[] touched = entry.getValue();
            Object[] lines = classData.getLines();
            int lineCount = Math.min(lines.length, touched.length);
            for (int i = 1; i < lineCount; ++i) {
                LineData lineData = (LineData)lines[i];
                if (lineData == null || !touched[i]) continue;
                lineData.setTestName(name);
            }
            this.myTestTrackingCallback.clearTrace(classData);
        }
        this.myTrace.compareAndSet(trace, null);
    }

    public void testStarted(String name) {
        if (this.myTraceLines) {
            this.myTrace.compareAndSet(null, new ConcurrentHashMap());
        }
    }

    private File getTracesDir() {
        if (this.myTracesDir == null) {
            this.myTracesDir = ProjectData.createTracesDir(this.myDataFile);
        }
        return this.myTracesDir;
    }

    public static File createTracesDir(File dataFile) {
        String fileName = dataFile.getName();
        int i = fileName.lastIndexOf(46);
        String dirName = i != -1 ? fileName.substring(0, i) : fileName;
        File result = new File(dataFile.getParent(), dirName);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public Map<String, ClassData> getClasses() {
        return this.myClasses.asMap();
    }

    public static void touchLine(Object classData, int line) {
        if (ourProjectData != null) {
            ((ClassData)classData).touchLine(line);
            return;
        }
        ProjectData.touch(TOUCH_LINE_METHOD, classData, new Object[]{line});
    }

    public static void touchSwitch(Object classData, int line, int switchNumber, int key) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, switchNumber, key);
            return;
        }
        ProjectData.touch(TOUCH_SWITCH_METHOD, classData, new Object[]{line, switchNumber, key});
    }

    public static void touchJump(Object classData, int line, int jump, boolean hit) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, jump, hit);
            return;
        }
        ProjectData.touch(TOUCH_JUMP_METHOD, classData, new Object[]{line, jump, hit});
    }

    public static void trace(Object classData, int line) {
        ProjectData.traceLine(classData, line);
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line);
            return;
        }
        ProjectData.touch(TOUCH_METHOD, classData, new Object[]{line});
    }

    public static void traceLine(Object classData, int line) {
        if (ourProjectData != null) {
            boolean[] lines;
            Map<Object, boolean[]> traces = ProjectData.ourProjectData.myTrace.get();
            if (traces != null && (lines = ProjectData.ourProjectData.myTestTrackingCallback.traceLine((ClassData)classData, line)) != null) {
                traces.put(classData, lines);
            }
            return;
        }
        try {
            Object projectData = ProjectData.getProjectDataObject();
            TRACE_LINE_METHOD.invoke(projectData, new Object[]{classData, line});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error tracing class " + classData.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerClassForTrace(Object classData) {
        if (ourProjectData != null) {
            Map<Object, boolean[]> traces = ProjectData.ourProjectData.myTrace.get();
            if (traces != null) {
                Object object = classData;
                synchronized (object) {
                    boolean[] trace = ((ClassData)classData).getTraceMask();
                    if (traces.put(classData, trace) == null) {
                        Arrays.fill(trace, false);
                    }
                }
                return true;
            }
            return false;
        }
        try {
            Object projectData = ProjectData.getProjectDataObject();
            return (Boolean)REGISTER_CLASS_FOR_TRACE_METHOD.invoke(projectData, new Object[]{classData});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error tracing class " + classData.toString(), e);
            return false;
        }
    }

    private static Object touch(MethodCaller methodCaller, Object classData, Object[] paramValues) {
        try {
            return methodCaller.invoke(classData, paramValues);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in project data collection: " + methodCaller.myMethodName, e);
            return null;
        }
    }

    public static int[] getLineMask(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className).getLineMask();
        }
        try {
            Object classData = ProjectData.getClassDataObject(className);
            return (int[])ProjectData.touch(GET_LINE_MASK_METHOD, classData, new Object[0]);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return null;
        }
    }

    public static int[] getHitsMask(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className).getHitsMask();
        }
        try {
            Object classData = ProjectData.getClassDataObject(className);
            return (int[])ProjectData.touch(GET_HITS_MASK_METHOD, classData, new Object[0]);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data access: " + className, e);
            return null;
        }
    }

    public static boolean[] getTraceMask(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className).getTraceMask();
        }
        try {
            Object classData = ProjectData.getClassDataObject(className);
            return (boolean[])ProjectData.touch(GET_TRACE_MASK_METHOD, classData, new Object[0]);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data access: " + className, e);
            return null;
        }
    }

    public static Object loadClassData(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className);
        }
        try {
            return ProjectData.getClassDataObject(className);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return null;
        }
    }

    private static Object getProjectDataObject() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        if (ourProjectDataObject == null) {
            Class<?> projectDataClass = Class.forName(ProjectData.class.getName(), false, null);
            ourProjectDataObject = projectDataClass.getDeclaredField("ourProjectData").get(null);
        }
        return ourProjectDataObject;
    }

    private static Object getClassDataObject(String className) throws Exception {
        Object projectDataObject = ProjectData.getProjectDataObject();
        return GET_CLASS_DATA_METHOD.invoke(projectDataObject, new Object[]{className});
    }

    private static class IdentityClassData {
        private final String myClassName;
        private final ClassData myClassData;

        private IdentityClassData(String className, ClassData classData) {
            this.myClassName = className;
            this.myClassData = classData;
        }

        public ClassData getClassData(String name) {
            if (name == this.myClassName) {
                return this.myClassData;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassesMap {
        private static final int POOL_SIZE = 1024;
        private static final int MASK = 1023;
        private static final int DEFAULT_CAPACITY = 1000;
        private final IdentityClassData[] myIdentityArray = new IdentityClassData[1024];
        private final Map<String, ClassData> myClasses = ClassesMap.createClassesMap();

        private ClassesMap() {
        }

        public int size() {
            return this.myClasses.size();
        }

        public ClassData get(String name) {
            ClassData data;
            int idx = name.hashCode() & 0x3FF;
            IdentityClassData lastClassData = this.myIdentityArray[idx];
            if (lastClassData != null && (data = lastClassData.getClassData(name)) != null) {
                return data;
            }
            data = this.myClasses.get(name);
            this.myIdentityArray[idx] = new IdentityClassData(name, data);
            return data;
        }

        public void put(String name, ClassData data) {
            this.myClasses.put(name, data);
        }

        public HashMap<String, ClassData> asMap() {
            return new HashMap<String, ClassData>(this.myClasses);
        }

        public Collection<String> names() {
            return this.myClasses.keySet();
        }

        private static Map<String, ClassData> createClassesMap() {
            if ("true".equals(System.getProperty("idea.coverage.thread-safe.enabled", "true"))) {
                return new ConcurrentHashMap<String, ClassData>(1000);
            }
            return new HashMap<String, ClassData>(1000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodCaller {
        private Method myMethod;
        private final String myMethodName;
        private final Class[] myParamTypes;

        private MethodCaller(String methodName, Class[] paramTypes) {
            this.myMethodName = methodName;
            this.myParamTypes = paramTypes;
        }

        public Object invoke(Object thisObj, Object[] paramValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (this.myMethod == null) {
                this.myMethod = MethodCaller.findMethod(thisObj.getClass(), this.myMethodName, this.myParamTypes);
            }
            return this.myMethod.invoke(thisObj, paramValues);
        }

        private static Method findMethod(Class<?> clazz, String name, Class[] paramTypes) throws NoSuchMethodException {
            Method m = clazz.getDeclaredMethod(name, paramTypes);
            m.setAccessible(true);
            return m;
        }
    }
}

