/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.runtime;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.space.runtime.ApplicationCoroutineContext;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import runtime.Cancellable;
import runtime.CoroutineExceptionLogger;
import runtime.Dispatcher;
import runtime.TaskCancellable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u001e\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J&\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/space/runtime/SpaceUIDispatcher;", "Lruntime/Dispatcher;", "disposable", "Lcom/intellij/openapi/Disposable;", "application", "Lcom/intellij/openapi/application/Application;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/application/Application;)V", "context", "Lcom/intellij/space/runtime/ApplicationCoroutineContext;", "contextWithLog", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dispatch", "", "fn", "Lkotlin/Function0;", "Lruntime/Cancellable;", "delay", "", "dispatchInterval", "interval", "Companion", "intellij.space"})
public final class SpaceUIDispatcher
implements Dispatcher {
    private final ScheduledExecutorService executor;
    private final ApplicationCoroutineContext context;
    private final CoroutineContext contextWithLog;
    private final Application application;
    private static final KLogger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.contextWithLog;
    }

    public void dispatch(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        Function0<Unit> function0 = fn;
        this.application.invokeLater(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, ModalityState.any());
    }

    @NotNull
    public Cancellable dispatch(int delay, @NotNull Function0<Unit> fn) {
        ScheduledFuture<?> disposable;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        Runnable invoke2 = new Runnable(this, fn){
            final /* synthetic */ SpaceUIDispatcher this$0;
            final /* synthetic */ Function0 $fn;

            public final void run() {
                Application application = SpaceUIDispatcher.access$getApplication$p(this.this$0);
                Object object = this.$fn;
                if (object != null) {
                    Function0 function0 = object;
                    object = new /* invalid duplicate definition of identical inner class */;
                }
                application.invokeLater((Runnable)object, ModalityState.any());
            }
            {
                this.this$0 = spaceUIDispatcher;
                this.$fn = function0;
            }
        };
        ScheduledFuture<?> scheduledFuture = disposable = this.executor.schedule(invoke2, (long)delay, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"disposable");
        return (Cancellable)new TaskCancellable((Future)scheduledFuture);
    }

    @NotNull
    public Cancellable dispatchInterval(int delay, int interval, @NotNull Function0<Unit> fn) {
        ScheduledFuture<?> disposable;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        Runnable invoke2 = new Runnable(this, fn){
            final /* synthetic */ SpaceUIDispatcher this$0;
            final /* synthetic */ Function0 $fn;

            public final void run() {
                Application application = SpaceUIDispatcher.access$getApplication$p(this.this$0);
                Object object = this.$fn;
                if (object != null) {
                    Function0 function0 = object;
                    object = new /* invalid duplicate definition of identical inner class */;
                }
                application.invokeLater((Runnable)object, ModalityState.any());
            }
            {
                this.this$0 = spaceUIDispatcher;
                this.$fn = function0;
            }
        };
        ScheduledFuture<?> scheduledFuture = disposable = this.executor.scheduleWithFixedDelay(invoke2, delay, interval, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"disposable");
        return (Cancellable)new TaskCancellable((Future)scheduledFuture);
    }

    public SpaceUIDispatcher(@NotNull Disposable disposable, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Space Application Auxiliary Scheduler", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026 Auxiliary Scheduler\", 1)");
        this.executor = scheduledExecutorService;
        this.context = new ApplicationCoroutineContext(this.application, this.executor);
        this.contextWithLog = this.context.plus((CoroutineContext)CoroutineExceptionLogger.INSTANCE.create(LOG));
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public final void dispose() {
                block2: {
                    executor.shutdown();
                    try {
                        executor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        KLogger this_$iv = LOG;
                        boolean $i$f$warn = false;
                        if (!this_$iv.isWarnEnabled()) break block2;
                        KLogger kLogger = this_$iv;
                        boolean bl = false;
                        String string = "Executor was not properly terminated";
                        kLogger.warn((Object)string);
                    }
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceUIDispatcher.class));
    }

    public void dispatch(@NotNull Function0<Unit> fn, int priority) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        Dispatcher.DefaultImpls.dispatch((Dispatcher)this, fn, (int)priority);
    }

    public static final /* synthetic */ Application access$getApplication$p(SpaceUIDispatcher $this) {
        return $this.application;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/runtime/SpaceUIDispatcher$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

