/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.diff.SpaceDiffFile;
import com.intellij.space.vcs.diff.SpaceDiffModel;
import com.intellij.space.vcs.diff.SpaceDiffRequestProcessor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/space/vcs/diff/SpaceDiffFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "spaceDiffFile", "Lcom/intellij/space/vcs/diff/SpaceDiffFile;", "diffModel", "Lruntime/reactive/Property;", "Lcom/intellij/space/vcs/diff/SpaceDiffModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/diff/SpaceDiffFile;Lruntime/reactive/Property;)V", "diffProcessor", "Lcom/intellij/space/vcs/diff/SpaceDiffRequestProcessor;", "getDiffProcessor$intellij_space", "()Lcom/intellij/space/vcs/diff/SpaceDiffRequestProcessor;", "editorLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getFile", "getName", "", "getPreferredFocusedComponent", "isValid", "", "intellij.space"})
public final class SpaceDiffFileEditor
extends FileEditorBase {
    @NotNull
    private final SpaceDiffRequestProcessor diffProcessor;
    private final LifetimeSource editorLifetime;
    private final SpaceDiffFile spaceDiffFile;

    @NotNull
    public final SpaceDiffRequestProcessor getDiffProcessor$intellij_space() {
        return this.diffProcessor;
    }

    public void dispose() {
        this.editorLifetime.terminate();
        Disposer.dispose((Disposable)((Disposable)this.diffProcessor));
        super.dispose();
    }

    public boolean isValid() {
        return !Disposer.isDisposed((Disposable)((Disposable)this.diffProcessor));
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.diffProcessor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"diffProcessor.component");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.diffProcessor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = SpaceBundle.message("review.diff.editor.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpaceBundle.message(\"review.diff.editor.name\")");
        return string;
    }

    @NotNull
    public SpaceDiffFile getFile() {
        return this.spaceDiffFile;
    }

    public SpaceDiffFileEditor(@NotNull Project project, @NotNull SpaceDiffFile spaceDiffFile, @NotNull Property<? extends SpaceDiffModel> diffModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)spaceDiffFile), (String)"spaceDiffFile");
        Intrinsics.checkNotNullParameter(diffModel, (String)"diffModel");
        this.spaceDiffFile = spaceDiffFile;
        this.diffProcessor = new SpaceDiffRequestProcessor(project, diffModel);
        this.editorLifetime = new LifetimeSource();
        Disposer.register((Disposable)((Disposable)this.diffProcessor), (Disposable)new Disposable(){

            public final void dispose() {
                this.firePropertyChange("valid", true, false);
            }
        });
        diffModel.forEach((Lifetime)this.editorLifetime, (Function1)new Function1<SpaceDiffModel, Unit>(){

            public final void invoke(@Nullable SpaceDiffModel diffVM) {
                if (diffVM == null) {
                    return;
                }
                this.getDiffProcessor$intellij_space().setChain(diffVM.getChain());
            }
        });
    }
}

