/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.IllegalJsonInputException;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Strings;

@BuiltinFunction(value={"@sh/0"})
public class AtShFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (in.isArray()) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (JsonNode i : in) {
                if (i.isTextual()) {
                    tokens.add(this.escape(i.asText()));
                    continue;
                }
                if (i.isValueNode()) {
                    tokens.add(i.asText());
                    continue;
                }
                throw new IllegalJsonInputException(i.getNodeType() + " cannot be escaped for shell");
            }
            return Collections.singletonList(new TextNode(Strings.join(" ", tokens)));
        }
        if (in.isTextual()) {
            return Collections.singletonList(new TextNode(this.escape(in.asText())));
        }
        if (in.isValueNode()) {
            return Collections.singletonList(new TextNode(in.asText()));
        }
        throw new IllegalJsonInputException(in.getNodeType() + " cannot be escaped for shell");
    }

    public String escape(String text) {
        StringBuilder builder = new StringBuilder("'");
        block3: for (char ch : text.toCharArray()) {
            switch (ch) {
                case '\'': {
                    builder.append("'\\''");
                    continue block3;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        builder.append("'");
        return builder.toString();
    }
}

