/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableAsList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableSet
extends ImmutableSet {
    static final RegularImmutableSet EMPTY = new RegularImmutableSet(new Object[0], 0, null, 0);
    private final transient Object[] elements;
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] objectArray, int n, Object[] objectArray2, int n2) {
        this.elements = objectArray;
        this.table = objectArray2;
        this.mask = n2;
        this.hashCode = n;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        Object[] objectArray = this.table;
        if (object == null || objectArray == null) {
            return false;
        }
        int n = Hashing.smearedHash(object);
        Object object2;
        while ((object2 = objectArray[n &= this.mask]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    public Spliterator spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        System.arraycopy(this.elements, 0, objectArray, n, this.elements.length);
        return n + this.elements.length;
    }

    @Override
    ImmutableList createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList((ImmutableCollection)this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

