/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySetGenerator;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHelloHandler
extends HandshakeMessageHandler<ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientHelloHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public ClientHelloParser getParser(byte[] message, int pointer) {
        return new ClientHelloParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public ClientHelloPreparator getPreparator(ClientHelloMessage message) {
        return new ClientHelloPreparator(this.tlsContext.getChooser(), message);
    }

    public ClientHelloSerializer getSerializer(ClientHelloMessage message) {
        return new ClientHelloSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(ClientHelloMessage message) {
        this.adjustProtocolVersion(message);
        this.adjustSessionID(message);
        this.adjustClientSupportedCipherSuites(message);
        this.adjustClientSupportedCompressions(message);
        if (this.isCookieFieldSet(message)) {
            this.adjustDTLSCookie(message);
        }
        this.adjustExtensions(message, HandshakeMessageType.CLIENT_HELLO);
        this.adjustRandomContext(message);
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13() && this.tlsContext.isExtensionNegotiated(ExtensionType.EARLY_DATA)) {
            try {
                this.adjustEarlyTrafficSecret();
                this.setClientRecordCipherEarly();
            }
            catch (CryptoException ex) {
                throw new AdjustmentException("Could not adjust", ex);
            }
        }
    }

    private boolean isCookieFieldSet(ClientHelloMessage message) {
        return message.getCookie() != null;
    }

    private void adjustClientSupportedCipherSuites(ClientHelloMessage message) {
        List<CipherSuite> suiteList = this.convertCipherSuites((byte[])message.getCipherSuites().getValue());
        this.tlsContext.setClientSupportedCiphersuites(suiteList);
        if (suiteList != null) {
            LOGGER.debug("Set ClientSupportedCiphersuites in Context to " + suiteList.toString());
        } else {
            LOGGER.debug("Set ClientSupportedCiphersuites in Context to " + null);
        }
    }

    private void adjustClientSupportedCompressions(ClientHelloMessage message) {
        List<CompressionMethod> compressionList = this.convertCompressionMethods((byte[])message.getCompressions().getValue());
        this.tlsContext.setClientSupportedCompressions(compressionList);
        LOGGER.debug("Set ClientSupportedCompressions in Context to " + compressionList.toString());
    }

    private void adjustDTLSCookie(ClientHelloMessage message) {
        byte[] dtlsCookie = (byte[])message.getCookie().getValue();
        this.tlsContext.setDtlsCookie(dtlsCookie);
        LOGGER.debug("Set DTLS Cookie in Context to " + ArrayConverter.bytesToHexString((byte[])dtlsCookie));
    }

    private void adjustSessionID(ClientHelloMessage message) {
        byte[] sessionId = (byte[])message.getSessionId().getValue();
        this.tlsContext.setClientSessionId(sessionId);
        LOGGER.debug("Set SessionId in Context to " + ArrayConverter.bytesToHexString((byte[])sessionId, (boolean)false));
    }

    private void adjustProtocolVersion(ClientHelloMessage message) {
        ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])message.getProtocolVersion().getValue());
        if (version != null) {
            this.tlsContext.setHighestClientProtocolVersion(version);
            LOGGER.debug("Set HighestClientProtocolVersion in Context to " + version.name());
        } else {
            LOGGER.warn("Did not Adjust ProtocolVersion since version is undefined " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
        }
    }

    private void adjustRandomContext(ClientHelloMessage message) {
        this.tlsContext.setClientRandom((byte[])message.getRandom().getValue());
        LOGGER.debug("Set ClientRandom in Context to " + ArrayConverter.bytesToHexString((byte[])this.tlsContext.getClientRandom()));
    }

    private List<CompressionMethod> convertCompressionMethods(byte[] bytesToConvert) {
        LinkedList<CompressionMethod> list = new LinkedList<CompressionMethod>();
        for (byte b : bytesToConvert) {
            CompressionMethod method = CompressionMethod.getCompressionMethod(b);
            if (method == null) {
                LOGGER.warn("Could not convert " + b + " into a CompressionMethod");
                continue;
            }
            list.add(method);
        }
        return list;
    }

    private List<CipherSuite> convertCipherSuites(byte[] bytesToConvert) {
        if (bytesToConvert.length % 2 != 0) {
            LOGGER.warn("Cannot convert:" + ArrayConverter.bytesToHexString((byte[])bytesToConvert, (boolean)false) + " to a List<CipherSuite>");
            return null;
        }
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        for (int i = 0; i < bytesToConvert.length; i += 2) {
            byte[] copied = new byte[]{bytesToConvert[i], bytesToConvert[i + 1]};
            CipherSuite suite = CipherSuite.getCipherSuite(copied);
            if (suite == null) {
                LOGGER.warn("Cannot convert:" + ArrayConverter.bytesToHexString((byte[])copied) + " to a CipherSuite");
                continue;
            }
            list.add(suite);
        }
        return list;
    }

    @Override
    public void adjustTlsContextAfterSerialize(ClientHelloMessage message) {
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT && this.tlsContext.isExtensionProposed(ExtensionType.EARLY_DATA)) {
            try {
                this.adjustEarlyTrafficSecret();
                this.setClientRecordCipherEarly();
            }
            catch (CryptoException ex) {
                LOGGER.warn("Encountered an exception in adjust after Serialize", (Throwable)ex);
            }
        }
    }

    private void adjustEarlyTrafficSecret() throws CryptoException {
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getEarlyDataCipherSuite());
        DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, this.tlsContext.getChooser().getEarlyDataCipherSuite());
        byte[] earlySecret = HKDFunction.extract(hkdfAlgortihm, new byte[0], this.tlsContext.getChooser().getEarlyDataPsk());
        this.tlsContext.setEarlySecret(earlySecret);
        byte[] earlyTrafficSecret = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), this.tlsContext.getChooser().getEarlySecret(), "c e traffic", this.tlsContext.getDigest().getRawBytes());
        this.tlsContext.setClientEarlyTrafficSecret(earlyTrafficSecret);
        LOGGER.debug("EarlyTrafficSecret: " + ArrayConverter.bytesToHexString((byte[])earlyTrafficSecret));
    }

    private void setClientRecordCipherEarly() throws CryptoException {
        try {
            this.tlsContext.setActiveClientKeySetType(Tls13KeySetType.EARLY_TRAFFIC_SECRETS);
            LOGGER.debug("Setting cipher for client to use early secrets");
            KeySet clientKeySet = KeySetGenerator.generateKeySet(this.tlsContext, ProtocolVersion.TLS13, this.tlsContext.getActiveClientKeySetType());
            RecordCipher recordCipherClient = RecordCipherFactory.getRecordCipher(this.tlsContext, clientKeySet, this.tlsContext.getChooser().getEarlyDataCipherSuite());
            this.tlsContext.getRecordLayer().setRecordCipher(recordCipherClient);
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
                this.tlsContext.setReadSequenceNumber(0L);
                this.tlsContext.getRecordLayer().updateDecryptionCipher();
            } else {
                this.tlsContext.setWriteSequenceNumber(0L);
                this.tlsContext.getRecordLayer().updateEncryptionCipher();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("Unable to generate KeySet - unknown algorithm");
            throw new WorkflowExecutionException(ex.toString());
        }
    }
}

