/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.traccar.BasePipelineFactory;
import org.traccar.Context;
import org.traccar.EventLoopGroupFactory;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerConnector;
import org.traccar.config.Keys;

public abstract class TrackerServer
implements TrackerConnector {
    private final boolean datagram;
    private final boolean secure;
    private final AbstractBootstrap bootstrap;
    private final int port;
    private final String address;
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    @Override
    public boolean isDatagram() {
        return this.datagram;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public TrackerServer(boolean datagram, String protocol) {
        this.datagram = datagram;
        this.secure = Context.getConfig().getBoolean(Keys.PROTOCOL_SSL.withPrefix(protocol));
        this.address = Context.getConfig().getString(Keys.PROTOCOL_ADDRESS.withPrefix(protocol));
        this.port = Context.getConfig().getInteger(Keys.PROTOCOL_PORT.withPrefix(protocol));
        BasePipelineFactory pipelineFactory = new BasePipelineFactory(this, protocol){

            @Override
            protected void addTransportHandlers(PipelineBuilder pipeline) {
                try {
                    if (TrackerServer.this.isSecure()) {
                        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
                        pipeline.addLast((ChannelHandler)new SslHandler(engine));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline) {
                TrackerServer.this.addProtocolHandlers(pipeline);
            }
        };
        this.bootstrap = datagram ? ((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupFactory.getWorkerGroup())).channel(NioDatagramChannel.class)).handler((ChannelHandler)pipelineFactory) : ((ServerBootstrap)new ServerBootstrap().group(EventLoopGroupFactory.getBossGroup(), EventLoopGroupFactory.getWorkerGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)pipelineFactory);
    }

    protected abstract void addProtocolHandlers(PipelineBuilder var1);

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    public void start() throws Exception {
        InetSocketAddress endpoint = this.address == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.address, this.port);
        Channel channel = this.bootstrap.bind((SocketAddress)endpoint).syncUninterruptibly().channel();
        if (channel != null) {
            this.getChannelGroup().add((Object)channel);
        }
    }

    @Override
    public void stop() {
        this.channelGroup.close().awaitUninterruptibly();
    }
}

