/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.traccar.database.CalendarManager;
import org.traccar.database.ConnectionManager;
import org.traccar.database.GeofenceManager;
import org.traccar.database.IdentityManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class GeofenceEventHandler
extends BaseEventHandler {
    private final IdentityManager identityManager;
    private final GeofenceManager geofenceManager;
    private final CalendarManager calendarManager;
    private final ConnectionManager connectionManager;

    public GeofenceEventHandler(IdentityManager identityManager, GeofenceManager geofenceManager, CalendarManager calendarManager, ConnectionManager connectionManager) {
        this.identityManager = identityManager;
        this.geofenceManager = geofenceManager;
        this.calendarManager = calendarManager;
        this.connectionManager = connectionManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Event event;
        Calendar calendar;
        long calendarId;
        long geofenceId;
        Device device = this.identityManager.getById(position.getDeviceId());
        if (device == null) {
            return null;
        }
        if (!this.identityManager.isLatestPosition(position) || !position.getValid()) {
            return null;
        }
        List<Long> currentGeofences = this.geofenceManager.getCurrentDeviceGeofences(position);
        ArrayList<Long> oldGeofences = new ArrayList<Long>();
        if (device.getGeofenceIds() != null) {
            oldGeofences.addAll(device.getGeofenceIds());
        }
        ArrayList<Long> newGeofences = new ArrayList<Long>(currentGeofences);
        newGeofences.removeAll(oldGeofences);
        oldGeofences.removeAll(currentGeofences);
        device.setGeofenceIds(currentGeofences);
        if (!oldGeofences.isEmpty() || !newGeofences.isEmpty()) {
            this.connectionManager.updateDevice(device);
        }
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        Iterator iterator = oldGeofences.iterator();
        while (iterator.hasNext()) {
            geofenceId = (Long)iterator.next();
            calendarId = ((Geofence)this.geofenceManager.getById(geofenceId)).getCalendarId();
            Calendar calendar2 = calendar = calendarId != 0L ? (Calendar)this.calendarManager.getById(calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            event = new Event("geofenceExit", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        iterator = newGeofences.iterator();
        while (iterator.hasNext()) {
            geofenceId = (Long)iterator.next();
            calendarId = ((Geofence)this.geofenceManager.getById(geofenceId)).getCalendarId();
            Calendar calendar3 = calendar = calendarId != 0L ? (Calendar)this.calendarManager.getById(calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            event = new Event("geofenceEnter", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        return events;
    }
}

