/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import org.apache.log.output.io.rotate.BaseFileNameFilter;
import org.apache.log.output.io.rotate.FileStrategy;

public class RevolvingFileStrategy
implements FileStrategy {
    private static final String PATTERN = "'.'000000";
    private DecimalFormat m_decimalFormat = new DecimalFormat("'.'000000");
    private int m_rotation;
    private int m_maxRotations;
    private File m_baseFile;

    public RevolvingFileStrategy(File baseFile, int maxRotations) {
        this(baseFile, -1, maxRotations);
    }

    public RevolvingFileStrategy(File baseFile, int initialRotation, int maxRotations) {
        this.m_baseFile = baseFile;
        this.m_rotation = initialRotation;
        this.m_maxRotations = maxRotations;
        if (-1 == this.m_maxRotations) {
            this.m_maxRotations = Integer.MAX_VALUE;
        }
        if (-1 == initialRotation) {
            this.m_rotation = this.calculateInitialRotation();
        }
        if (this.m_rotation > this.m_maxRotations) {
            this.m_rotation = this.m_maxRotations;
        }
        if (this.m_rotation < 0) {
            this.m_rotation = 0;
        }
    }

    public File nextFile() {
        StringBuffer sb = new StringBuffer();
        FieldPosition position = new FieldPosition(0);
        sb.append(this.m_baseFile);
        StringBuffer result = this.m_decimalFormat.format((long)this.m_rotation, sb, position);
        ++this.m_rotation;
        if (this.m_rotation >= this.m_maxRotations) {
            this.m_rotation = 0;
        }
        return new File(result.toString());
    }

    public int getCurrentRotation() {
        return this.m_rotation;
    }

    private int calculateInitialRotation() {
        File[] matchingFiles = this.getMatchingFiles();
        if (null == matchingFiles || 0 == matchingFiles.length) {
            return 0;
        }
        int[] rotations = this.calculateRotations(matchingFiles);
        int maxRotation = 0;
        for (int i = 0; i < rotations.length; ++i) {
            int rotation = rotations[i];
            if (rotation <= maxRotation) continue;
            maxRotation = rotation;
        }
        int minRotation = maxRotation;
        int minRotationIndex = 0;
        for (int i = 0; i < rotations.length; ++i) {
            int rotation = rotations[i];
            if (rotation > minRotation) continue;
            minRotation = rotation;
            minRotationIndex = i;
        }
        if (this.m_maxRotations != maxRotation) {
            return maxRotation + 1;
        }
        long time = matchingFiles[minRotationIndex].lastModified();
        int oldest = rotations[minRotationIndex];
        for (int i = 0; i < matchingFiles.length; ++i) {
            File file = matchingFiles[i];
            long lastModified = file.lastModified();
            if (lastModified >= time) continue;
            time = lastModified;
            oldest = rotations[i];
        }
        return oldest;
    }

    private int[] calculateRotations(File[] matchingFiles) {
        int[] results = new int[matchingFiles.length];
        for (int i = 0; i < matchingFiles.length; ++i) {
            File file = matchingFiles[i];
            try {
                results[i] = this.calculateRotationForFile(file);
                continue;
            }
            catch (NumberFormatException nfe) {
                results[i] = -1;
            }
        }
        return results;
    }

    private int calculateRotationForFile(File file) {
        String filename = file.toString();
        int length = filename.length();
        int minDigits = this.m_decimalFormat.getMinimumIntegerDigits();
        String rotation = filename.substring(length - minDigits);
        return Integer.parseInt(rotation);
    }

    private File[] getMatchingFiles() {
        String baseFileName;
        File basePath;
        String fullFilePathName = this.m_baseFile.getPath();
        int fileSeparatorPosition = fullFilePathName.lastIndexOf(File.separator);
        if (fileSeparatorPosition < 0) {
            basePath = new File(".");
            baseFileName = fullFilePathName;
        } else {
            String m_parentPath = fullFilePathName.substring(0, fileSeparatorPosition);
            baseFileName = fullFilePathName.substring(fileSeparatorPosition + 1);
            basePath = new File(m_parentPath);
        }
        return basePath.listFiles(new BaseFileNameFilter(baseFileName));
    }
}

