/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGBA;

public class HSL {
    String output = null;
    CssValue vh;
    CssValue vs;
    CssValue vl;
    CssValue va;
    static final String functionname = "hsl";

    public static final CssValue filterValue(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19 && val.getType() == 4) {
            float p;
            CssCheckableValue v = val.getCheckableValue();
            if (!v.warnPositiveness(ac, "RGB")) {
                CssNumber nb = new CssNumber();
                nb.setIntValue(0);
                return nb;
            }
            if (val.getRawType() == 4 && (double)(p = ((CssPercentage)val).floatValue()) > 100.0) {
                ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
                return new CssPercentage(100);
            }
        }
        return val;
    }

    public static final CssValue filterHue(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19) {
            if (val.getType() == 5) {
                float p;
                CssCheckableValue v = val.getCheckableValue();
                if (!v.isPositive()) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    if (val.getRawType() == 5) {
                        float p2 = ((CssNumber)val).getValue();
                        CssNumber nb = new CssNumber();
                        nb.setFloatValue((float)(((double)p2 % 360.0 + 360.0) % 360.0));
                        return nb;
                    }
                }
                if (val.getRawType() == 5 && (double)(p = ((CssNumber)val).getValue()) > 360.0) {
                    ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
                    CssNumber nb = new CssNumber();
                    nb.setFloatValue((float)(((double)p % 360.0 + 360.0) % 360.0));
                    return nb;
                }
            } else if (val.getType() == 7) {
                CssCheckableValue v = val.getCheckableValue();
                if (!v.isPositive()) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                }
                if (val.getRawType() == 7) {
                    CssAngle a = (CssAngle)val;
                    float p = a.getValue();
                    if (p > CssAngle.deg360.divide(a.factor, 2, 5).floatValue()) {
                        ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
                    }
                    a.normalizeValue();
                }
            }
        }
        return val;
    }

    public final void setHue(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vh = HSL.filterHue(ac, val);
    }

    public final void setSaturation(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vs = HSL.filterValue(ac, val);
    }

    public final void setLightness(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vl = HSL.filterValue(ac, val);
    }

    public void setAlpha(ApplContext ac, CssValue alpha) throws InvalidParamException {
        this.output = null;
        this.va = RGBA.filterAlpha(ac, alpha);
    }

    public boolean equals(HSL other) {
        if (other != null) {
            return this.vh.equals(other.vh) && this.vs.equals(other.vs) && this.vl.equals(other.vl) && (this.va == null && other.va == null || this.va != null && this.va.equals(other.va));
        }
        return false;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder(functionname);
            sb.append('(').append(this.vh).append(' ');
            sb.append(this.vs).append(' ').append(this.vl);
            if (this.va != null) {
                sb.append(" / ").append(this.va);
            }
            sb.append(')');
            this.output = sb.toString();
        }
        return this.output;
    }
}

