/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PNodeLocator;
import java.awt.geom.RectangularShape;

public class PBoundsLocator
extends PNodeLocator {
    private int side;

    public static PBoundsLocator createEastLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 3);
    }

    public static PBoundsLocator createNorthEastLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 2);
    }

    public static PBoundsLocator createNorthWestLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 8);
    }

    public static PBoundsLocator createNorthLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 1);
    }

    public static PBoundsLocator createSouthLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 5);
    }

    public static PBoundsLocator createWestLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 7);
    }

    public static PBoundsLocator createSouthWestLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 6);
    }

    public static PBoundsLocator createSouthEastLocator(PNode pNode) {
        return new PBoundsLocator(pNode, 4);
    }

    public PBoundsLocator(PNode pNode, int n) {
        super(pNode);
        this.side = n;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public double locateX() {
        PBounds pBounds = this.node.getBoundsReference();
        switch (this.side) {
            case 6: 
            case 7: 
            case 8: {
                return ((RectangularShape)pBounds).getX();
            }
            case 2: 
            case 3: 
            case 4: {
                return ((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth();
            }
            case 1: 
            case 5: {
                return ((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth() / 2.0;
            }
        }
        return -1.0;
    }

    public double locateY() {
        PBounds pBounds = this.node.getBoundsReference();
        switch (this.side) {
            case 3: 
            case 7: {
                return ((RectangularShape)pBounds).getY() + ((RectangularShape)pBounds).getHeight() / 2.0;
            }
            case 4: 
            case 5: 
            case 6: {
                return ((RectangularShape)pBounds).getY() + ((RectangularShape)pBounds).getHeight();
            }
            case 1: 
            case 2: 
            case 8: {
                return ((RectangularShape)pBounds).getY();
            }
        }
        return -1.0;
    }
}

