/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.ir.StoreNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;

public class StoreFieldMemberNode
extends StoreNode {
    protected String name;
    protected boolean isStatic;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitStoreFieldMember(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
    }

    public StoreFieldMemberNode(Location location) {
        super(location);
    }

    @Override
    public void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        if (!this.isStatic) {
            methodWriter.loadThis();
        }
        this.getChildNode().write(classWriter, methodWriter, writeScope);
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.isStatic) {
            methodWriter.putStatic(WriterConstants.CLASS_TYPE, this.name, MethodWriter.getType(this.getStoreType()));
        } else {
            methodWriter.putField(WriterConstants.CLASS_TYPE, this.name, MethodWriter.getType(this.getStoreType()));
        }
    }
}

