/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractDataTypeHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.docking.settings.Settings;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Equate;
import ghidra.program.util.EquateOperandFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.UniversalID;
import javax.swing.JComponent;

public class DataTypeListingHover
extends AbstractDataTypeHover
implements ListingHoverService {
    private static final String NAME = "Data Type Display";
    private static final String DESCRIPTION = "Toggle whether data type contents are displayed in a tooltip when the mouse hovers over a data type.";
    private static final int PRIORITY = 20;

    public DataTypeListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    public void initializeOptions() {
        this.options = this.tool.getOptions("Listing Popups");
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    @Override
    public void setOptions(Options options, String name) {
        this.enabled = options.getBoolean(NAME, true);
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        DataType dt = null;
        Data dataInstance = null;
        Integer dataLen = null;
        boolean hasInvalidStorage = false;
        if (programLocation instanceof VariableLocation) {
            if (programLocation instanceof VariableCommentFieldLocation) {
                return null;
            }
            Variable var = ((VariableLocation)programLocation).getVariable();
            if (var != null) {
                dt = var.getDataType();
                hasInvalidStorage = !var.isValid();
            }
        } else if (programLocation instanceof MnemonicFieldLocation) {
            dataInstance = this.getDataForLocation(program, programLocation);
            if (dataInstance != null && (dt = dataInstance.getDataType()).getLength() < 0) {
                dataLen = dataInstance.getLength();
            }
        } else if (programLocation instanceof FunctionReturnTypeFieldLocation) {
            dt = this.getFunctionReturnDataType(program, programLocation.getAddress());
        }
        if (dt != null) {
            String toolTipText = ToolTipUtils.getToolTipText(dt);
            if (dataLen != null) {
                toolTipText = toolTipText.replace("Unsized", Integer.toString(dataLen));
            }
            if (dataInstance != null) {
                toolTipText = toolTipText.replace("</HTML>", this.getLocationSupplimentalToolTipText(dt, dataInstance) + "</HTML>");
            }
            Object warningMsg = "";
            if (hasInvalidStorage) {
                warningMsg = (String)warningMsg + "WARNING! Invalid Storage";
            }
            if (((String)warningMsg).length() != 0) {
                String errorText = "<HTML><center><font color=\"red\">" + (String)warningMsg + "!</font></center><BR>";
                toolTipText = toolTipText.replace("<HTML>", errorText);
            }
            return this.createTooltipComponent(toolTipText);
        }
        if (programLocation instanceof EquateOperandFieldLocation) {
            EquateOperandFieldLocation equateLocation = (EquateOperandFieldLocation)programLocation;
            return this.createEquateToolTipComponent(program, equateLocation.getEquate());
        }
        return null;
    }

    private String getLocationSupplimentalToolTipText(DataType dt, Data dataInstance) {
        Object result = "";
        if (dt instanceof DataTypeWithCharset) {
            String charset = ((DataTypeWithCharset)dt).getCharsetName((Settings)dataInstance);
            result = String.format("<br>Charset: %s", charset);
        }
        if (StringDataInstance.isString((Data)dataInstance)) {
            StringDataInstance sdi = StringDataInstance.getStringDataInstance((Data)dataInstance);
            if (sdi.isShowTranslation()) {
                result = (String)result + String.format("<br>Original value: %s", HTMLUtilities.friendlyEncodeHTML((String)sdi.getStringValue()));
            }
            if (!sdi.isShowTranslation() && sdi.getTranslatedValue() != null) {
                result = (String)result + String.format("<br>Translated value: %s", HTMLUtilities.friendlyEncodeHTML((String)sdi.getTranslatedValue()));
            }
            if (!sdi.isPascal() && !sdi.hasNullTerminator()) {
                result = (String)result + "<br>Missing NULL terminator.";
            }
            if (sdi.getStringLength() > dataInstance.getLength()) {
                result = (String)result + "<br><font color=\"red\">String exceeds data field.</font>";
            }
        }
        return result;
    }

    private Data getDataForLocation(Program program, ProgramLocation location) {
        Address address;
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(address = location.getAddress());
        if (data != null) {
            return data.getComponent(location.getComponentPath());
        }
        return null;
    }

    private DataType getFunctionReturnDataType(Program program, Address address) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(address);
        if (function != null) {
            return function.getReturnType();
        }
        return null;
    }

    private JComponent createEquateToolTipComponent(Program program, Equate equate) {
        StringBuilder hoverInfo = new StringBuilder();
        if (equate.isEnumBased() && equate.isValidUUID()) {
            UniversalID id;
            DataTypeManager dtm = program.getDataTypeManager();
            Enum enoom = (Enum)dtm.findDataTypeForID(id = equate.getEnumUUID());
            if (enoom != null) {
                hoverInfo.append("<html>Equate value: " + equate.getDisplayValue() + "<hr>" + ToolTipUtils.getHTMLRepresentation((DataType)enoom).getHTMLContentString() + "</html>");
            }
        } else {
            hoverInfo.append(equate.getDisplayValue());
        }
        return this.createTooltipComponent(hoverInfo.toString());
    }
}

