/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataTypePropertyManager {
    private WeakSet<ChangeListener> changeListeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private KeyStroke recentlyUsedKeyStroke = KeyStroke.getKeyStroke(89, 0);
    private DataType recentlyUsedDataType;
    private long recentlyUsedDtId;
    private DataTypeManager programDataTypesManager;

    void remove(DataType dt) {
        boolean notify = false;
        if (this.isRecentlyUsedDataType(dt)) {
            this.recentlyUsedDataType = null;
            notify = true;
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    void dataTypeRenamed(DataType dt) {
        if (this.isFavorite(dt) || this.isRecentlyUsedDataType(dt)) {
            this.notifyListeners();
        }
    }

    private boolean isRecentlyUsedDataType(DataType dataType) {
        return this.recentlyUsedDataType != null && this.recentlyUsedDataType.equals(dataType);
    }

    private boolean isFavorite(DataType dt) {
        return dt.getDataTypeManager().isFavorite(dt);
    }

    boolean setRecentlyUsed(DataType dt) {
        if (dt != this.recentlyUsedDataType && !dt.isDeleted()) {
            this.recentlyUsedDataType = dt;
            if (this.programDataTypesManager != null && dt.getDataTypeManager() == this.programDataTypesManager) {
                this.recentlyUsedDtId = this.programDataTypesManager.getID(dt);
            }
            return true;
        }
        return false;
    }

    DataType getRecentlyUsed() {
        return this.recentlyUsedDataType;
    }

    KeyStroke getKeyStrokeForRecentlyUsed() {
        return this.recentlyUsedKeyStroke;
    }

    void programOpened(Program program) {
        this.programDataTypesManager = program.getListing().getDataTypeManager();
    }

    void programClosed(Program program) {
        this.recentlyUsedDataType = null;
        this.programDataTypesManager = null;
    }

    void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        DataTypeManager dataTypeManager = domainObject.getDataTypeManager();
        if (dataTypeManager != this.programDataTypesManager) {
            return;
        }
        if (this.recentlyUsedDataType != null && this.recentlyUsedDataType.getDataTypeManager() == this.programDataTypesManager) {
            this.recentlyUsedDataType = this.programDataTypesManager.getDataType(this.recentlyUsedDtId);
        }
        this.notifyListeners();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    private void notifyListeners() {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        Runnable notifyRunnable = new Runnable(){

            @Override
            public void run() {
                ChangeEvent event = new ChangeEvent(DataTypePropertyManager.this);
                for (ChangeListener l : DataTypePropertyManager.this.changeListeners) {
                    l.stateChanged(event);
                }
            }
        };
        SystemUtilities.runSwingNow((Runnable)notifyRunnable);
    }
}

