/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import ghidra.app.plugin.core.datamgr.util.CaseInsensitveDataTypeLookupComparator;
import ghidra.app.plugin.core.datamgr.util.DataTypeIconWrapper;
import ghidra.app.plugin.core.datamgr.util.HighlightIcon;
import ghidra.app.services.DataTypeQueryService;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FileArchiveBasedDataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.Msg;
import ghidra.util.datastruct.Algorithms;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;

public class DataTypeUtils {
    private static final Comparator<Object> DATA_TYPE_LOOKUP_COMPARATOR = new CaseInsensitveDataTypeLookupComparator();
    private static final char END_CHAR = '\uffff';
    private static final char BEGIN_CHAR = '\u0000';
    private static Map<Icon, MultiIcon> highlightIconMap = new HashMap<Icon, MultiIcon>();
    private static String OPEN_FOLDER = "images/openFolder.png";
    private static String CLOSED_FOLDER = "images/closedFolder.png";
    private static String DISABLED_OPEN_FOLDER = "images/disabledOpenFolder.png";
    private static String DISABLED_CLOSED_FOLDER = "images/disabledClosedFolder.png";
    private static String DEFAULT_ICON = "images/defaultDt.gif";
    private static String DISABLED_DEFAULT_ICON = "images/disabledCode.gif";
    private static String LOCKED_OPEN_FOLDER = "images/openFolderCheckedOut.png";
    private static String LOCKED_CLOSED_FOLDER = "images/closedFolderCheckedOut.png";
    private static String OPEN_ARCHIVE_FOLDER = "images/openFolderArchive.png";
    private static String CLOSED_ARCHIVE_FOLDER = "images/closedFolderArchive.png";
    private static String ROOT_ICON = "images/BookShelf.png";
    private static String OPEN_ROOT_ICON = "images/BookShelfOpen.png";
    private static String FAVORITE_ICON = "images/emblem-favorite.png";
    private static String BUILT_IN_ICON = "images/package_development.png";
    private static String STRUCTURE_ICON = "images/cstruct.png";
    private static String UNION_ICON = "images/cUnion.png";
    private static String TYPEDEF_ICON = "images/typedef.png";
    private static String FUNCTION_ICON = "images/functionDef.png";
    private static String ENUM_ICON = "images/enum.png";
    private static String POINTER_ICON = "images/fingerPointer.png";
    private static Icon defaultIcon;
    private static Icon disabledIcon;
    private static Icon favoriteIcon;
    private static Icon disabledFavoriteIcon;
    private static Icon builtInIcon;
    private static Icon disabledBuiltInIcon;
    private static Icon rootIcon;
    private static Icon openRootIcon;
    private static Icon openFolderIcon;
    private static Icon disabledOpenFolderIcon;
    private static Icon closedFolderIcon;
    private static Icon disabledClosedFolderIcon;
    private static Icon lockedOpenFolderIcon;
    private static Icon lockedClosedFolderIcon;
    private static Icon openArchiveFolderIcon;
    private static Icon closedArchiveFolderIcon;
    private static DataTypeIconWrapper[] dataTypeIconWrappers;
    private static boolean imagesLoaded;

    private DataTypeUtils() {
    }

    private static void loadImages() {
        if (imagesLoaded) {
            return;
        }
        imagesLoaded = true;
        defaultIcon = ResourceManager.loadImage((String)DEFAULT_ICON);
        disabledIcon = ResourceManager.loadImage((String)DISABLED_DEFAULT_ICON);
        favoriteIcon = ResourceManager.loadImage((String)FAVORITE_ICON);
        disabledFavoriteIcon = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)favoriteIcon));
        builtInIcon = ResourceManager.loadImage((String)BUILT_IN_ICON);
        disabledBuiltInIcon = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)builtInIcon));
        rootIcon = ResourceManager.loadImage((String)ROOT_ICON);
        openRootIcon = ResourceManager.loadImage((String)OPEN_ROOT_ICON);
        openFolderIcon = ResourceManager.loadImage((String)OPEN_FOLDER);
        disabledOpenFolderIcon = ResourceManager.loadImage((String)DISABLED_OPEN_FOLDER);
        closedFolderIcon = ResourceManager.loadImage((String)CLOSED_FOLDER);
        disabledClosedFolderIcon = ResourceManager.loadImage((String)DISABLED_CLOSED_FOLDER);
        lockedOpenFolderIcon = ResourceManager.loadImage((String)LOCKED_OPEN_FOLDER);
        lockedClosedFolderIcon = ResourceManager.loadImage((String)LOCKED_CLOSED_FOLDER);
        openArchiveFolderIcon = ResourceManager.loadImage((String)OPEN_ARCHIVE_FOLDER);
        closedArchiveFolderIcon = ResourceManager.loadImage((String)CLOSED_ARCHIVE_FOLDER);
        DataTypeUtils.createDataTypeIcons();
    }

    private static void createDataTypeIcons() {
        ArrayList<DataTypeIconWrapper> list = new ArrayList<DataTypeIconWrapper>();
        ImageIcon enumIcon = ResourceManager.loadImage((String)ENUM_ICON);
        list.add(new DataTypeIconWrapper(Enum.class, enumIcon, ResourceManager.getDisabledIcon((ImageIcon)enumIcon)));
        ImageIcon functionIcon = ResourceManager.loadImage((String)FUNCTION_ICON);
        list.add(new DataTypeIconWrapper(FunctionDefinition.class, functionIcon, ResourceManager.getDisabledIcon((ImageIcon)functionIcon)));
        ImageIcon pointerIcon = ResourceManager.loadImage((String)POINTER_ICON);
        list.add(new DataTypeIconWrapper(Pointer.class, pointerIcon, ResourceManager.getDisabledIcon((ImageIcon)pointerIcon)));
        ImageIcon typedefIcon = ResourceManager.loadImage((String)TYPEDEF_ICON);
        list.add(new DataTypeIconWrapper(TypeDef.class, typedefIcon, ResourceManager.getDisabledIcon((ImageIcon)typedefIcon)));
        ImageIcon unionIcon = ResourceManager.loadImage((String)UNION_ICON);
        list.add(new DataTypeIconWrapper(Union.class, unionIcon, ResourceManager.getDisabledIcon((ImageIcon)unionIcon)));
        ImageIcon structureIcon = ResourceManager.loadImage((String)STRUCTURE_ICON);
        list.add(new DataTypeIconWrapper(Structure.class, structureIcon, ResourceManager.getDisabledIcon((ImageIcon)structureIcon)));
        dataTypeIconWrappers = list.toArray(new DataTypeIconWrapper[list.size()]);
    }

    public static Icon getRootIcon(boolean expanded) {
        DataTypeUtils.loadImages();
        return expanded ? openRootIcon : rootIcon;
    }

    public static Icon getOpenFolderIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledOpenFolderIcon;
        }
        return openFolderIcon;
    }

    public static Icon getClosedFolderIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledClosedFolderIcon;
        }
        return closedFolderIcon;
    }

    public static Icon getOpenArchiveFolder(boolean isLocked) {
        DataTypeUtils.loadImages();
        if (isLocked) {
            return lockedOpenFolderIcon;
        }
        return openArchiveFolderIcon;
    }

    public static Icon getClosedArchiveFolder(boolean isLocked) {
        DataTypeUtils.loadImages();
        if (isLocked) {
            return lockedClosedFolderIcon;
        }
        return closedArchiveFolderIcon;
    }

    public static Icon getBuiltInIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledBuiltInIcon;
        }
        return builtInIcon;
    }

    public static Icon getFavoriteIcon(boolean disabled) {
        DataTypeUtils.loadImages();
        if (disabled) {
            return disabledFavoriteIcon;
        }
        return favoriteIcon;
    }

    public static Icon getIconForDataType(DataType dataType, boolean disabled) {
        DataTypeUtils.loadImages();
        for (DataTypeIconWrapper element : dataTypeIconWrappers) {
            Icon icon = element.getIcon(dataType, disabled);
            if (icon == null) continue;
            return icon;
        }
        if (disabled) {
            return disabledIcon;
        }
        return defaultIcon;
    }

    public static Icon getHighlightIcon(Icon baseIcon) {
        DataTypeUtils.loadImages();
        MultiIcon highlightIcon = highlightIconMap.get(baseIcon);
        if (highlightIcon == null) {
            highlightIcon = new MultiIcon((Icon)new HighlightIcon(new Color(204, 204, 255)));
            highlightIcon.addIcon(baseIcon);
            highlightIconMap.put(baseIcon, highlightIcon);
        }
        return highlightIcon;
    }

    public static List<DataType> getStartsWithMatchingDataTypes(String searchString, DataTypeQueryService dataService) {
        return DataTypeUtils.getMatchingSubList(searchString, searchString + "\uffff", dataService.getSortedDataTypeList());
    }

    public static List<DataType> getExactMatchingDataTypes(String searchString, DataTypeQueryService dataService) {
        return DataTypeUtils.getMatchingSubList(searchString, searchString + "\u0000", dataService.getSortedDataTypeList());
    }

    public static String prepareSearchText(String searchText) {
        return searchText.replaceAll(" ", "");
    }

    static List<DataType> getMatchingSubList(String searchTextStart, String searchTextEnd, List<DataType> dataTypeList) {
        searchTextStart = DataTypeUtils.prepareSearchText(searchTextStart);
        searchTextEnd = DataTypeUtils.prepareSearchText(searchTextEnd);
        int startIndex = Algorithms.binarySearchWithDuplicates(dataTypeList, (Object)searchTextStart, DATA_TYPE_LOOKUP_COMPARATOR);
        int endIndex = Algorithms.binarySearchWithDuplicates(dataTypeList, (Object)searchTextEnd, DATA_TYPE_LOOKUP_COMPARATOR);
        return dataTypeList.subList(startIndex, endIndex);
    }

    public static DataType getBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array || baseDataType instanceof TypeDef) {
            if (baseDataType instanceof Pointer) {
                DataType innerDt = ((Pointer)baseDataType).getDataType();
                if (innerDt != null) {
                    baseDataType = innerDt;
                    continue;
                }
                return baseDataType;
            }
            if (baseDataType instanceof Array) {
                baseDataType = ((Array)baseDataType).getDataType();
                continue;
            }
            baseDataType = ((TypeDef)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType getNamedBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array) {
            if (baseDataType instanceof Pointer) {
                DataType innerDt = ((Pointer)baseDataType).getDataType();
                if (innerDt != null) {
                    baseDataType = innerDt;
                    continue;
                }
                return baseDataType;
            }
            if (!(baseDataType instanceof Array)) continue;
            baseDataType = ((Array)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType copyToNamedBaseDataType(DataType dataType, DataTypeManager dtm) {
        if (dataType instanceof Pointer) {
            Pointer pdt = (Pointer)dataType;
            return new PointerDataType(DataTypeUtils.copyToNamedBaseDataType(pdt.getDataType(), dtm), pdt.isDynamicallySized() ? -1 : pdt.getLength(), dtm);
        }
        if (dataType instanceof Array) {
            Array adt = (Array)dataType;
            return new ArrayDataType(DataTypeUtils.copyToNamedBaseDataType(adt.getDataType(), dtm), adt.getNumElements(), adt.getElementLength(), dtm);
        }
        return dataType.copy(dtm);
    }

    public static void showUnmodifiableArchiveErrorMessage(Component parent, String title, DataTypeManager dtm) {
        String msg = dtm instanceof ProgramBasedDataTypeManager ? "The Program is not modifiable!\n" : (dtm instanceof FileArchiveBasedDataTypeManager ? "The archive file is not modifiable!\nYou must open the archive for editing\n before performing this operation." : "The project archive is not modifiable!\nYou must check out the archive\n before performing this operation.");
        Msg.showInfo(DataTypeUtils.class, (Component)parent, (String)title, (Object)msg);
    }
}

