/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.line.FileEntry;
import ghidra.app.util.bin.format.dwarf.line.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StatementProgramPrologue {
    public static final int TOTAL_LENGTH_FIELD_LEN = 4;
    public static final int PRE_PROLOGUE_LEN = 10;
    private int totalLength;
    private short version;
    private int prologueLength;
    private byte minimumInstructionLength;
    private boolean defaultIsStatement;
    private byte lineBase;
    private byte lineRange;
    private byte opcodeBase;
    private byte[] standardOpcodeLengths;
    private List<String> includeDirectories = new ArrayList<String>();
    private List<FileEntry> fileNames = new ArrayList<FileEntry>();

    public StatementProgramPrologue(BinaryReader reader) throws IOException {
        FileEntry entry;
        String dir;
        this.totalLength = reader.readNextInt();
        this.version = reader.readNextShort();
        if (this.version != 2) {
            throw new IllegalStateException("Only DWARF v2 is supported.");
        }
        this.prologueLength = reader.readNextInt();
        this.minimumInstructionLength = reader.readNextByte();
        this.defaultIsStatement = reader.readNextByte() != 0;
        this.lineBase = reader.readNextByte();
        this.lineRange = reader.readNextByte();
        this.opcodeBase = reader.readNextByte();
        this.standardOpcodeLengths = reader.readNextByteArray(this.opcodeBase - 1);
        while ((dir = reader.readNextAsciiString()).length() != 0) {
            this.includeDirectories.add(dir);
        }
        while ((entry = new FileEntry(reader)).getFileName().length() != 0) {
            this.fileNames.add(entry);
        }
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getVersion() {
        return this.version & 0xFFFF;
    }

    public int getPrologueLength() {
        return this.prologueLength;
    }

    public int getMinimumInstructionLength() {
        return this.minimumInstructionLength & 0xFF;
    }

    public boolean isDefaultIsStatement() {
        return this.defaultIsStatement;
    }

    public int getLineBase() {
        return this.lineBase & 0xFF;
    }

    public int getLineRange() {
        return this.lineRange & 0xFF;
    }

    public int getOpcodeBase() {
        return this.opcodeBase & 0xFF;
    }

    public byte[] getStandardOpcodeLengths() {
        return this.standardOpcodeLengths;
    }

    public List<String> getIncludeDirectories() {
        return this.includeDirectories;
    }

    public List<FileEntry> getFileNames() {
        return this.fileNames;
    }

    public FileEntry getFileNameByIndex(int fileIndex) {
        return this.fileNames.get(fileIndex - 1);
    }

    public String getDirectoryByIndex(LEB128 directoryIndex) {
        if (directoryIndex.getValue() == 0L) {
            return ".";
        }
        return this.includeDirectories.get((int)directoryIndex.getValue() - 1);
    }
}

