/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.AbstractDyldInfoProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.BindState;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;

public class BindProcessor
extends AbstractDyldInfoProcessor {
    public BindProcessor(Program program, MachHeader header, ByteProvider provider, DyldInfoCommand command) {
        super(header, program, provider, command);
    }

    @Override
    public void process(TaskMonitor monitor) throws Exception {
        int value;
        BindState bind = new BindState(this.header, this.program);
        boolean done = false;
        byte[] commandBytes = this.provider.readBytes(this.command.getBindOffset(), this.command.getBindSize());
        ByteArrayInputStream byteServer = new ByteArrayInputStream(commandBytes);
        block15: while (!done && !monitor.isCancelled() && (value = byteServer.read()) != -1) {
            byte b = (byte)value;
            int opcode = b & 0xF0;
            int immediate = b & 0xF;
            block0 : switch (opcode) {
                case 128: {
                    bind.segmentOffset += this.uleb128(byteServer, monitor);
                    break;
                }
                case 144: {
                    bind.perform(monitor);
                    bind.segmentOffset += (long)this.program.getDefaultPointerSize();
                    break;
                }
                case 176: {
                    bind.perform(monitor);
                    bind.segmentOffset += (long)(immediate * this.program.getDefaultPointerSize() + this.program.getDefaultPointerSize());
                    break;
                }
                case 160: {
                    bind.perform(monitor);
                    bind.segmentOffset += this.uleb128(byteServer, monitor) + (long)this.program.getDefaultPointerSize();
                    break;
                }
                case 192: {
                    long count = this.uleb128(byteServer, monitor);
                    long skip = this.uleb128(byteServer, monitor);
                    int i = 0;
                    while ((long)i < count) {
                        if (monitor.isCancelled()) break block0;
                        bind.perform(monitor);
                        bind.segmentOffset += skip + (long)this.program.getDefaultPointerSize();
                        ++i;
                    }
                    continue block15;
                }
                case 0: {
                    done = true;
                    break;
                }
                case 96: {
                    bind.addend = this.sleb128(byteServer, monitor);
                    break;
                }
                case 16: {
                    bind.libraryOrdinal = immediate;
                    break;
                }
                case 32: {
                    bind.libraryOrdinal = (int)this.uleb128(byteServer, monitor);
                    break;
                }
                case 48: {
                    if (immediate == 0) {
                        bind.libraryOrdinal = 0;
                        break;
                    }
                    byte signExtended = (byte)(0xF0 | immediate);
                    bind.libraryOrdinal = signExtended;
                    break;
                }
                case 112: {
                    bind.segmentIndex = immediate;
                    bind.segmentOffset = this.uleb128(byteServer, monitor);
                    break;
                }
                case 64: {
                    bind.symbolName = this.readString(byteServer, monitor);
                    if ((immediate & 1) != 0) {
                        bind.setWeak(true);
                        break;
                    }
                    bind.setWeak(false);
                    break;
                }
                case 80: {
                    bind.type = immediate;
                    break;
                }
                default: {
                    throw new Exception("Unknown dyld info bind opcode " + Integer.toHexString(opcode));
                }
            }
        }
    }
}

