/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfData;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;

public class OmfEnumeratedData
extends OmfRecord
implements OmfData {
    private int segmentIndex;
    private long dataOffset;
    private long streamOffset;
    private int streamLength;

    public OmfEnumeratedData(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        long start = reader.getPointerIndex();
        this.segmentIndex = OmfRecord.readIndex(reader);
        this.dataOffset = (long)OmfRecord.readInt2Or4(reader, this.hasBigFields()) & 0xFFFFFFFFL;
        this.streamOffset = reader.getPointerIndex();
        this.streamLength = this.getRecordLength() - 1 - (int)(this.streamOffset - start);
        reader.setPointerIndex(this.streamOffset + (long)this.streamLength);
        this.readCheckSumByte(reader);
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    @Override
    public long getDataOffset() {
        return this.dataOffset;
    }

    @Override
    public int getLength() {
        return this.streamLength;
    }

    @Override
    public int compareTo(OmfData o) {
        long otherOffset = o.getDataOffset();
        if (otherOffset == this.dataOffset) {
            return 0;
        }
        return this.dataOffset < otherOffset ? -1 : 1;
    }

    @Override
    public byte[] getByteArray(BinaryReader reader) throws IOException {
        reader.setPointerIndex(this.streamOffset);
        byte[] buffer = reader.readNextByteArray(this.streamLength);
        return buffer;
    }

    @Override
    public boolean isAllZeroes() {
        return false;
    }
}

