/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class CliBlob
implements StructConverter {
    public static final String PATH = "/PE/CLI/Blobs";
    private int streamIndex;
    private BinaryReader reader;
    protected long blobOffset;
    protected long contentsOffset;
    protected int contentsSize;

    public CliBlob(int streamIndex, BinaryReader reader) throws IOException {
        this.streamIndex = streamIndex;
        this.reader = reader;
        this.blobOffset = reader.getPointerIndex();
        this.contentsSize = CliBlob.parseCodedSize(reader);
        this.contentsOffset = reader.getPointerIndex();
        reader.setPointerIndex(reader.getPointerIndex() + (long)this.contentsSize);
    }

    protected CliBlob(CliBlob blob) {
        this.streamIndex = blob.streamIndex;
        this.reader = blob.reader;
        this.blobOffset = blob.blobOffset;
        this.contentsSize = blob.contentsSize;
        this.contentsOffset = blob.contentsOffset;
    }

    protected CliBlob(CliBlob blob, BinaryReader reader) {
        this.streamIndex = blob.streamIndex;
        this.reader = reader;
        this.blobOffset = reader.getPointerIndex();
        this.contentsSize = blob.contentsSize;
        this.contentsOffset = this.blobOffset + (long)this.contentsSize;
    }

    public int getSize() {
        return (int)(this.contentsOffset - this.blobOffset) + this.contentsSize;
    }

    public BinaryReader getContentsReader() {
        BinaryReader contentsReader = new BinaryReader(this.reader.getByteProvider(), this.reader.isLittleEndian());
        contentsReader.setPointerIndex(this.contentsOffset);
        return contentsReader;
    }

    public int getContentsSize() {
        return this.contentsSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContents() {
        long origPointerIndex = this.reader.getPointerIndex();
        try {
            byte[] byArray = this.reader.readByteArray(this.contentsOffset, this.contentsSize);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.reader.setPointerIndex(origPointerIndex);
        }
    }

    public String getRepresentation() {
        return "Blob (" + this.getContentsDataType().getDisplayName() + ")";
    }

    public boolean isLittleEndian() {
        return this.reader.isLittleEndian();
    }

    @Override
    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath(PATH), "Blob_" + this.getName(), 0);
        struct.add(this.getSizeDataType(), "Size", "coded integer - blob size");
        struct.add(this.getContentsDataType(), this.getContentsName(), this.getContentsComment());
        return struct;
    }

    public int getStreamIndex() {
        return this.streamIndex;
    }

    public String getName() {
        return this.getContentsName() + "_" + this.streamIndex;
    }

    public String getContentsName() {
        return "Generic";
    }

    public DataType getContentsDataType() {
        return new ArrayDataType(BYTE, this.contentsSize, 1);
    }

    public String getContentsComment() {
        return "Undefined blob contents";
    }

    public DataType getSizeDataType() {
        int n = (int)(this.contentsOffset - this.blobOffset);
        switch (n) {
            case 4: {
                return DWORD;
            }
            case 2: {
                return WORD;
            }
            case 1: {
                return BYTE;
            }
        }
        throw new AssertException("Unsupported CLI blob size: " + n);
    }

    static int parseCodedSize(BinaryReader reader) throws IOException {
        byte one = reader.readNextByte();
        int size = 0;
        if ((one & 0x80) == 0) {
            size = one & 0xFFFFFF7F & 0xFF;
        } else if ((one & 0xC0) == 128) {
            byte two = reader.readNextByte();
            size = ((one & 0xFFFFFF3F & 0xFF) << 8) + (two & 0xFF);
        } else if ((one & 0xE0) == 192) {
            byte two = reader.readNextByte();
            byte three = reader.readNextByte();
            byte four = reader.readNextByte();
            size = ((one & 0xFFFFFF1F & 0xFF) << 24) + ((two & 0xFF) << 16) + ((three & 0xFF) << 8) + (four & 0xFF);
        }
        return size;
    }

    public static void testSizeDecoding() {
        System.out.println(CliBlob.decodeCompressedUnsigned((byte)3) + " " + CliBlob.decodeCompressedUnsigned((byte)127) + " " + CliBlob.decodeCompressedUnsigned((short)-32640) + " " + CliBlob.decodeCompressedUnsigned((short)-20905) + " " + CliBlob.decodeCompressedUnsigned((short)-16385) + " " + CliBlob.decodeCompressedUnsigned(-1073725440) + " " + CliBlob.decodeCompressedUnsigned(-536870913) + " ");
        System.out.println(CliBlob.decodeCompressedSigned((byte)6) + " " + CliBlob.decodeCompressedSigned((byte)123) + " " + CliBlob.decodeCompressedSigned((short)-32640) + " " + CliBlob.decodeCompressedSigned((byte)1) + " " + CliBlob.decodeCompressedSigned(-1073725440) + " " + CliBlob.decodeCompressedSigned((short)-32767) + " " + CliBlob.decodeCompressedSigned(-536870914) + " " + CliBlob.decodeCompressedSigned(-1073741823) + " ");
    }

    private static int getNumberBytesInCodedInt(byte firstByte) {
        if ((firstByte & 0x80) == 0) {
            return 1;
        }
        if ((firstByte & 0xC0) == 128) {
            return 2;
        }
        if ((firstByte & 0xE0) == 192) {
            return 4;
        }
        return 0;
    }

    private static int rotateCircularRight(int toRotate, int bitSize) {
        if (((toRotate &= (1 << bitSize) - 1) & 1) != 0) {
            toRotate |= 1 << bitSize;
        }
        if (((toRotate >>= 1) & 1 << bitSize - 1) != 0) {
            toRotate ^= 0xFFFFFFFF;
            ++toRotate;
            toRotate &= (1 << bitSize) - 1;
            toRotate *= -1;
        }
        return toRotate;
    }

    public static int decodeCompressedSigned(byte codedSize) {
        return CliBlob.rotateCircularRight(codedSize, 7);
    }

    public static int decodeCompressedSigned(short codedSize) {
        return CliBlob.rotateCircularRight(codedSize, 14);
    }

    public static int decodeCompressedSigned(int codedSize) {
        return CliBlob.rotateCircularRight(codedSize, 29);
    }

    public static int decodeCompressedUnsigned(byte codedSize) {
        return codedSize & 0xFF;
    }

    public static int decodeCompressedUnsigned(short codedSize) {
        codedSize = (short)(codedSize & 0xFFFF3FFF);
        return codedSize & 0xFFFF;
    }

    public static int decodeCompressedUnsigned(int codedSize) {
        codedSize &= 0x1FFFFFFF;
        return codedSize &= 0xFFFFFFFF;
    }

    private static int decodeCompressedInt(BinaryReader reader, boolean signed) throws IOException {
        byte firstByte = reader.peekNextByte();
        boolean isLittleEndian = reader.isLittleEndian();
        reader.setLittleEndian(false);
        int numBytes = CliBlob.getNumberBytesInCodedInt(firstByte);
        int decodedSize = 0;
        switch (numBytes) {
            case 1: {
                byte codedByte = reader.readNextByte();
                if (signed) {
                    decodedSize = CliBlob.decodeCompressedSigned(codedByte);
                    break;
                }
                decodedSize = CliBlob.decodeCompressedUnsigned(codedByte);
                break;
            }
            case 2: {
                short codedShort = reader.readNextShort();
                if (signed) {
                    decodedSize = CliBlob.decodeCompressedSigned(codedShort);
                    break;
                }
                decodedSize = CliBlob.decodeCompressedUnsigned(codedShort);
                break;
            }
            case 4: {
                int codedInt = reader.readNextInt();
                if (signed) {
                    decodedSize = CliBlob.decodeCompressedSigned(codedInt);
                    break;
                }
                decodedSize = CliBlob.decodeCompressedUnsigned(codedInt);
                break;
            }
        }
        reader.setLittleEndian(isLittleEndian);
        return decodedSize;
    }

    public static int decodeCompressedSignedInt(BinaryReader reader) throws IOException {
        return CliBlob.decodeCompressedInt(reader, true);
    }

    public static int decodeCompressedUnsignedInt(BinaryReader reader) throws IOException {
        return CliBlob.decodeCompressedInt(reader, false);
    }

    public static DataType getDataTypeForBytes(int numBytes) {
        switch (numBytes) {
            case 1: {
                return BYTE;
            }
            case 2: {
                return WORD;
            }
            case 4: {
                return DWORD;
            }
        }
        return null;
    }
}

