/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.query;

import docking.widgets.table.TableSortingContext;
import ghidra.app.util.query.AddressAlignmentListener;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AlignedObjectBasedPreviewTableModel<ROW_TYPE>
extends AddressBasedTableModel<ROW_TYPE> {
    protected int alignment = 1;
    protected int[] filteredIndices = new int[0];
    private WeakSet<AddressAlignmentListener> alignmentListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    protected AlignedObjectBasedPreviewTableModel(String modelName, ServiceProvider provider, Program prog, TaskMonitor monitor) {
        this(modelName, provider, prog, monitor, false);
    }

    protected AlignedObjectBasedPreviewTableModel(String modelName, ServiceProvider provider, Program prog, TaskMonitor monitor, boolean loadIncrementally) {
        super(modelName, provider, prog, monitor, loadIncrementally);
    }

    public void addAlignmentListener(AddressAlignmentListener alignmentListener) {
        this.alignmentListeners.add((Object)alignmentListener);
    }

    public void removeAlignmentListener(AddressAlignmentListener alignmentListener) {
        this.alignmentListeners.remove((Object)alignmentListener);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        if (alignment <= 0) {
            throw new IllegalArgumentException("Alignment cannot be less than 1.");
        }
        this.alignment = alignment;
        this.reFilter();
        for (AddressAlignmentListener alignListener : this.alignmentListeners) {
            alignListener.alignmentChanged();
        }
    }

    public List<ROW_TYPE> doFilter(List<ROW_TYPE> data, TableSortingContext<ROW_TYPE> sortingContext, TaskMonitor monitor) throws CancelledException {
        ArrayList<ROW_TYPE> filteredList = new ArrayList<ROW_TYPE>();
        for (int index = 0; index < data.size(); ++index) {
            Address address = this.getAlignmentAddress(data, index);
            if (address.getOffset() % (long)this.alignment != 0L) continue;
            filteredList.add(data.get(index));
        }
        return super.doFilter(filteredList, sortingContext, monitor);
    }

    protected void doLoad(Accumulator<ROW_TYPE> accumulator, TaskMonitor monitor) throws CancelledException {
        this.initializeUnalignedList(accumulator, monitor);
    }

    protected abstract void initializeUnalignedList(Accumulator<ROW_TYPE> var1, TaskMonitor var2) throws CancelledException;

    protected abstract Address getAlignmentAddress(List<ROW_TYPE> var1, int var2);
}

