/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSystemIndexHelper<METADATATYPE> {
    private GFile rootDir;
    protected Map<GFile, METADATATYPE> fileToEntryMap = new HashMap<GFile, METADATATYPE>();
    protected Map<GFile, Map<String, GFile>> directoryToListing = new HashMap<GFile, Map<String, GFile>>();

    public FileSystemIndexHelper(GFileSystem fs, FSRLRoot fsFSRL) {
        this.rootDir = GFileImpl.fromFSRL(fs, null, fsFSRL.withPath("/"), true, -1L);
    }

    public GFile getRootDir() {
        return this.rootDir;
    }

    public void clear() {
        this.fileToEntryMap.clear();
        this.directoryToListing.clear();
    }

    public int getFileCount() {
        return this.fileToEntryMap.size();
    }

    public METADATATYPE getMetadata(GFile f) {
        return this.fileToEntryMap.get(f);
    }

    public List<GFile> getListing(GFile directory) {
        Map<String, GFile> dirListing = this.getDirectoryContents(directory, false);
        ArrayList<GFile> results = dirListing != null ? new ArrayList<GFile>(dirListing.values()) : Collections.emptyList();
        return results;
    }

    public GFile lookup(String path) {
        String[] nameparts = (path != null ? path : "").split("/");
        GFile parent = this.lookupParent(nameparts);
        if (nameparts.length == 0) {
            return parent;
        }
        String name = nameparts[nameparts.length - 1];
        if (name == null || name.isEmpty()) {
            return parent;
        }
        Map<String, GFile> dirListing = this.getDirectoryContents(parent, false);
        return dirListing != null ? dirListing.get(name) : null;
    }

    public GFileImpl storeFile(String path, int fileIndex, boolean isDirectory, long length, METADATATYPE fileInfo) {
        String[] nameparts = path.replaceAll("[\\\\]", "/").split("/");
        GFile parent = this.lookupParent(nameparts);
        int fileNum = fileIndex != -1 ? fileIndex : this.fileToEntryMap.size();
        String lastpart = nameparts[nameparts.length - 1];
        Map<String, GFile> dirContents = this.getDirectoryContents(parent, true);
        String uniqueName = dirContents.containsKey(lastpart) && !isDirectory ? lastpart + "[" + Integer.toString(fileNum) + "]" : lastpart;
        GFileImpl file = this.createNewFile(parent, uniqueName, isDirectory, length, fileInfo);
        dirContents.put(uniqueName, file);
        if (file.isDirectory()) {
            this.getDirectoryContents(file, true);
        }
        this.fileToEntryMap.put(file, fileInfo);
        return file;
    }

    public GFile storeFileWithParent(String filename, GFile parent, int fileIndex, boolean isDirectory, long length, METADATATYPE fileInfo) {
        parent = parent == null ? this.rootDir : parent;
        int fileNum = fileIndex != -1 ? fileIndex : this.fileToEntryMap.size();
        Map<String, GFile> dirContents = this.getDirectoryContents(parent, true);
        String uniqueName = dirContents.containsKey(filename) && !isDirectory ? filename + "[" + Integer.toString(fileNum) + "]" : filename;
        GFileImpl file = this.createNewFile(parent, uniqueName, isDirectory, length, fileInfo);
        dirContents.put(uniqueName, file);
        if (file.isDirectory()) {
            this.getDirectoryContents(file, true);
        }
        this.fileToEntryMap.put(file, fileInfo);
        return file;
    }

    protected Map<String, GFile> getDirectoryContents(GFile directoryFile, boolean createIfMissing) {
        Map<String, GFile> dirContents = this.directoryToListing.get(directoryFile = directoryFile != null ? directoryFile : this.rootDir);
        if (dirContents == null && createIfMissing) {
            dirContents = new HashMap<String, GFile>();
            this.directoryToListing.put(directoryFile, dirContents);
        }
        return dirContents;
    }

    protected GFile lookupParent(String[] nameparts) {
        GFile currentDir = this.rootDir;
        GFile currentFile = this.rootDir;
        for (int i = 0; i < nameparts.length - 1; ++i) {
            Map<String, GFile> currentDirContents = this.getDirectoryContents(currentDir, true);
            String name = nameparts[i];
            if (name.isEmpty()) continue;
            currentFile = currentDirContents.get(name);
            if (currentFile == null) {
                currentFile = this.createNewFile(currentDir, name, true, -1L, null);
                currentDirContents.put(name, currentFile);
                this.getDirectoryContents(currentFile, true);
            }
            currentDir = currentFile;
        }
        return currentFile;
    }

    protected GFileImpl createNewFile(GFile parentFile, String name, boolean isDirectory, long size, METADATATYPE metadata) {
        FSRL newFileFSRL = parentFile.getFSRL().appendPath(name);
        return GFileImpl.fromFSRL(this.rootDir.getFilesystem(), parentFile, newFileFSRL, isDirectory, size);
    }

    public String toString() {
        return "FileSystemIndexHelper for " + this.rootDir.getFilesystem();
    }
}

