/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.io.IOException;

public class MIPS_Elf64Relocation
extends ElfRelocation {
    private int symbolIndex;
    private int specialSymbolIndex;
    private int type;

    protected void initElfRelocation(FactoryBundledWithBinaryReader reader, ElfHeader elfHeader, int relocationTableIndex, boolean withAddend) throws IOException {
        super.initElfRelocation(reader, elfHeader, relocationTableIndex, withAddend);
        long info = this.getRelocationInfo();
        if (elfHeader.isLittleEndian()) {
            info = DataConverter.swapBytes((long)info, (int)8);
        }
        LittleEndianDataConverter converter = elfHeader.isLittleEndian() ? LittleEndianDataConverter.INSTANCE : BigEndianDataConverter.INSTANCE;
        byte[] rSymBytes = BigEndianDataConverter.INSTANCE.getBytes((int)(info >>> 32));
        this.symbolIndex = converter.getInt(rSymBytes);
        this.specialSymbolIndex = (int)info >>> 24 & 0xFF;
        this.type = (int)info & 0xFFFFFF;
    }

    public int getSymbolIndex() {
        return this.symbolIndex;
    }

    public int getSpecialSymbolIndex() {
        return this.specialSymbolIndex;
    }

    public int getType() {
        return this.type;
    }

    public DataType toDataType() {
        Object dtName = "Elf64_MIPS_Rel";
        if (this.hasAddend()) {
            dtName = (String)dtName + "a";
        }
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), (String)dtName, 0);
        struct.add(QWORD, "r_offset", "location to apply the relocation action");
        struct.add(DWORD, "r_sym", null);
        struct.add(BYTE, "r_ssym", null);
        struct.add(BYTE, "r_rtype3", null);
        struct.add(BYTE, "r_rtype2", null);
        struct.add(BYTE, "r_rtype1", null);
        if (this.hasAddend()) {
            struct.add(QWORD, "r_addend", "a constant addend used to compute the relocatable field value");
        }
        return struct;
    }
}

