/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class X86_32_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 3;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 3) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.hasAddend() ? relocation.getAddend() : (long)memory.getInt(relocationAddress);
        ElfSymbol sym = null;
        long symbolValue = 0L;
        String symbolName = null;
        if (symbolIndex != 0) {
            sym = elfRelocationContext.getSymbol(symbolIndex);
        }
        if (sym != null) {
            symbolValue = elfRelocationContext.getSymbolValue(sym);
            symbolName = sym.getNameAsString();
        }
        long offset = (int)relocationAddress.getOffset();
        symbolName = symbolName == null ? "<no name>" : symbolName;
        boolean appliedSymbol = true;
        switch (type) {
            case 1: {
                int value = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value);
                break;
            }
            case 2: {
                int value = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, value);
                break;
            }
            case 3: {
                int value = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value);
                break;
            }
            case 4: {
                int value = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, value);
                break;
            }
            case 6: 
            case 7: {
                int value = (int)symbolValue;
                memory.setInt(relocationAddress, value);
                break;
            }
            case 9: {
                long dotgot = elfRelocationContext.getGOTValue();
                int value = (int)symbolValue + (int)addend - (int)dotgot;
                memory.setInt(relocationAddress, value);
                break;
            }
            case 5: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_386_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 35: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_386_TLS_DTPMOD32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 36: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_386_TLS_DTPOFF32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 37: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_386_TLS_TPOFF32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 14: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_386_TLS_TPOFF", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 8: {
                appliedSymbol = false;
                long base = program.getImageBase().getOffset();
                int value = elf.isPreLinked() ? memory.getInt(relocationAddress) + (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() : (int)(base + addend);
                memory.setInt(relocationAddress, value);
                break;
            }
            case 42: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_386_IRELATIVE", (String)symbolName, (String)"indirect computed relocation not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 10: {
                appliedSymbol = false;
                long dotgot = elfRelocationContext.getGOTValue();
                int value = (int)(dotgot + addend - offset);
                memory.setInt(relocationAddress, value);
                break;
            }
            default: {
                appliedSymbol = false;
                X86_32_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
        if (appliedSymbol && symbolIndex == 0) {
            X86_32_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)Long.toString(type), (String)"applied relocation with symbol-index of 0", (MessageLog)elfRelocationContext.getLog());
        }
    }
}

